#include "utils.hh"

const int _NERR = 20;
std::string ERR_STR[_NERR];

void partie_init()
{
    for(int i = 0; i < _NERR; i++)
        ERR_STR[i] = "inconnu !!";
    ERR_STR[OK] = "OK";
    ERR_STR[PA_INSUFFISANTS] = "PA_INSUFFISANTS";
    ERR_STR[PM_INSUFFISANTS] = "PM_INSUFFISANTS";
    ERR_STR[HORS_LIMITES] = "HORS_LIMITES";
    ERR_STR[DIRECTION_INVALIDE] = "DIRECTION_INVALIDE";
    ERR_STR[ID_NAIN_INVALIDE] = "ID_NAIN_INVALIDE";
    ERR_STR[OBSTACLE_MUR] = "OBSTACLE_MUR";
    ERR_STR[OBSTACLE_NAIN] = "OBSTACLE_NAIN";
    ERR_STR[OBSTACLE_CORDE] = "OBSTACLE_CORDE";
    ERR_STR[PAS_DE_CIBLE] = "PAS_DE_CIBLE";
    ERR_STR[NAIN_MORT] = "NAIN_MORT";
    ERR_STR[PAS_ACCROCHE] = "PAS_ACCROCHE";
    ERR_STR[DEJA_ACCROCHE] = "DEJA_ACCROCHE";
    ERR_STR[PAS_DE_CORDE] = "PAS_DE_CORDE";
    ERR_STR[DRAPEAU_INVALIDE] = "DRAPEAU_INVALIDE";
}

void jouer_tour()
{
    printf("\nTOUR %d\n", tour_actuel());

    for(int idxnain = 0; idxnain < NB_NAINS; idxnain++)
    {
        nain inain = info_nain(moi(), 0);

        dijk_sit deb = { inain.pos, inain.accroche, false, 0, 0, 0, 0, 0 };
        dijk_sit fin = { position_taverne(moi()), false, true, 0, 0, 0, 0, 0 };

        auto v = dijkstra(deb, fin);

        erreur ok = OK;

        for(action_hist& act : v)
        {
            switch(act.atype)
            {
                case ACTION_DEPLACER:
                    ok = deplacer(0, act.dir);
                    break;
                case ACTION_LACHER:
                    ok = lacher(0);
                    break;
                case ACTION_AGRIPPER:
                    ok = agripper(0);
                    break;
                case ACTION_MINER:
                    ok = miner(0, act.dir);
                    break;
                default:
                    puts("erreur: atype");
                    return;
            }

            if(ok != OK)
            {
                printf("erreur: %d %s  action %d %d\n", ok, ERR_STR[ok].c_str(), act.atype, act.dir);
                return;
            }
            else
            {
                printf("action %d %d\n", act.atype, act.dir);
            }
            
        }
    }
}

void partie_fin()
{
}

