#include "utils.hh"

const int _NERR = 20;
std::string ERR_STR[_NERR];

void marque_bonus()
{
    memset(BONUS, 0, sizeof(BONUS));
    for(auto ipos : liste_minerais())
    {
        minerai imin = info_minerai(ipos);
        BONUS[ipos.ligne][ipos.colonne] = imin.rendement;
    }

    position pos = position_taverne(adversaire());
    BONUS[pos.ligne][pos.colonne] = -INF;
}

void partie_init()
{
    for(int i = 0; i < _NERR; i++)
        ERR_STR[i] = "inconnu !!";
    ERR_STR[OK] = "OK";
    ERR_STR[PA_INSUFFISANTS] = "PA_INSUFFISANTS";
    ERR_STR[PM_INSUFFISANTS] = "PM_INSUFFISANTS";
    ERR_STR[HORS_LIMITES] = "HORS_LIMITES";
    ERR_STR[DIRECTION_INVALIDE] = "DIRECTION_INVALIDE";
    ERR_STR[ID_NAIN_INVALIDE] = "ID_NAIN_INVALIDE";
    ERR_STR[OBSTACLE_MUR] = "OBSTACLE_MUR";
    ERR_STR[OBSTACLE_NAIN] = "OBSTACLE_NAIN";
    ERR_STR[OBSTACLE_CORDE] = "OBSTACLE_CORDE";
    ERR_STR[PAS_DE_CIBLE] = "PAS_DE_CIBLE";
    ERR_STR[NAIN_MORT] = "NAIN_MORT";
    ERR_STR[PAS_ACCROCHE] = "PAS_ACCROCHE";
    ERR_STR[DEJA_ACCROCHE] = "DEJA_ACCROCHE";
    ERR_STR[PAS_DE_CORDE] = "PAS_DE_CORDE";
    ERR_STR[DRAPEAU_INVALIDE] = "DRAPEAU_INVALIDE";
}

void jouer_tour()
{
    if(tour_actuel() != 0) return;
    printf("\nTOUR %d\n", tour_actuel());

    marque_bonus();

    for(int idxnain = 0; idxnain < 1; idxnain++)
    {
        agripper(idxnain);

        nain inain = info_nain(moi(), 0);

        dag_sit deb;
        dag_sit fin;
        memset(&deb, 0, sizeof(deb));
        memset(&fin, 0, sizeof(fin));
        deb.pos = inain.pos;
        deb.accr = inain.accroche;
        deb.retour = false;

        fin.pos = position_taverne(moi());
        fin.accr = true;
        fin.retour = true;

        auto v = optimal(deb, fin);

        erreur ok = OK;

        for(action_hist& act : v)
        {
            printf("action %d %d\n", act.atype, act.dir);
            switch(act.atype)
            {
                case ACTION_DEPLACER:
                    ok = deplacer(idxnain, act.dir);
                    break;
                case ACTION_LACHER:
                    ok = lacher(idxnain);
                    break;
                case ACTION_AGRIPPER:
                    ok = agripper(idxnain);
                    break;
                case ACTION_MINER:
                    ok = miner(idxnain, act.dir);
                    break;
                default:
                    puts("erreur: atype");
                    return;
            }

            if(ok != OK)
            {
                printf("erreur: %d %s\n", ok, ERR_STR[ok].c_str());
                return;
            }
        }
    }
}

void partie_fin()
{
}

