#include <stdio.h>
#include <string.h>

#include "prologin.h"
#include "enumere.h"
#include "eval.h"
#include "utils.h"

struct position DEPLACEMENT[4] =
{ {  1,  0 },
  {  0,  1 },
  { -1,  0 },
  {  0, -1 } };

double score_pos[TAILLE_BANQUISE][TAILLE_BANQUISE];
void calc_score_pos()
{
    for(int i = 0; i < TAILLE_BANQUISE; i++)
    {
        for(int j = 0; j < TAILLE_BANQUISE; j++)
        {
            struct position p;
            p.ligne = i, p.colonne = j;

            if(type_case(p) == LIBRE)
                score_pos[i][j] = -1e10;
            else
                score_pos[i][j] = +1e10;
        }
    }

    static struct bfs_scorepos q[NCASES];
    memset(q, 0, sizeof(q));
    memset(score_pos, 0, sizeof(score_pos));

    int qpush = 0;
    int qpop = 0;

    struct alien_info_array laliens = liste_aliens();
    for(size_t i = 0; i < laliens.length; i++)
    {
        struct alien_info* ialien = laliens.datas + i;

        double isc = S_BASE_ALIEN;

        int visible = alien_visible(ialien);
        if(visible != 0)
        {
            int agcase = agent_sur_case(ialien->pos);

            if(agcase != moi())
            {
                if(agcase == adversaire())
                {
                    isc *= K_ALIEN_ADVERSAIRE;
                    isc += K_ADV_CAPTURE * alien_sur_case(ialien->pos)
                                         * ialien->capture_en_cours
                                         * ialien->capture_en_cours
                                         * ialien->capture_en_cours;
                }
                else
                    isc *= K_ALIEN_VIDE;

                isc += K_SCORE_ALIEN * ialien->points_capture
                                     * ialien->points_capture;

                if(visible > 0)
                    isc += K_VIS_CURR * visible;
                else if(visible < 0)
                    isc += -(K_VIS_SOON / (double) visible);
                else
                    isc = 0;

                q[qpush].pos = ialien->pos;
                q[qpush].score = isc;
                qpush = (qpush + 1) % NCASES;

                score_pos[ialien->pos.ligne][ialien->pos.colonne] = isc;
            }
        }
    }

    while(qpop != qpush)
    {
        struct bfs_scorepos* act = q + qpop;
        qpop = (qpop + 1) % NCASES;

        for(int i = NORD; i < OUEST; i++)
        {
            struct position* idep = DEPLACEMENT + i;

            struct bfs_scorepos* nouv = q + qpush;
            nouv->pos.ligne   = act->pos.ligne + idep->ligne;
            nouv->pos.colonne = act->pos.colonne + idep->colonne;
            nouv->score       = act->score / K_DIVSC;
            nouv->score      -= K_COUTACT * COUT_DEPLACEMENT;

            if(type_case(nouv->pos) == LIBRE
            && nouv->score > score_pos[nouv->pos.ligne][nouv->pos.colonne])
            {
                score_pos[nouv->pos.ligne][nouv->pos.colonne] = nouv->score;
                qpush = (qpush + 1) % NCASES;
            }

            nouv = q + qpush;
            nouv->pos.ligne   = act->pos.ligne   + idep->ligne;
            nouv->pos.colonne = act->pos.colonne + idep->colonne;
            nouv->score       = act->score / K_DIVSC;
            nouv->score      -= K_COUTACT * COUT_GLISSADE;

            while(type_case(nouv->pos) == LIBRE
               && agent_sur_case(nouv->pos) == -1)
            {
                nouv->pos.ligne   += idep->ligne;
                nouv->pos.colonne += idep->colonne;
            }

            nouv->pos.ligne   -= idep->ligne;
            nouv->pos.colonne -= idep->colonne;

            if(type_case(nouv->pos) == LIBRE
            && nouv->score > score_pos[nouv->pos.ligne][nouv->pos.colonne])
            {
                score_pos[nouv->pos.ligne][nouv->pos.colonne] = nouv->score;
                qpush = (qpush + 1) % NCASES;
            }
        }
    }

    for(size_t i = 0; i < laliens.length; i++)
    {
        struct alien_info* ialien = laliens.datas + i;
        struct position*   iapos  = &ialien->pos;

        if(alien_sur_case(*iapos))
        {
            for(int j = NORD; j < OUEST; j++)
            {
                struct position* idep = DEPLACEMENT + j;

                struct position pdir;
                pdir.ligne   = iapos->ligne   + idep->ligne;
                pdir.colonne = iapos->colonne + idep->colonne;

                struct position pinv;
                pinv.ligne   = iapos->ligne   - idep->ligne;
                pinv.colonne = iapos->colonne - idep->colonne;

                double* isc = &score_pos[pdir.ligne][pdir.colonne];

                if(agent_sur_case(*iapos) == moi())
                {
                    if(agent_sur_case(pinv) == adversaire())
                        *isc *= K_DEF_BLOQ;
                    else
                        *isc = 0;
                }
                else if(agent_sur_case(*iapos) == adversaire())
                {
                    if(!(agent_sur_case(pinv) == -1
                    && type_case(pinv) != LIBRE
                    && agent_sur_case(pdir) == -1))
                        *isc = 0;
                }
            }
        }
    }

}

double eval()
{
    struct position pagent = position_agent(moi(), agent_simul);

    double sc = score_pos[pagent.ligne][pagent.colonne];

    if(alien_sur_case(pagent))
    {
        for(int i = NORD; i < OUEST; i++)
        {
            struct position* idep = DEPLACEMENT + i;

            struct position pdir;
            pdir.ligne   = pagent.ligne   + idep->ligne;
            pdir.colonne = pagent.colonne + idep->colonne;

            struct position pinv;
            pinv.ligne   = pagent.ligne   - idep->ligne;
            pinv.colonne = pagent.colonne - idep->colonne;

            if(agent_sur_case(pdir) == adversaire()
            && type_case(pinv) == LIBRE
            && agent_sur_case(pinv) != moi())
                sc /= K_DIV_PETREPOUSSE;
        }
    }

    return sc;
}
