#include "prologin.hh"
#include "fonctions.h"
#include <vector>
#include <iostream>

using namespace std;

void partie_init()
{
    monId = moi();
    autreId = adversaire();
}

bool transmuterPetit(int limite)
{
    position min;
    int mini = INFINI;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
        for(int j = 0; j < TAILLE_ETABLI; j++)
        {
            position iPos = makepos(i, j);
            int iTaille = taille_region(iPos, monId);
            if(iTaille >= limite && mini > iTaille)
            {
                mini = iTaille;
                min = iPos;
            }
        }
    }

    if(mini != INFINI)
    {
        transmuter(min);
        return true;
    }
    return false;
}

position grosseRegion(bool chercheOr)
{
    position max;
    max.ligne = INFINI;
    int maxi = -INFINI;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
        for(int j = 0; j < TAILLE_ETABLI; j++)
        {
            position iPos = makepos(i, j);
            int iTaille = taille_region(iPos, monId);

            int iVal;
            if(chercheOr)
                iVal = quantite_transmutation_or(iTaille);
            else
                iVal = quantite_transmutation_catalyseur(iTaille);

            if(maxi < iVal && iVal >= 3)
            {
                maxi = iVal;
                max = iPos;
            }
        }
    }

    return max;
}

void ajouteCatalyseurs(position reg)
{
    vector<position> posReg = positions_region(reg, monId);
cout << posReg.size() << " " << reg.ligne << endl;
    for(int i = 0; i < posReg.size(); i++)
    {
        for(int x = 0; x < 4; x++)
        {
            position iDep = makepos(DEPS[x][0], DEPS[x][1]);
            position iPos = iDep + posReg[i];

            if(type_case(iPos, monId) != VIDE && type_case(iPos, monId) != type_case(posReg[0], monId) && nombre_catalyseurs() > 0)
                cout << "vcat " << catalyser(iPos, monId, type_case(posReg[0], monId)) << endl;
        }
    }
}

int nbCases(case_type type, int id)
{
    int nb = 0;

    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
        for(int j = 0; j < TAILLE_ETABLI; j++)
        {
            if(type_case(makepos(i, j), autreId) == type)
            {
                nb++;
            }
        }
    }

    return nb;
}

void donnerMerde()
{
    case_type min;
    int mini = INFINI;

    for(int type = PLOMB; type < MERCURE; type++)
    {
        int cpt = nbCases((case_type) type, autreId);
        if(cpt < mini)
        {
            mini = cpt;
            min = (case_type) type;
        }
    }

    echantillon t = echantillon_tour();
    if(nbCases(t.element1, autreId) > nbCases(t.element2, autreId))
    {
        t.element1 = min;
    }
    else
    {
        t.element2 = min;
    }

    donner_echantillon(t);
}

void utiliserCatalyseurs()
{
    while(nombre_catalyseurs() > 0)
    {
        position maxPos;
        case_type maxType;
        int maxi = -INFINI;

        int iId = autreId;
        for(int __i = 0; __i < 2; __i++)
        {
            for(int i = 0; i < TAILLE_ETABLI; i++)
            {
                for(int j = 0; j < TAILLE_ETABLI; j++)
                {
                    for(int k = PLOMB; k < MERCURE; k++)
                    {
                        position p = makepos(i, j);
                        case_type c = (case_type) k;

                        int avant = taille_region(p, autreId);
                        catalyser(p, autreId, c);
                        int apres = taille_region(p, autreId);
                        annuler();

                        int iScore = avant - apres;
                        if(iId == monId)
                            iScore = apres - avant;

                        if(maxi < iScore)
                        {
                            maxPos = p;
                            maxType = c;
                            maxi     = iScore;
                        }
                    }
                }
            }
            iId = monId;
        }
    }
}
