
#include "prologin.hh"
#include <vector>

using namespace std;

const int INFINI = 1000 * 1000 * 1000;
const int DEPS[4][2] = { { 1, 0 }, { 0, 1 }, { -1, 0 }, { 0, -1 } };

int monId, autreId;

void partie_init()
{
    monId = moi();
    autreId = adversaire();
}

int random(int a, int b)
{
    return rand() % (b - a) + a;
}

position operator+(position a, position b)
{
    position x;
    x.ligne = a.ligne + b.ligne;
    x.colonne = b.colonne + b.colonne;
    return x;
}

position makepos(int a, int b)
{
    position p;
    p.ligne = a, p.colonne = b;
    return p;
}

void transmuterPetit()
{
    fprintf(stderr, "Debut transmuterPetit\n", );
    position min;
    int mini = INFINI;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
        for(int j = 0; j < TAILLE_ETABLI; j++)
        {
            position iPos = makepos(i, j);
            int iTaille = taille_region(iPos, monId);
            if(iTaille >= 3 && mini > iTaille)
            {
                mini = iTaille;
                min = iPos;
            }
        }
    }
        fprintf(stderr, "fin transmuterPetit %d\n",     transmuter(min));


}

position grosseRegion(bool chercheOr)
{
    position max;
    int maxi = -INFINI;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
        for(int j = 0; j < TAILLE_ETABLI; j++)
        {
            position iPos = makepos(i, j);
            int iTaille = taille_region(iPos, monId);

            int iVal;
            if(chercheOr)
                iVal = quantite_transmutation_or(iTaille);
            else
                iVal = quantite_transmutation_catalyseur(iTaille);

            if(maxi < iVal)
            {
                maxi = iVal;
                max = iPos;
            }
        }
    }

    return max;
}

void ajouteCatalyseurs(position reg)
{
    vector<position> posReg = positions_region(reg, autreId);

    for(int i = 0; i < posReg.size(); i++)
    {
        for(int x = 0; x < 4; x++)
        {
            position iDep = makepos(DEPS[x][0], DEPS[x][1]);
            position iPos = iDep + posReg[i];

            if(taille_region(iPos, monId) == 1 && nombre_catalyseurs() > 0)
                catalyser(iPos, monId, type_case(iPos, autreId));
        }
    }
}

int nbCases(case_type type, int id)
{
    int nb = 0;

    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
        for(int j = 0; j < TAILLE_ETABLI; j++)
        {
            if(type_case(makepos(i, j), autreId) == type)
            {
                nb++;
            }
        }
    }

    return nb;
}

void donnerMerde()
{
    case_type min;
    int mini = INFINI;

    for(int type = PLOMB; type < MERCURE; type++)
    {
        int cpt = nbCases((case_type) type, autreId);
        if(cpt < mini)
        {
            mini = cpt;
            min = (case_type) type;
        }
    }

    echantillon t = echantillon_tour();
    if(nbCases(t.element1, autreId) > nbCases(t.element2, autreId))
    {
        t.element1 = min;
    }
    else
    {
        t.element2 = min;
    }

    donner_echantillon(t);
}

int dernGrosseTrans = 0;

void jouer_tour()
{
    echantillon monEchantillon = echantillon_tour();

    vector<position_echantillon> positionsPossibles = placements_possible_echantillon(monEchantillon, monId);

    while(positionsPossibles.empty())
    {
        transmuterPetit();
        positionsPossibles = placements_possible_echantillon(monEchantillon, monId);
    }

    int x = random(0, positionsPossibles.size());
    x = (random(0, 2) == 0 ? x : 0);
    placer_echantillon(positionsPossibles[x].pos1, positionsPossibles[x].pos2);


    while(tour_actuel() - dernGrosseTrans >= 45 || nombre_catalyseurs() > 0)
    {
        position regCata = grosseRegion(false);
        catalyser(regCata, monId, type_case(regCata, autreId));

        position regOr = grosseRegion(true);
        ajouteCatalyseurs(regOr);
        transmuter(regOr);

        dernGrosseTrans = tour_actuel();
    }

    donnerMerde();
}

void partie_fin()
{

}
