/*
 *
 *  Prologin 2017 - Lundi 1er mai 2017
 *
 *
 *  Champion final
 *    Tacos XXVII v2 - Esteban CHRISTIAN (21.11.2001)
 *
 *
 *  Strategie:
 *
 *    Le champion commence par compter les cases vides sur son plateau
 *    Si il y en a 7 ou moins ou qu'il joue son dernier tour il entre en mode transmuation
 *
 *    Il commence par poser son echantillon:
 *      - Au milieu si c'est le 1er tour
 *      - Sinon il essaye de le poser adjacent a la plus grande region positionsPossibles
 *        il transmute alors si necessaire des petites region qui empechent la pose
 *
 *    Si il est en mode transmutation il cherche alors a accumuler des catalyseurs
 *    en transmutant les plus grosses regions de souffre et mercure
 *
 *    Il utilise ensuite ses catalyseurs:
 *      - Soit pour agrandir ou fusionner plusieurs grosses regions sur son plateau
 *      - Soit pour scinder et diviser les regions adverses
 *
 *    Si il est en mode transmutation il va alors transmuter la region qui lui rapportera
 *    le plus d'or
 *
 *    Si il joue son dernier tour, il va alors utiliser comme decrit ci-dessus les
 *    catalyseurs eventuellement obtenus dans la derniere transmutation puis transmute
 *    toutes les regions de taille 3 ou plus
 *
 *    Il utilise finalement les eventuels catalyseurs restants de la maniere decrite
 *
 *    Pour finir, l'echantillon qu'il donnera a l'adversaire contiendra les deux
 *    elements que ce dernier a le moins sur son plateau
 *
 */

#include "prologin.hh"
#include "fonctions.h"
#include <vector>
#include <iostream>

using namespace std;

const int INFINI = 1000 * 1000 * 1000;
const int DEPS[5][2] = { { 1, 0 }, { 0, 1 }, { -1, 0 }, { 0, -1 }, { 0, 0 } };

int monId, autreId;

void partie_init()
{
    monId = moi();
    autreId = adversaire();
}

void jouer_tour()
{
    int nbVides = 0;
    for(int i = 0; i < TAILLE_ETABLI; i++) // Comptage des cases vides
    {
        for(int j = 0; j < TAILLE_ETABLI; j++)
        {
            if(est_vide(makepos(i, j), monId))
                nbVides++;
        }
    }

    bool transMode = false;
    if(tour_actuel() >= 149 || nbVides <= 7) // Entrer en mode transmutation ou pas
        transMode = true;

    poserEchantillon();

    position regCata = grosseRegion(false);
    position regOr = grosseRegion(true);

    if(transMode)
    {
        // Accumuler des catalyseurs
        while(regCata.ligne != INFINI
            && !(regCata.ligne == regOr.ligne && regCata.colonne == regOr.colonne))
        {
            transmuter(regCata);
            regCata = grosseRegion(false);

        }
    }

    utiliserCatalyseurs();

    if(transMode)
    {
        regOr = grosseRegion(true); // Transmuter la region la plus rentable
        transmuter(regOr);
    }

    if(tour_actuel() >= 149)
    {
        utiliserCatalyseurs();

        for(int i = 0; i < TAILLE_ETABLI; i++) // Vider son plateau en fin de partie
        {
            for(int j = 0; j < TAILLE_ETABLI; j++)
            {
                position iPos = makepos(i, j);
                if(taille_region(iPos, monId) >= 3)
                    transmuter(iPos);
            }
        }
    }

    utiliserCatalyseurs();

    donnerMerde(); // Donner un echantillon a l'adversaire
}

void partie_fin()
{
    // printf("42");
}


// J'AI PERDU.
