#include "ai.hh"
#include <iostream>

/*
 * The idea here is to progressively add positions to a buildQueue,
 * then build from the queue, and rebuild it when it is empty.
 *
 * We define a target, go for it, and define a new one when it has been reached
 */

void AI::aimForKeyPosition() {
    /*
     * This might be the critical point of the match, make sure we keep it,
     * and build two pipes to make sure we get it
     */
    targetReached = false;
    target = analyzer->keyPosition();
    position to = analyzer->nextPipeToBase(target);
    buildQueue.push(to);
    analyzer->linkPositions(to, target, &buildQueue);

    // second pipe
    position _to, _target;
    if (to.x == target.x) {
        _to = new_position(to.x+1, to.y) ;
        _target = new_position(target.x +1, target.y);
    } else { //if (to.y == target.y) {
        _to = new_position(to.x, to.y+1) ;
        _target = new_position(target.x, target.y+1);
    }
    buildQueue.push(_to);
    analyzer->linkPositions(_to, _target, &buildQueue);
}

/*
 * Called when the buildQueue is empty. Defines a new strategy
 */
void AI::rebuildQueue() {
    if(!allTargetsReached) {
        if (analyzer->distanceToNetwork(target) == 0) {
            if (est_pulsar(target)) analyzer->circlePulsar(target, &buildQueue);
            targetReached = true;
        }
        if (targetReached) {
            /*
             * Select the new target
             * if there are no more targets, set reached to true so we don't get stuck in a loop
             */
            try {
                targetReached = false;
                analyzer->updatePulsars();
                analyzer->sortPulsars();
                target = analyzer->nextPulsar();
                targetType = analyzer->shortestLink(target);
            } catch (int err) {
                if (err == NO_TARGETS_LEFT) targetReached = true;
            }
        }
        position next;
        if (targetType == TO_BASE) {
            next = analyzer->nextPipeToBase(target) ;
        } else {
            next = analyzer->nextPipeToNetwork(target);
        }

        if (target.x - next.x == 0 && target.y - next.y == 0) {
            allTargetsReached = true;
        } else {
            buildQueue.push(next);
            if (targetType == TO_BASE) analyzer->linkPositions(next, target, &buildQueue) ;
        }
    }
    stage++;
}


void AI::continueBuilding(int count) {
    // follow the program as long as there is one. If it is missing, build one
    for (int i=0; i<count; i++) {
        if (buildQueue.size() > 0 ) {
            position pos = buildQueue.front();
            construire(pos);
            buildQueue.pop();
            continue;
        } else {
            rebuildQueue();
        }
    }
    
}

// just a wrapper
void AI::optimizeSucking() {
    analyzer->moveSucking();
}

void AI::repare() {
    try {
        vector<position> destroyed = hist_tuyaux_detruits();
        bool circleIt = false;
        if (destroyed.size() == 0) {
            if (destroyLoop) destroyLoop = false;
            return;
        } else {
            for (position pos : destroyed) {
                deblayer(pos);
                construire(pos);

                if (!destroyLoop) {
                    destroyLoop = true;
                } else {
                    if (destroyedPosition.x == pos.x && destroyedPosition.y == pos.y) {
                        /*
                         * He wants to get rid of us here.
                         * This position seems to be important, make sure we control it, but don't
                         * do it unless he keeps attacking it, we'd lose time
                         */
                        circleIt = true;
                    }
                }
                int surroundings[4][2] = SURROUNDINGS;
                position from = new_position(0,0);
                for (int i=0; i<4; i++) {
                    position tmp = new_position(pos.x + surroundings[i][0], pos.y + surroundings[i][1]);
                    if (est_tuyau(tmp)) {
                        vector<position> dir = directions_plasma(tmp);
                        for (position to : dir) {
                            if (to.x == pos.x && to.y == pos.y) {
                                from = tmp;
                                break;
                            }
                        }
                    }
                }
                if (from.x != 0 && from.y != 0) {
                    ameliorer(from);
                    // build an alternative route
                    // this should be temporary
                    if (circleIt) analyzer->circlePulsar(pos, &buildQueue, true);
                }
                destroyedPosition = pos;
            }
        }
    } catch (out_of_range oor) { }
}

