/*
 * A l'attention des Organisateurs :
 * 
 * ORGANISATION DES FICHIERS
 * La classe AI contient les fonctions qui sont considerees de "logique", et de prise de decision
 * La classe Analyzer sert a interpreter la situation pour que l'IA puisse prendre ses decisions
 *
 * Le fichier defines.hh sert uniquement a initialiser quelques constantes pour la lisibilite
 *
 * STRATEGIE GENERALE
 * L'idee est de rester pacifique pour ne pas gaspiller de plasma, et de recuperer en priorite les
 * pulsars les plus proches de nos bases, en privilegiant tout de meme les pulsars rapides  a atteindre.
 * Milky Way etait tres centree sur l'etoile centrale. On cherchera donc toujours a rejoindre d'abord
 * le pulsar avec le plus d'energie, au cas ou celui ci serait decisif aussi autre part
 *
 * STRATEGIE DEFENSIVE
 * La strategie offensive etant inexistante, l'importance de cette partie est capitale
 * Si un tuyau est detruit, il faut le reconstruire, et ameliorer son pere dans le reseau,
 * pour faire passer les plasmas plus vite sur ce point difficile. Si l'opposant s'acharne
 * sur le meme tuyau, il doit etre important (apres tout sinon il arreterait). On construit 
 * donc autour de lui pour pouvoir le court-circuiter et ne pas interrompre le flux meme 
 * s'il est detruit 
 * faille: si il detruit un par un les tuyaux non renforces, on a un probleme non regle...
 */

#include "prologin.hh"
#include <algorithm>
#include <iostream>
#include <queue>

#include "defines.hh"

#include "library.hh"
#include "ai.hh"

using namespace std;

AI *ai;

/* Initialization */
void partie_init()
{
    ai = new AI();
    /* 
     * Get a central position, and try to get to it, improves the 
     *  performance of following algorithm by getting close to the pulsars
     */
    ai->aimForKeyPosition();
}

/* Main */
void jouer_tour()
{
    ai->repare();
    /*
     * For an unknown reason, all action points are not used...
     * Loop to make sure they are used! 
     * The counter avoids timeouts in case we are stuck in a loop
     */
    int securityCounter = 0;
    while (points_action() > 0 && securityCounter < 5) {
        ai->continueBuilding(points_action());
        securityCounter++;
    }
    if (securityCounter == 5) cout << "Error: could not use all points!" << endl;
    /* As it does not cost anything, rearrange the sucking points to maximize plasma sucking */
    ai->optimizeSucking();
}

/* End */
void partie_fin()
{

}

