#include <vector>
#include <queue>
#include <algorithm>
#include <iostream>

#include "defines.hh"

#include "prologin.hh"
#include "library.hh"

using namespace std;

class Analyzer {
private:
    vector<position> pulsars;

public:
    Analyzer() {
        pulsars = liste_pulsars();
    }

    void linkPositions(position from, position to, queue<position> *buildQueue) ;

    void circlePulsar(position pos, queue<position> *buildQueue, bool urgent = false) ;

    void updatePulsars() ;

    void sortPulsars() ;

    position nextPulsar() ;

    int distanceToNetwork(position pos) ;

    int distanceToBase(position pos) ;
    
    position nextPipeToNetwork(position pos);

    position nextPipeToBase(position pos);

    short shortestLink(position pos);

    void moveSucking();

    void sortSuckingPoints(vector<position> *unused, vector<position> *used);

    bool isConnected(position pos);

    position keyPosition() ;
};
