#include "prologin.hh"
#define OUT_OF_MAP -1
#define POSITION_MATCH 0

/* Basic Library */
position new_position(int x, int y) {
    position pos;
    pos.x = x;
    pos.y = y;
    return pos;
}

void right(position *pos) {
    if (pos->x < TAILLE_TERRAIN - 1) {
        pos->x++;
    } else throw OUT_OF_MAP;
}
void left(position *pos) {
    if (pos->x > 0 + 1) {
        pos->x--;
    } else throw OUT_OF_MAP;
}
void up(position *pos) {
    if (pos->y > 0 + 1) {
        pos->y--;
    } else throw OUT_OF_MAP;
}
void down(position *pos) {
    if (pos->y < TAILLE_TERRAIN - 1) {
        pos->y++;
    } else throw OUT_OF_MAP;
}

void moveTowards(position *from, position *to) {
    int dx = from->x - to->x;
    int dy = from->y - to->y;

    if (dx != 0) {
        (dx > 0) ? left(from) : right(from);
    } else if (dy != 0) {
        (dy > 0) ? up(from) : down(from);
    } else {
        throw POSITION_MATCH;
    }
}
