#include "analyzer.hh"

// if the network si not close enough, it is better to connect with the base, this is the threshold
#define DELTA_BASE_NETWORK 12

// if a pulsar is closer than this, go for it directly from base
#define PRIORITY_THRESHOLD 10

void Analyzer::linkPositions(position from, position to, queue<position> *buildQueue) {
    position pos = from;
    try {
        while(true) {
            moveTowards(&pos, &to);
            if (type_case(pos) == VIDE) (*buildQueue).push(pos);
            else if(type_case(pos) == PULSAR) circlePulsar(pos, buildQueue);
        }
    } catch (int err) {
        if (err == OUT_OF_MAP) cout << "Failed to leave arena" << endl;
    }
}

void Analyzer::circlePulsar(position pos, queue<position> *buildQueue, bool urgent) {
    int surroundings[8][2] = EXTENDED_SURROUNDINGS;
    queue<position> urgentQueue;
    for(int i=0; i<8; i++) {
        position tmp = new_position(pos.x + surroundings[i][0], pos.y + surroundings[i][1]);
        if (type_case(tmp) == VIDE) {
            if (urgent) {
                urgentQueue.push(tmp);
            } else {
                buildQueue->push(tmp);
            }
        }
    }

    if (urgent) {
        while (!buildQueue->empty()) {
            urgentQueue.push(buildQueue->front());
            buildQueue->pop();
        }
        buildQueue->swap(urgentQueue);
    }
}

void Analyzer::updatePulsars() {
    // Remove the dead pulsars from the list, we don't care about them anymore
    try {
        for (int i=pulsars.size() -1; i>=0; i--) {
            pulsar_info info = info_pulsar(pulsars.at(i));
            if (info.pulsations_restantes == 0) {
                pulsars.erase(pulsars.begin() + i);
            }
        }
    } catch (out_of_range oor) { }
}

void Analyzer::sortPulsars() {
    /*
     * Sort by closest to network
     * Needs to allow pulsars close to base to be selected
     */
    try {
        vector<position> tmp;
        int distances[pulsars.size()];
        for (uint i=0; i<pulsars.size(); i++) {
            position pos = pulsars.at(i);
            int d = distanceToNetwork(pos);
            if (d == 0) {
                distances[i] = INF - 1;
            } else {
                int b = distanceToBase(pos);
                if (b < PRIORITY_THRESHOLD) {
                    tmp.push_back(pos);
                    distances[i] = INF;
                } else {
                    distances[i] = (d + DELTA_BASE_NETWORK < b) ? d : b ;
                }
            }
        }
        // ugly sorting in O(n**2) but ok for now
        int alreadySorted = tmp.size();
        for (uint i=0; i<pulsars.size()-alreadySorted; i++) {
            short ind = -1;
            short min = INF;
            for (uint j=0; j<pulsars.size(); j++) {
                if (distances[j] < min) {
                    min = distances[j];
                    ind = j;
                }
            }
            tmp.push_back(pulsars.at(ind));
            distances[ind] = INF;
        }
        pulsars.swap(tmp);
    } catch (out_of_range orr) {
        cout << "OOR, unable to sort" << endl;
    }

}

position Analyzer::nextPulsar() {
    if (pulsars.empty()) throw EMPTY;
    return pulsars.front();
}


/*
 * Here go four ugly BFS alforithms that were copy-pasted, I hope I have time to rewrite this
 */
int Analyzer::distanceToNetwork(position pos) {
    vector<position> explored;
    queue<position> currentQueue;
    queue<position> nextQueue;
    int distance = 0;

    explored.push_back(pos);
    currentQueue.push(pos);
    while (true) {
        while( !currentQueue.empty() ) {
            position next = currentQueue.front();
            int surroundings[4][2] = SURROUNDINGS;
            for (int i=0; i<4; i++) {
                position childPos = new_position(next.x + surroundings[i][0], next.y + surroundings[i][1]);
                if (type_case(childPos) == BASE) {
                    if (proprietaire_base(childPos) == moi()) return distance;
                } else {
                    if (est_tuyau(childPos)) return distance;
                    if (est_debris(childPos) || est_pulsar(childPos)) continue;
                    if ( count(explored.begin(), explored.end(), childPos) == 0 ) {
                        nextQueue.push(childPos);
                        explored.push_back(childPos);
                    }
                }
            }
            currentQueue.pop();
        }
        distance++;
        currentQueue.swap(nextQueue);
    }
}

int Analyzer::distanceToBase(position pos) {
    vector<position> explored;
    queue<position> currentQueue;
    queue<position> nextQueue;
    int distance = 0;

    explored.push_back(pos);
    currentQueue.push(pos);
    while (true) {
        while( !currentQueue.empty() ) {
            position next = currentQueue.front();
            int surroundings[4][2] = SURROUNDINGS;
            for (int i=0; i<4; i++) {
                position childPos = new_position(next.x + surroundings[i][0], next.y + surroundings[i][1]);
                if (type_case(childPos) == BASE) {
                    if (proprietaire_base(childPos) == moi()) return distance;
                } else if (type_case(childPos) == INTERDIT) {
                    
                } else {
                    if (est_tuyau(childPos)) continue;
                    if (est_debris(childPos) || est_pulsar(childPos)) continue;
                    if ( count(explored.begin(), explored.end(), childPos) == 0 ) {
                        nextQueue.push(childPos);
                        explored.push_back(childPos);
                    }
                }
            }
            currentQueue.pop();
        }
        distance++;
        currentQueue.swap(nextQueue);
    }
}

/*
 * Change this so that it chooses the cheapest way if both are of the same length
 */
position Analyzer::nextPipeToNetwork(position pos) {
    vector<position> explored;
    queue<position> currentQueue;
    queue<position> nextQueue;
        
    explored.push_back(pos);
    currentQueue.push(pos);
    while (true) {
        while( !currentQueue.empty() ) {
            position next = currentQueue.front();
            int surroundings[4][2] = { {0,1}, {1,0}, {0, -1}, {-1, 0}};
            for (int i=0; i<4; i++) {
                position childPos = new_position(next.x + surroundings[i][0], next.y + surroundings[i][1]);
                if (type_case(childPos) == BASE) {
                    if (proprietaire_base(childPos) == moi()) return next;
                } else {
                    if (est_tuyau(childPos)) return next;
                    if (est_debris(childPos) || est_pulsar(childPos)) continue;
                    if ( count(explored.begin(), explored.end(), childPos) == 0 ) {
                        nextQueue.push(childPos);
                        explored.push_back(childPos);
                    }
                }
            }
            currentQueue.pop();
        }
        currentQueue.swap(nextQueue);
    }

}

position Analyzer::nextPipeToBase(position pos) {
    vector<position> explored;
    queue<position> currentQueue;
    queue<position> nextQueue;

    explored.push_back(pos);
    currentQueue.push(pos);
    while (true) {
        while( !currentQueue.empty() ) {
            position next = currentQueue.front();
            int surroundings[4][2] = { {0,1}, {1,0}, {0, -1}, {-1, 0}};
            for (int i=0; i<4; i++) {
                position childPos = new_position(next.x + surroundings[i][0], next.y + surroundings[i][1]);
                if (type_case(childPos) == BASE) {
                    if (proprietaire_base(childPos) == moi()) return next;
                } else if (type_case(childPos) == INTERDIT) {
                    
                } else {
                    if (est_tuyau(childPos)) continue;
                    if (est_debris(childPos) || est_pulsar(childPos)) continue;
                    if ( count(explored.begin(), explored.end(), childPos) == 0 ) {
                        nextQueue.push(childPos);
                        explored.push_back(childPos);
                    }
                }
            }
            currentQueue.pop();
        }
        currentQueue.swap(nextQueue);
    }

}

short Analyzer::shortestLink(position pos) {
    int n = distanceToNetwork(pos);
    if (n == 0) return TO_NETWORK;
    return (distanceToBase(pos) < n + DELTA_BASE_NETWORK) ? TO_BASE : TO_NETWORK;
}

void Analyzer::moveSucking() {
    vector<position> used, unused;
    sortSuckingPoints(&unused, &used);
    if (used.empty() || unused.empty()) return;
    deplacer_aspiration(unused.front(), used.front());
}

void Analyzer::sortSuckingPoints(vector<position> *unused, vector<position> *used) {
    vector<position> base = ma_base();
    vector<position> *priority = new vector<position>(), *full = new vector<position>();
    for (position pos : base) {
        if (isConnected(pos)) {
            if (puissance_aspiration(pos) == 0) {
                priority->push_back(pos);
            } else if (puissance_aspiration(pos) == 5) {
                full->push_back(pos);
            } else {
                used->push_back(pos);
            }
        } else {
            if (puissance_aspiration(pos) == 0) continue;
            unused->push_back(pos);
        }
    }

    if (!priority->empty()) {
        used->swap(*priority);
        if (unused->empty()) unused->swap(*full);
    }
}

bool Analyzer::isConnected(position pos) {
    if (type_case(pos) != BASE) throw -1;
    if (pos.x == 0 ) return est_tuyau(new_position(pos.x+1, pos.y));
    if (pos.y == 0 ) return est_tuyau(new_position(pos.x, pos.y+1));
    if (pos.x == 38) return est_tuyau(new_position(pos.x-1, pos.y));
    if (pos.y == 38) return est_tuyau(new_position(pos.x, pos.y-1));
    throw -1;
}

position Analyzer::keyPosition() {
    vector<position> pulsars = liste_pulsars();
    position best;
    int amount = 0;
    for(position pos : pulsars) {
        pulsar_info info = info_pulsar(pos);
        int a = info.pulsations_totales * info.puissance;
        if (amount < a) {
            amount = a;
            best = pos;
        }
    }
    return best;
}
