/*!
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_c.rb
*/

#pragma once

#include <stdlib.h>
#include <stdbool.h>

/*!
** Taille de la banquise (longueur et largeur).
*/
# define TAILLE_BANQUISE           25

/*!
** Nombre de tours à jouer avant la fin de la partie.
*/
# define NB_TOURS                  100

/*!
** Nombre de points d'action par tour par agent.
*/
# define NB_POINTS_ACTION          8

/*!
** Nombre de point d'action que coûte un déplacement.
*/
# define COUT_DEPLACEMENT          1

/*!
** Nombre de points d'action que coûte une glissade.
*/
# define COUT_GLISSADE             3

/*!
** Nombre de points d'action nécessaires pour pousser un agent.
*/
# define COUT_POUSSER              5

/*!
** Nombre d'agents par joueur.
*/
# define NB_AGENTS                 4

/*!
** Nombre de tours nécessaires pour capturer un alien.
*/
# define NB_TOURS_CAPTURE          3

/*!
** Types de cases
*/
typedef enum case_type {
  LIBRE, /* <- Case libre */
  MUR, /* <- Mur */
  ERREUR, /* <- Erreur */
} case_type;


/*!
** Points cardinaux
*/
typedef enum direction {
  NORD, /* <- Direction : nord */
  EST, /* <- Direction : est */
  SUD, /* <- Direction : sud */
  OUEST, /* <- Direction : ouest */
} direction;


/*!
** Erreurs possibles
*/
typedef enum erreur {
  OK, /* <- L'action s'est effectuée avec succès. */
  PA_INSUFFISANTS, /* <- Votre agent ne possède pas assez de points d'action pour réaliser cette action. */
  POSITION_INVALIDE, /* <- La position spécifiée n'est pas sur la banquise. */
  OBSTACLE_MUR, /* <- La position spécifiée est un mur. */
  OBSTACLE_AGENT, /* <- La position spécifiée est un agent. */
  DEPLACEMENT_HORS_LIMITES, /* <- Ce déplacement fait sortir un agent des limites de la banquise. */
  DIRECTION_INVALIDE, /* <- La direction spécifiée n'existe pas. */
  ID_AGENT_INVALIDE, /* <- L'agent spécifié n'existe pas. */
  RIEN_A_POUSSER, /* <- Aucun agent à pousser dans la direction indiquée. */
  DRAPEAU_INVALIDE, /* <- Le drapeau spécifié n'existe pas. */
} erreur;


/*!
** Types d'actions
*/
typedef enum action_type {
  ACTION_DEPLACER, /* <- Action ``deplacer`` */
  ACTION_GLISSER, /* <- Action ``glisser`` */
  ACTION_POUSSER, /* <- Action ``pousser`` */
} action_type;


/*!
** Types de drapeaux de débug
*/
typedef enum debug_drapeau {
  AUCUN_DRAPEAU, /* <- Aucun drapeau, enlève le drapeau présent */
  DRAPEAU_BLEU, /* <- Drapeau bleu */
  DRAPEAU_VERT, /* <- Drapeau vert */
  DRAPEAU_ROUGE, /* <- Drapeau rouge */
} debug_drapeau;


struct position;
struct alien_info;
struct action_hist;

typedef struct direction_array {
  direction* datas;
  size_t length;
} direction_array;

typedef struct alien_info_array {
  struct alien_info* datas;
  size_t length;
} alien_info_array;

typedef struct action_hist_array {
  struct action_hist* datas;
  size_t length;
} action_hist_array;

/*!
** Position sur la banquise, donnée par deux coordonnées.
*/
typedef struct position {
  int ligne;  /* <- Coordonnée : ligne */
  int colonne;  /* <- Coordonnée : colonne */
} position;


/*!
** Alien à capturer durant la mission.
*/
typedef struct alien_info {
  position pos;  /* <- Position de l'alien */
  int points_capture;  /* <- Nombre de points obtenus pour la capture de cet alien */
  int tour_invasion;  /* <- Tour où l'alien débarque sur la banquise */
  int duree_invasion;  /* <- Nombre de tours où l'alien reste sur la banquise */
  int capture_en_cours;  /* <- Nombre de tours de la capture en cours, l'alien est considéré comme capturé si la variable atteint NB_TOURS_CAPTURE */
} alien_info;


/*!
** Action de déplacement représentée dans l'historique.
*/
typedef struct action_hist {
  action_type atype;  /* <- Type de l'action */
  int id_agent;  /* <- Numéro de l'agent concerné par l'action */
  direction dir;  /* <- Direction visée par l'agent durant le déplacement */
} action_hist;


/*!
** Déplace l'agent ``id_agent`` d'une case dans la direction choisie.
*/
erreur deplacer(int id_agent, direction dir);

/*!
** Propulse l'agent ``id_agent`` dans la direction choisie jusqu'à ce qu'il heurte un obstacle, c'est-à-dire soit un mur soit un autre agent.
*/
erreur glisser(int id_agent, direction dir);

/*!
** L'agent ``id_agent`` pousse tout autre agent se trouvant sur la case adjacente dans la direction indiquée. Ce dernier est propulsé jusqu'à ce qu'il rencontre un obstacle, c'est-à-dire soit un mur soit un autre agent.
*/
erreur pousser(int id_agent, direction dir);

/*!
** Affiche le drapeau spécifié sur la case indiquée.
*/
erreur debug_afficher_drapeau(position pos, debug_drapeau drapeau);

/*!
** Renvoie le nombre de points d'action de l'agent ``id_agent`` restants pour le tour. Si le numéro d'agent est invalide, la fonction renvoie -1.
*/
int points_action_agent(int id_agent);

/*!
** Renvoie le plus court chemin entre deux positions de la banquise sous la forme d'une suite de direction à emprunter. Ce chemin ne contient pas de glissade, uniquement des déplacements simples. Si la position est invalide ou que le chemin n'existe pas, le chemin renvoyé est vide.
*/
direction_array chemin(position pos1, position pos2);

/*!
** Renvoie le type d'une case donnée.
*/
case_type type_case(position pos);

/*!
** Renvoie le numéro du joueur à qui appartient l'agent sur la case indiquée. Renvoie -1 s'il n'y a pas d'agent ou si la position est invalide.
*/
int agent_sur_case(position pos);

/*!
** Indique si un alien se trouve sur une case donnée. Renvoie vrai si l'alien est en train d'envahir la banquise et qu'il n'a pas encore été capturé. Renvoie faux autremement, ou si la position est invalide.
*/
bool alien_sur_case(position pos);

/*!
** Indique la position de l'agent sur la banquise désigné par le numéro ``id_agent`` appartenant au joueur ``id_joueur``. Si la description de l'agent est incorrecte, la position (-1, -1) est renvoyée.
*/
position position_agent(int id_joueur, int id_agent);

/*!
** Renvoie la description d'un alien en fonction d'une position donnée. Si l'alien n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``alien_info`` renvoyée sont initialisés à -1.
*/
alien_info info_alien(position pos);

/*!
** Renvoie la liste de tous les aliens présents durant la partie.
*/
alien_info_array liste_aliens(void);

/*!
** Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
*/
action_hist_array historique(void);

/*!
** Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
*/
int score(int id_joueur);

/*!
** Renvoie votre numéro de joueur.
*/
int moi(void);

/*!
** Renvoie le numéro de joueur de votre adversaire.
*/
int adversaire(void);

/*!
** Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour-ci.
*/
bool annuler(void);

/*!
** Retourne le numéro du tour actuel.
*/
int tour_actuel(void);

/*!
** Affiche le contenu d'une valeur de type case_type
*/
void afficher_case_type(case_type v);

/*!
** Affiche le contenu d'une valeur de type direction
*/
void afficher_direction(direction v);

/*!
** Affiche le contenu d'une valeur de type erreur
*/
void afficher_erreur(erreur v);

/*!
** Affiche le contenu d'une valeur de type action_type
*/
void afficher_action_type(action_type v);

/*!
** Affiche le contenu d'une valeur de type debug_drapeau
*/
void afficher_debug_drapeau(debug_drapeau v);

/*!
** Affiche le contenu d'une valeur de type position
*/
void afficher_position(position v);

/*!
** Affiche le contenu d'une valeur de type alien_info
*/
void afficher_alien_info(alien_info v);

/*!
** Affiche le contenu d'une valeur de type action_hist
*/
void afficher_action_hist(action_hist v);

/*!
** Fonction appelée au début de la partie.
*/
void partie_init(void);

/*!
** Fonction appelée à chaque tour.
*/
void jouer_tour(void);

/*!
** Fonction appelée à la fin de la partie.
*/
void partie_fin(void);

