/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_haskell.rb

#include <stdbool.h>
/// Types de cases
typedef enum case_type {
  LIBRE, /* <- Case libre */
  MUR, /* <- Mur */
  ERREUR, /* <- Erreur */
} case_type;


/// Points cardinaux
typedef enum direction {
  NORD, /* <- Direction : nord */
  EST, /* <- Direction : est */
  SUD, /* <- Direction : sud */
  OUEST, /* <- Direction : ouest */
} direction;


/// Erreurs possibles
typedef enum erreur {
  OK, /* <- L'action s'est effectuée avec succès. */
  PA_INSUFFISANTS, /* <- Votre agent ne possède pas assez de points d'action pour réaliser cette action. */
  POSITION_INVALIDE, /* <- La position spécifiée n'est pas sur la banquise. */
  OBSTACLE_MUR, /* <- La position spécifiée est un mur. */
  OBSTACLE_AGENT, /* <- La position spécifiée est un agent. */
  DEPLACEMENT_HORS_LIMITES, /* <- Ce déplacement fait sortir un agent des limites de la banquise. */
  DIRECTION_INVALIDE, /* <- La direction spécifiée n'existe pas. */
  ID_AGENT_INVALIDE, /* <- L'agent spécifié n'existe pas. */
  RIEN_A_POUSSER, /* <- Aucun agent à pousser dans la direction indiquée. */
  DRAPEAU_INVALIDE, /* <- Le drapeau spécifié n'existe pas. */
} erreur;


/// Types d'actions
typedef enum action_type {
  ACTION_DEPLACER, /* <- Action ``deplacer`` */
  ACTION_GLISSER, /* <- Action ``glisser`` */
  ACTION_POUSSER, /* <- Action ``pousser`` */
} action_type;


/// Types de drapeaux de débug
typedef enum debug_drapeau {
  AUCUN_DRAPEAU, /* <- Aucun drapeau, enlève le drapeau présent */
  DRAPEAU_BLEU, /* <- Drapeau bleu */
  DRAPEAU_VERT, /* <- Drapeau vert */
  DRAPEAU_ROUGE, /* <- Drapeau rouge */
} debug_drapeau;


struct position;
struct alien_info;
struct action_hist;

typedef struct direction_array {
  direction* datas;
  size_t length;
} direction_array;

typedef struct alien_info_array {
  struct alien_info* datas;
  size_t length;
} alien_info_array;

typedef struct action_hist_array {
  struct action_hist* datas;
  size_t length;
} action_hist_array;

/// Position sur la banquise, donnée par deux coordonnées.
typedef struct position {
  int ligne;  /* <- Coordonnée : ligne */
  int colonne;  /* <- Coordonnée : colonne */
} position;


/// Alien à capturer durant la mission.
typedef struct alien_info {
  position pos;  /* <- Position de l'alien */
  int points_capture;  /* <- Nombre de points obtenus pour la capture de cet alien */
  int tour_invasion;  /* <- Tour où l'alien débarque sur la banquise */
  int duree_invasion;  /* <- Nombre de tours où l'alien reste sur la banquise */
  int capture_en_cours;  /* <- Nombre de tours de la capture en cours, l'alien est considéré comme capturé si la variable atteint NB_TOURS_CAPTURE */
} alien_info;


/// Action de déplacement représentée dans l'historique.
typedef struct action_hist {
  action_type atype;  /* <- Type de l'action */
  int id_agent;  /* <- Numéro de l'agent concerné par l'action */
  direction dir;  /* <- Direction visée par l'agent durant le déplacement */
} action_hist;


