// Leopold II: Archangel
//
// Robin Jadoul
// minimax -> aborted
// Send the agents to the 'best' alien, for some definition of 'best'
// Via the shortest route in terms of action points (dijkstra)
// If there's nothing useful to do, go help someone else
// If you stay in one place, attack if you can
// The score function could do with some smarter heuristics
//
// Taking the maximum over all permutations was fast enough, but crashed

#include <bits/stdc++.h>
#include "prologin.hh"
using namespace std;

ostream& operator<<(ostream& os, position p) {
    return os << "(" << p.ligne << ", " << p.colonne << ")";
}

// x == ligne, y == colonne
direction dirs[] = {NORD, SUD, EST, OUEST};
int DX[] = {-1, 1, 0, 0};
int DY[] = {0, 0, 1, -1};
int me;

#define ALL(x) x.begin(), x.end()
#define FPOS(x, y) for (int x = 0; x < TAILLE_BANQUISE; x++) for (int y = 0; y < TAILLE_BANQUISE; y++)
#define FP FPOS(x, y)
#define FDIR(x, y, dx, dy, dir) for (int FDIR_I = 0; FDIR_I < 4; FDIR_I++)\
                                                  for (direction dir = dirs[FDIR_I]; dir == dirs[FDIR_I]; dir = (direction)42)\
                                                  for (int dx = DX[FDIR_I]; dx == DX[FDIR_I]; dx=42)\
                                                  for (int dy = DY[FDIR_I]; dy == DY[FDIR_I]; dy=42)\
                                                  if (dx + x >= 0 && dx + x < TAILLE_BANQUISE && dy + y >= 0 && dy + y < TAILLE_BANQUISE)
#define FD FDIR(x, y, dx, dy, dir)
#define MOVEDN(grid) grid[x+dx][y+dy]
#define MOVED MOVEDN(grid)
#define CURN(grid) grid[x][y]
#define CUR CURN(grid)
#define FAN(a) for (int a = 0; a < NB_AGENTS; a++)
#define FA FAN(a)
#ifdef DEBUG
erreur ASSERT(erreur e) {if (e) {cerr << (int)e << endl; abort();} return e;}
#else
erreur ASSERT(erreur e) {return e;}
#endif

enum grid_type {
    EMPTY,
    ALIEN,
    BLOCK,
    PENGUIN,
    COMBO
};

position place(int i) {
    return position_agent(me, i);
}

vector<vector<grid_type>> grid(TAILLE_BANQUISE, vector<grid_type>(TAILLE_BANQUISE, EMPTY));

// Execute an action
erreur execute(int agent, pair<action_type, direction> act) {
    int left = points_action_agent(agent);
    if (act.first == ACTION_POUSSER && left >= COUT_POUSSER)
        return ASSERT(pousser(agent, act.second));
    else if (act.first == ACTION_GLISSER && left >= COUT_GLISSADE)
        return ASSERT(glisser(agent, act.second));
    else if (act.first == ACTION_DEPLACER && left >= COUT_DEPLACEMENT)
        return ASSERT(deplacer(agent, act.second));
    else
        return PA_INSUFFISANTS;
}

// Update our own information representation
void update_grid() {
    FPOS(i, j) {
        if (type_case({i, j}) == MUR) {
            grid[i][j] = BLOCK;
        } else if (alien_sur_case({i, j}) && agent_sur_case({i, j}) >= 0) {
            grid[i][j] = COMBO;
        } else if (alien_sur_case({i, j})) {
            grid[i][j] = ALIEN;
        } else if (agent_sur_case({i, j}) >= 0) {
            grid[i][j] = PENGUIN;
        } else {
            grid[i][j] = EMPTY;
        }
    }
}

using T = pair<int, position>;
priority_queue<T, vector<T>, greater<T>> q;
unordered_map<position, int> d;
unordered_map<position, pair<pair<action_type, direction>, position>> P;

// Find the shortests paths from a in terms of action points
void dist(position a) {
    assert(q.empty());
    d.clear();
    P.clear();
    d[a] = 0;
    q.emplace(0, a);

    auto qu = [](const T& t, action_type typ, direction dir, position cur) {
        if (d.find(t.second) == d.end() || t.first < d[t.second]) {
            d[t.second] = t.first;
            P[t.second] = {{typ, dir}, cur};
            q.push(t);
        }
    };

    T cur;
    while (!q.empty()) {
        cur = q.top();
        q.pop();

        if (cur.first > d[cur.second]) continue;

        int x = cur.second.ligne, y = cur.second.colonne;
        FD {
            if (MOVED == EMPTY || MOVED == ALIEN) {
                qu({cur.first + COUT_DEPLACEMENT, {x + dx, y + dy}}, ACTION_DEPLACER, dir, cur.second);
                int _x = x + dx; int _y = y + dy;
                while (_x + dx >= 0 && _x + dx < TAILLE_BANQUISE && _y + dy >= 0 && _y + dy < TAILLE_BANQUISE && (grid[_x + dx][_y + dy] == EMPTY || grid[_x + dx][_y + dy] == ALIEN)) {
                    _x += dx;
                    _y += dy;
                }
                qu({cur.first + COUT_GLISSADE, {_x, _y}}, ACTION_GLISSER, dir, cur.second);
            }
            if ((MOVED == PENGUIN || MOVED == COMBO)
                    && agent_sur_case({x + dx, y + dy}) == adversaire()
                    && x + 2*dx >= 0
                    && x + 2*dx < TAILLE_BANQUISE
                    && y + 2*dy >= 0
                    && y + 2*dy < TAILLE_BANQUISE
                    && (grid[x + 2*dx][y + 2*dy] == EMPTY || grid[x + 2*dx][y + 2*dy] == ALIEN)) {
                qu({cur.first + COUT_POUSSER + COUT_DEPLACEMENT, {x + dx, y + dy}}, ACTION_POUSSER, dir, cur.second);

                int _x = x + dx; int _y = y + dy;
                while (_x + dx >= 0 && _x + dx < TAILLE_BANQUISE && _y + dy >= 0 && _y + dy < TAILLE_BANQUISE && (grid[_x + dx][_y + dy] == EMPTY || grid[_x + dx][_y + dy] == ALIEN)) {
                    _x += dx;
                    _y += dy;
                }
                _x -= dx;
                _y -= dy;
                qu({cur.first + COUT_POUSSER + COUT_GLISSADE, {_x, _y}}, ACTION_POUSSER, dir, cur.second);
            }
        }
    }
}

// Reconstruct the actions as indicated by the dijkstra
vector<pair<action_type, direction>> reconstruct(position cu, position start) {
    vector<pair<action_type, direction>> res;
    while (cu != start) {
        if (!P.count(cu)) return {};
        if (P[cu].first.first == ACTION_POUSSER) {
            if (abs(cu.ligne - P[cu].second.ligne) + abs(cu.colonne - P[cu].second.colonne) == 1) {
                res.emplace_back(ACTION_DEPLACER, P[cu].first.second);
            } else {
                res.emplace_back(ACTION_GLISSER, P[cu].first.second);
            }
        }
        res.emplace_back(std::move(P[cu].first));
        cu = P[cu].second;
    }
    return {res.rbegin(), res.rend()};
}

// Evaluate the number of turns needed to execute a sequence of actions
int count_turns_exact(vector<pair<action_type, direction>>& steps) {
    if (steps.empty()) return 0;

    int left = NB_POINTS_ACTION;
    int s = 1;
    for (auto& step : steps) {
        int cost = 0;
        if (step.first == ACTION_POUSSER) cost = COUT_POUSSER;
        else if (step.first == ACTION_GLISSER) cost = COUT_GLISSADE;
        else if (step.first == ACTION_DEPLACER) cost = COUT_DEPLACEMENT;
        if (cost > left) {
            left = NB_POINTS_ACTION;
            s++;
        }
        left -= cost;
    }
    return s;
}

// Find some sort of heuristic score indication for moving an agent from start to the alien
double score(alien_info& info, position start) {
    if (!P.count(info.pos) && start != info.pos) return -1e9;

    auto steps = reconstruct(info.pos, start);
    int nsteps = max(count_turns_exact(steps) + tour_actuel() - 1, info.tour_invasion) - tour_actuel();

    if ((NB_TOURS_CAPTURE - info.capture_en_cours) > info.tour_invasion + info.duree_invasion - tour_actuel()) return -1e9-1;
    if (info.capture_en_cours == NB_TOURS_CAPTURE || info.tour_invasion + info.duree_invasion < tour_actuel()) return -1e9;

    if (info.tour_invasion + info.duree_invasion <= tour_actuel() + nsteps + NB_TOURS_CAPTURE) return -1e9;
    return pow(info.capture_en_cours, 3.8) * (agent_sur_case(info.pos) == adversaire() ? 2.5 : 1) * info.points_capture / double(nsteps + 1);
}

// If you're not moving. you can at least attack
void push_adjacent(int a) {
    auto P = place(a);
    int x = P.ligne, y = P.colonne;
    for (int i = 0; i < 5; i++)
        FD {
            if (agent_sur_case({x + dx, y + dy}) == adversaire() && random() >= 0.5) {
                pousser(a, dir);
            }
        }
}

// If there's nothing better, go and defend your comrades
void defend(int agent) {
    position bestP = place(agent);
    double bests = -1e9;
    FA {
        auto P = place(a);
        if (a == agent) continue;
        if (grid[P.ligne][P.colonne] != COMBO) continue;
        int x = P.ligne, y = P.colonne;
        FD {
            if (MOVED == BLOCK || MOVED == PENGUIN || MOVED == COMBO) continue;
            double s = -1e9-1;
            if (d.count(position{x+dx, y+dy})) {
                if (x - 2*dx >= 0 && x - 2*dx < TAILLE_BANQUISE
                        && y - 2*dy >= 0 && y - 2*dy < TAILLE_BANQUISE
                        && (grid[x - 2*dx][y - 2*dy] != BLOCK)) {
                    s = -d[{x + dx, y + dy}] + 10 * (grid[x-2*dx][y-2*dy] == PENGUIN && agent_sur_case({x-2*dx,y-2*dy}) == adversaire());
                }
            }
            if (s >= bests) {
                bestP = position{x + dx, y + dy};
                bests = s;
            }
        }
    }
    for (auto x : reconstruct(bestP, place(agent)))
        if (execute(agent, x)) break;
}

/// Fonction appelée au début de la partie.
void partie_init() { srand(time(0)); me = moi(); }

/// Fonction appelée à chaque tour.
// Send agents towards aliens, have them defend, our attack
void jouer_tour() {
    assert(me == moi());
    FP debug_afficher_drapeau({x, y}, AUCUN_DRAPEAU);
    set<int> taken;
    set<int> used;
    auto infos = liste_aliens();
    FAN(i) {
        double bests = -1e9 - 1;
        int besta = 0;
        int bestj = 0;
        update_grid();
        FA {
            if (used.count(a)) continue;
            position P = place(a);
            dist(P);
            for (int j = 0; j < (int)infos.size(); j++) {
                if (taken.count(j)) continue;
                double sc = score(infos[j], P);
                if (sc > bests) {
                    bests = sc;
                    bestj = j;
                    besta = a;
                }
            }
        }
        used.insert(besta);
        dist(place(besta));
        if (bests < -1e8) {
            defend(besta);
        } else {
            taken.insert(bestj);
            debug_afficher_drapeau(infos[bestj].pos, DRAPEAU_VERT);
            auto steps = reconstruct(infos[bestj].pos, place(besta));
            for (auto x : steps) {
                if (execute(besta, x)) break;
            }
            if (steps.empty()) {
                push_adjacent(besta);
            }
        }
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
    // fonction a completer
}
