/**
 * scoring for possible placing positions => placeScore
 * if no placement is possible, find a large zone to transmute
 *   don't transmute if you attacked meanwhile
 * improve catalysers: approximate field score and minimize that
 *   Take the best option over improving yourself and attacking, with a slight
 *   preference for attacking
 * be aggressive from time to time (sacrifice a 3-sized catalyser zone)
 * better (or worse ^^) next moves for the opponent: choose those he has the
 *   least of and replace the one he has most of, such that you don't hand out
 *   duplicates
 *  If the player gets himself into a loop, go with it
 *  Be greedy, don't leave large zones for too long
 */
#include <bits/stdc++.h>
#include "prologin.hh"
using namespace std;

//Used for detecting and acting on loops
vector<case_type> lastState(36, VIDE);
pair<case_type, case_type> lastMove(PLOMB, FER);
vector<case_type> lastState2(36, VIDE);
pair<case_type, case_type> lastMove2(PLOMB, FER);

//Gets set to false if playing the very last round
bool AGGRESSIVE = true;

//(almost) useless
void partie_init() {srand(time(NULL));} void partie_fin() {}

/*
 * Determine if a position is a single isolated unit
 */
bool isSingle(position p, int player=-1) {
    if (player < 0) player = moi();
    auto tt = type_case(p, player);
    for (int i = -1; i <= 1; i++) {
        for (int j = -1; j <= 1; j++) {
            if (abs(i + j) != 1) continue;
            if (p.ligne + i < 0 || p.ligne + i >= TAILLE_ETABLI || p.colonne + j < 0 || p.colonne + j >= TAILLE_ETABLI) continue;
            auto t2 = type_case({p.ligne + i, p.colonne + j}, player);
            if (t2 == tt || t2 == VIDE)
                return false;
        }
    }
    return true;
}

//Heuristic for the amount of gold obtainable from the current field for a
//given player
int fieldScore(int player) {
    int sc = 0;
    set<position> done;
    for (int i = 0; i < TAILLE_ETABLI; i++) {
        for (int j = 0; j< TAILLE_ETABLI; j++) {
            if (isSingle({i, j}, player))
                sc -= 2;
            if (done.count({i, j}) || taille_region({i, j}, player) <= 2) continue;
            if (propriete_case({i, j}, player) == TRANSMUTABLE_OR) {
                int t = taille_region({i, j}, player);
                sc += quantite_transmutation_or(t);
            } else if (propriete_case({i, j}, player) == TRANSMUTABLE_CATALYSEUR) {
                sc += quantite_transmutation_catalyseur_or(taille_region({i, j}, player)) + 3 * quantite_transmutation_catalyseur(taille_region({i, j}, player));
            }
            for (auto p : positions_region({i, j}, player)) {
                done.emplace(p);
            }
        }
    }
    return sc;
}

// Apply catalysers
// Evaluate both aggressive and defensive options, but prefer aggressive
bool apply_cata() {
    while (nombre_catalyseurs()) {
        int forPlayer = -1;
        int improvement = -1;
        vector<pair<position, pair<case_type, int>>> current_best;
        if (AGGRESSIVE) {
            //The aggressive part
            int M = fieldScore(adversaire()) - 1;
            int orig = M + 1;
            vector<pair<position, pair<case_type, int>>> best;
            for (int i = 0; i < TAILLE_ETABLI; i++)
                for (int j = 0; j < TAILLE_ETABLI; j++)
                    if (type_case({i, j}, adversaire()) != VIDE) {

                        bool taken = false;
                        for (int n = 1; n <= 5; n++) {
                            catalyser({i, j}, adversaire(), (case_type)(n));

                            int t = fieldScore(adversaire()) - 4 * ((i + j) % 2);
                            if (t < M) {
                                taken = false;
                                M = t;
                                best.clear();
                            }
                            if (!taken && t == M) {
                                taken = true;
                                best.emplace_back(position{i, j}, make_pair(case_type(n), adversaire()));
                            }

                            annuler();
                        }
                    }
            forPlayer = adversaire();
            improvement = orig - M;
            current_best = best;
        }

        // The defensive part
        int M = fieldScore(moi()) + 1;
        int orig = M - 1;
        vector<pair<position, pair<case_type, int>>> best;
        for (int i = 0; i < TAILLE_ETABLI; i++)
            for (int j = 0; j < TAILLE_ETABLI; j++)
                if (type_case({i, j}, moi()) != VIDE) {

                    for (int n = 1; n <= 5; n++) {
                        catalyser({i, j}, moi(), (case_type)(n));

                        int t = fieldScore(moi());
                        if (t > M) {
                            M = t;
                            best.clear();
                        }
                        if (t == M) {
                            best.emplace_back(position{i, j}, make_pair(case_type(n), moi()));
                        }

                        annuler();
                    }
                }

        //choose
        if (!(forPlayer >= 0 && improvement >= (M - orig) * 0.85)) {
            cout << "defensive" << endl;
            best.insert(best.end(), current_best.begin(), current_best.end());
            current_best = best;
        } else {
            current_best.insert(current_best.end(), best.begin(), best.end());
        }
        random_shuffle(current_best.begin(), current_best.end());
        bool res = false;
        while (nombre_catalyseurs() && current_best.size()) {
            res = true;
            auto p = current_best.back();
            catalyser(p.first, p.second.second, p.second.first);
            current_best.pop_back();
        }
        return res;
    }
    return false;
}

void last_round() {
    //All catalyser generators first
    for (int i = 0; i < TAILLE_ETABLI; i++) {
        for (int j = 0; j< TAILLE_ETABLI; j++) {
            if (propriete_case({i, j}, moi()) == TRANSMUTABLE_CATALYSEUR
                    && taille_region({i, j}, moi()) > 1) {
                transmuter({i, j});
                apply_cata();
            }
        }
    }

    //All strong reactions last
    for (int i = 0; i < TAILLE_ETABLI; i++) {
        for (int j = 0; j< TAILLE_ETABLI; j++) {
            if (taille_region({i, j}, moi()) > 1) {
                transmuter({i, j});
            }
        }
    }
}

/*
 * Calculate a score for placing at pp
 * The higher, the better
 *       - Size of adjacent zones (both elements)
 *       - Avoid single-cell holes
 */
int placeScore(position_echantillon pp) {
    int score = 0;
    placer_echantillon(pp.pos1, pp.pos2);

    score += taille_region(pp.pos1, moi()) * 4;
    if (echantillon_tour().element1 != echantillon_tour().element2)
        score += taille_region(pp.pos2, moi()) * 4;
    score += fieldScore(moi()) * 3;
    for (int x = 0; x < TAILLE_ETABLI; x++)
        for (int y = 0; y < TAILLE_ETABLI; y++)
            if (isSingle({x, y}))
                score -= 3;
    for (int i = -1; i <= 1; i++)
        for (int j = -1; j <= 1; j++) {
            score -= type_case({pp.pos1.ligne + i, pp.pos1.colonne + j}, moi()) != VIDE;
            score -= type_case({pp.pos2.ligne + i, pp.pos2.colonne + j}, moi()) != VIDE;
            score -= pp.pos1.ligne + i < 0 || pp.pos1.colonne + j < 0 || pp.pos1.ligne + i >= 6 || pp.pos1.colonne >= 6;
            score -= pp.pos2.ligne + i < 0 || pp.pos2.colonne + j < 0 || pp.pos2.ligne + i >= 6 || pp.pos2.colonne >= 6;
        }

    annuler();
    return score;
}

void jouer_tour() {
    cout << tour_actuel() << endl;
    if (tour_actuel() == NB_TOURS) //Useless to attack when he has no more moves
        AGGRESSIVE = false;
    bool ok = false;
    //Take the best scoring placement available
    //If there's none, transmute the largest zone and repeat
    while (!ok) {
        for (int i = 0; i < TAILLE_ETABLI; i++) {
            for (int j = 0; j < TAILLE_ETABLI; j++) {
                int t = taille_region({i, j}, moi());
                if (t >= 3 && propriete_case({i, j}, moi()) == TRANSMUTABLE_CATALYSEUR) {
                    //ATTACK!
                    transmuter({i, j});
                    if (!apply_cata())
                        annuler();
                    else
                        cout << "CHARGE!" << endl;
                    continue;
                }
            }
        }

        position_echantillon best{{-1, -1}, {-1, -1}};
        int bestScore = -99999;
        for (auto pp : placements_possible_echantillon(echantillon_tour(), moi())) {
            int s = placeScore(pp);
            if (s > bestScore || best.pos1.ligne < 0 || (s == bestScore && rand() % 3 == 0)) {
                bestScore = s;
                best = pp;
            }
            ok = true;
        }
        if (ok) {
            placer_echantillon(best.pos1, best.pos2);
        }

        int singlecount = 0;
        priority_queue<pair<int, position>> ps;
        bool attacked = false;
        for (int i = 0; i < TAILLE_ETABLI; i++) {
            for (int j = 0; j < TAILLE_ETABLI; j++) {
                if (isSingle({i, j})) {
                    singlecount++;
                }
                int t = taille_region({i, j}, moi());
                if (t >= 3 && propriete_case({i, j}, moi()) == TRANSMUTABLE_CATALYSEUR) {
                    //ATTACK!
                    attacked = true;
                    transmuter({i, j});
                    if (!apply_cata())
                        annuler();
                    else
                        cout << "CHARGE!" << endl;
                }
                if ((!ok && t >= 5) || (ok && t >= 7)) {
                    attacked = true;
                    transmuter({i, j});
                    apply_cata();
                } else {
                    ps.emplace(t, position{i, j});
                }
            }
        }
        if (singlecount >= 12) {
            cout << "Let it go" << endl;
            ok = true;
        }
        if (!ok && !attacked) {
            transmuter(ps.top().second);
            apply_cata();
        }
    }


    //Choose the next move for the opponent,
    //If the opponent is in the same state as we last found him, repeat that
    //move
    vector<case_type> newState(36, VIDE);
    bool same = true;
    bool same2 = true;
    for (int i = 0; i < TAILLE_ETABLI; i++)
        for (int j = 0; j < TAILLE_ETABLI; j++) {
            if (lastState[i*TAILLE_ETABLI+j] != type_case({i, j}, adversaire())) {
                same = false;
                newState[i*TAILLE_ETABLI + j] = type_case({i, j}, adversaire());
            }
            if (lastState2[i*TAILLE_ETABLI+j] != type_case({i, j}, adversaire())) {
                same2 = false;
            }
        }
    if (same2 && tour_actuel() > 3) {
        cout << "Do that again, will you, my friend (but double)?" << endl;
        donner_echantillon({lastMove2.first, lastMove2.second});
        swap(lastState, lastState2);
        swap(lastMove, lastMove2);
    } else if (same && tour_actuel() != 1) {
        cout << "Do that again, will you, my friend?" << endl;
        donner_echantillon({lastMove.first, lastMove.second});
        lastMove2 = lastMove;
        lastState2 = lastState;
    } else {
        //Take the elements he has least of and replace the one he has most of from
        //the current move with it
        int count[6] = {0};
        for (int i = 0; i < TAILLE_ETABLI; i++)
            for (int j = 0; j < TAILLE_ETABLI; j++)
                count[type_case({i, j}, adversaire())]++;
        //Not too many catalysers :-)
        count[4]++;
        count[5]++;
        vector<int> ts;
        int m = 1000000;
        auto e = echantillon_tour();
        int skip = count[e.element1] > count[e.element2] ? e.element2 : e.element1;
        for (int i = 1; i < 6; i++) {
            if (i == skip) continue;
            if (count[i] == m) {
                ts.push_back(i);
            } else if (count[i] < m) {
                ts.clear();
                ts.push_back(i);
                m = count[i];
            }
        }
        int t = ts[rand() % ts.size()];
        if (count[e.element1] > count[e.element2]) {
            e.element1 = (case_type)t;
        } else {
            e.element2 = (case_type)t;
        }
        donner_echantillon(e);
        lastMove2 = lastMove;
        lastState2 = lastState;
        lastMove = {e.element1, e.element2};
        lastState = newState;
    }

    //Clean up everything that gives some profit
    if (tour_actuel() >= NB_TOURS - 1) {
        last_round();
    }
}
