// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb

using System.Runtime.CompilerServices;

namespace Prologin {
// Types de cases
	public enum CaseType {
		VIDE, // <- Case vide
		PLOMB, // <- Plomb ; transmutable en or
		FER, // <- Fer ; transmutable en or
		CUIVRE, // <- Cuivre ; transmutable en or
		SOUFRE, // <- Soufre ; transmutable en catalyseur
		MERCURE, // <- Mercure ; transmutable en catalyseur
	}

// Types de propriétés des éléments
	public enum ElementPropriete {
		AUCUNE, // <- Les cases vides ne contiennent pas d’élément, et n’ont donc aucune propriété
		TRANSMUTABLE_OR, // <- Élement transmutable en or
		TRANSMUTABLE_CATALYSEUR, // <- Élément transmutable en catalyseur
	}

// Erreurs possibles
	public enum Erreur {
		OK, // <- L’action a été exécutée avec succès
		POSITION_INVALIDE, // <- La position spécifiée n’est pas sur l’établi
		PLACEMENT_INVALIDE, // <- Les deux positions ne correspondent pas à des cases adjacentes
		PLACEMENT_IMPOSSIBLE, // <- Les cases ciblées ne sont pas vides
		PLACEMENT_INCORRECT, // <- Un des deux éléments de l'échantillon doit être placé adjacent à un élément du même type déjà présent sur l'établi
		CASE_VIDE, // <- La case ciblée est vide
		ECHANTILLON_INCOMPLET, // <- L’échantillon doit contenir deux éléments.
		ECHANTILLON_INVALIDE, // <- L’échantillon doit contenir au moins un des éléments de l’échantillon reçu auparavant
		AUCUN_CATALYSEUR, // <- Aucun catalyseur disponible
		CATALYSE_INVALIDE, // <- L'élément de destination ne peut pas être vide.
		DEJA_POSE, // <- L’échantillon a déjà été posé ce tour-ci
		DEJA_DONNE, // <- L’échantillon a déjà été donné ce tour-ci
	}

// Types d’actions
	public enum ActionType {
		ACTION_PLACER, // <- Action ``placer_echantillon``
		ACTION_TRANSMUTER, // <- Action ``transmuter``
		ACTION_CATALYSER, // <- Action ``catalyser``
		ACTION_DONNER_ECHANTILLON, // <- Action ``donner_echantillon``
	}

// Position sur la carte, donnée par deux coordonnées
	class Position {
		public Position() {
		}
		public int Ligne; // <- Coordonnée : ligne
		public int Colonne; // <- Coordonnée : colonne
	}

// Échantillon, défini par deux types d’éléments
	class Echantillon {
		public Echantillon() {
		}
		public CaseType Element1; // <- Élément 1
		public CaseType Element2; // <- Élément 2
	}

// Position d’un échantillon, donnée par deux positions adjacentes
	class PositionEchantillon {
		public PositionEchantillon() {
		}
		public Position Pos1; // <- Position de l’élément 1 de l’échantillon
		public Position Pos2; // <- Position de l’élément 2 de l’échantillon
	}

// Action représentée dans l’historique. L’action ``placer_echantillon`` utilise ``pos1`` et ``pos2``. L’action ``transmuter`` utilise ``pos1``. L’action ``catalyser`` utilise ``pos1``, ``id_apprenti`` et ``nouvelle_case``. L’action ``donner_echantillon`` n’est pas représentée dans l’historique, car ``echantillon_tour`` donne l’information.
	class ActionHist {
		public ActionHist() {
		}
		public ActionType Atype; // <- Type de l’action
		public Position Pos1; // <- Position, pour les actions placer (1er élément), transmuter et catalyser
		public Position Pos2; // <- Position, pour l’action placer (2e élément)
		public int IdApprenti; // <- ID de l’apprenti, pour l’action catalyser
		public CaseType NouvelleCase; // <- Élément pour l’action catalyser
	}

	class Api {
// Taille de l’établi de travail (longueur et largeur)
		public const int TAILLE_ETABLI = 6;

// Nombre de tours à jouer avant la fin de l’affrontement
		public const int NB_TOURS = 150;

// Taille de l’énumération ``case_type``
		public const int NB_TYPE_CASES = 6;

// Place l’échantillon du tour sur l’établi, avec les coordonnées de deux cases adjacentes.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur PlacerEchantillon(Position pos1, Position pos2);

// Provoque la transformation chimique de l’élément à la case ciblée, ainsi que tous les éléments adjacents du même type, ceux du même type adjacents à ces derniers, etc. Ils disparaissent alors tous dans leur transmutation en or ou en catalyseur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Transmuter(Position pos);

// Utilise un catalyseur sur la case ciblée de l'apprenti indiqué. Transforme l’ancien élément en l’élément indiqué.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Catalyser(Position pos, int id_apprenti, CaseType terrain);

// Définit l’échantillon que l’adversaire recevra à son prochain tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur DonnerEchantillon(Echantillon echantillon_donne);

// Renvoie le type d’une case donnée, ou 0 si la case est invaide.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern CaseType TypeCase(Position pos, int id_apprenti);

// Indique si une case donnée est vide ou contient un élément. Renvoie faux en cas d'erreur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool EstVide(Position pos, int id_apprenti);

// Renvoie la propriété de l’élément sur une case donnée. Un élément invalide n'a pas de propriété.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern ElementPropriete ProprieteCase(Position pos, int id_apprenti);

// Renvoie la propriété d’un type de case donné.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern ElementPropriete ProprieteCaseType(CaseType ctype);

// Renvoie la taille de la région à laquelle appartient un élément. Renvoie -1 si la position est invalide.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int TailleRegion(Position pos, int id_apprenti);

// Renvoie la liste des positions des cases composant la région à laquelle appartient un élément donné. Renvoie une liste vide en cas d'erreur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] PositionsRegion(Position pos, int id_apprenti);

// Détermine si le placement d’un échantillon est valide.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool PlacementPossibleEchantillon(Echantillon echantillon_a_placer, Position pos1, Position pos2, int id_apprenti);

// Renvoie la liste des placements possibles pour un échantillon donné sur l’établi d’un apprenti donné. Renvoie une liste vide en cas d'erreur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern PositionEchantillon[] PlacementsPossibleEchantillon(Echantillon echantillon_a_placer, int id_apprenti);

// Renvoie la liste des actions jouées par l’adversaire pendant son tour, dans l’ordre chronologique.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern ActionHist[] Historique();

// Renvoie votre numéro d’apprenti.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Moi();

// Renvoie le numéro d’apprenti de votre adversaire.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Adversaire();

// Renvoie la quantité d’or amassée par l’apprenti désigné par le numéro ``id_apprenti``. Renvoie 0 si ``id_apprenti`` est invalide (attention, le score d’un apprenti valide peut aussi être 0).
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Score(int id_apprenti);

// Renvoie le numéro du tour actuel.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int TourActuel();

// Annule la dernière action. Renvoie ``false`` quand il n’y a pas d’action à annuler ce tour-ci.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool Annuler();

// Indique le nombre de catalyseurs en votre possession.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int NombreCatalyseurs();

// Indique l’échantillon reçu pour ce tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Echantillon EchantillonTour();

// Indique si l’échantillon reçu pour ce tour a déjà été posé.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool APoseEchantillon();

// Indique si un échantillon a déjà été donné ce tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool ADonneEchantillon();

// Renvoie la quantité d’or (et donc le score) obtenue par la transmutation de ``taille_region`` éléments transmutables en or.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int QuantiteTransmutationOr(int taille_region);

// Renvoie la quantité de catalyseurs obtenue par la transmutation de ``taille_region`` éléments transmutables en catalyseur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int QuantiteTransmutationCatalyseur(int taille_region);

// Renvoie la quantité d’or obtenue par la transmutation de ``taille_region`` éléments transmutables en catalyseur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int QuantiteTransmutationCatalyseurOr(int taille_region);

// Indique l’échantillon par défaut lors du premier tour
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Echantillon EchantillonDefautPremierTour();

// Affiche l'état actuel des deux établis dans la console.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherEtablis();

// Affiche le contenu d'une valeur de type case_type
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherCaseType(CaseType v);

// Affiche le contenu d'une valeur de type element_propriete
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherElementPropriete(ElementPropriete v);

// Affiche le contenu d'une valeur de type erreur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherErreur(Erreur v);

// Affiche le contenu d'une valeur de type action_type
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherActionType(ActionType v);

// Affiche le contenu d'une valeur de type position
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPosition(Position v);

// Affiche le contenu d'une valeur de type echantillon
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherEchantillon(Echantillon v);

// Affiche le contenu d'une valeur de type position_echantillon
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPositionEchantillon(PositionEchantillon v);

// Affiche le contenu d'une valeur de type action_hist
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherActionHist(ActionHist v);

	}
}
