/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_c.rb

#ifndef INTERFACE_HH_
# define INTERFACE_HH_

# include <vector>
# include <string>

extern "C" {
# include "prologin.h"
}

/// Position sur la carte, donnée par deux coordonnées.
typedef struct __internal__cxx__position {
  int x;
  int y;
} __internal__cxx__position;

/// Représente un pulsar existant.
typedef struct __internal__cxx__pulsar_info {
  int periode;
  double puissance;
  int pulsations_restantes;
  int pulsations_totales;
} __internal__cxx__pulsar_info;

/// Construit un tuyau sur une case donnée.
extern "C" erreur api_construire(__internal__cxx__position pos);

/// Améliore un tuyau en Super Tuyau™.
extern "C" erreur api_ameliorer(__internal__cxx__position pos);

/// Détruit un tuyau sur une case donnée.
extern "C" erreur api_detruire(__internal__cxx__position pos);

/// Déplace une unité de puissance d'aspiration d'une case de votre base vers une autre.
extern "C" erreur api_deplacer_aspiration(__internal__cxx__position source, __internal__cxx__position destination);

/// Déblaye une case de débris.
extern "C" erreur api_deblayer(__internal__cxx__position pos);

/// Renvoie le type d'une case donnée.
extern "C" case_type api_type_case(__internal__cxx__position pos);

/// Renvoie la liste de tous les pulsars présents.
extern "C" std::vector<__internal__cxx__position> api_liste_pulsars(void);

/// Renvoie la liste des cases contenant du plasma.
extern "C" std::vector<__internal__cxx__position> api_liste_plasmas(void);

/// Renvoie la liste des cases contenant un tuyau ou Super Tuyau™.
extern "C" std::vector<__internal__cxx__position> api_liste_tuyaux(void);

/// Renvoie la liste des cases contenant un Super Tuyau™.
extern "C" std::vector<__internal__cxx__position> api_liste_super_tuyaux(void);

/// Renvoie la liste des cases contenant des débris.
extern "C" std::vector<__internal__cxx__position> api_liste_debris(void);

/// Renvoie vrai si et seulement si la case contient un pulsar.
extern "C" bool api_est_pulsar(__internal__cxx__position pos);

/// Renvoie vrai si et seulement si la case contient un tuyau ou un Super Tuyau™.
extern "C" bool api_est_tuyau(__internal__cxx__position pos);

/// Renvoie vrai si et seulement si la case contient un simple tuyau.
extern "C" bool api_est_simple_tuyau(__internal__cxx__position pos);

/// Renvoie vrai si et seulement si la case contient un Super Tuyau™.
extern "C" bool api_est_super_tuyau(__internal__cxx__position pos);

/// Renvoie vrai si et seulement si la case contient un débris.
extern "C" bool api_est_debris(__internal__cxx__position pos);

/// Renvoie vrai si et seulement s'il est possible de construire sur cette case.
extern "C" bool api_est_libre(__internal__cxx__position pos);

/// Renvoie les informations propres au pulsar à la position donnée.
extern "C" __internal__cxx__pulsar_info api_info_pulsar(__internal__cxx__position pos);

/// Renvoie la quantité de plasma sur une case donnée.
extern "C" double api_charges_presentes(__internal__cxx__position pos);

/// Renvoie le numéro du joueur ayant dernièrement construit ou amélioré un tuyau sur une case.
extern "C" int api_constructeur_tuyau(__internal__cxx__position pos);

/// Renvoie le numéro du propriétaire d'une case de base.
extern "C" int api_proprietaire_base(__internal__cxx__position pos);

/// Renvoie la liste des cases composant votre base.
extern "C" std::vector<__internal__cxx__position> api_ma_base(void);

/// Renvoie la liste des cases composant la base de votre ennemi.
extern "C" std::vector<__internal__cxx__position> api_base_ennemie(void);

/// Renvoie la puissance d'aspiration d'une case de base donnée. Renvoie -1 si la position n'est pas celle d'une base.
extern "C" int api_puissance_aspiration(__internal__cxx__position pos);

/// Renvoie pour une case donnée la liste des cases vers lesquelles le plasma se propagera. Renvoie la liste vide si la case n'est pas une case contenant un tuyau ou si elle n'est reliée à aucune base.
extern "C" std::vector<__internal__cxx__position> api_directions_plasma(__internal__cxx__position pos);

/// Renvoie la valeur du coût de la prochaine modification de vos puissances d'aspiration.
extern "C" int api_cout_prochaine_modification_aspiration(void);

/// Renvoie la liste des tuyaux construits par votre adversaire au dernier tour.
extern "C" std::vector<__internal__cxx__position> api_hist_tuyaux_construits(void);

/// Renvoie la liste des tuyaux détruits par votre adversaire au dernier tour.
extern "C" std::vector<__internal__cxx__position> api_hist_tuyaux_detruits(void);

/// Renvoie la liste des tuyaux améliorés par votre adversaire au dernier tour.
extern "C" std::vector<__internal__cxx__position> api_hist_tuyaux_ameliores(void);

/// Renvoie la liste des débris déblayés par votre adversaire au dernier tour.
extern "C" std::vector<__internal__cxx__position> api_hist_debris_deblayes(void);

/// Renvoie la liste des cases de base de votre adversaire qui ont reçu un point d'aspiration (une même case peut apparaître plusieurs fois).
extern "C" std::vector<__internal__cxx__position> api_hist_points_aspiration_ajoutes(void);

/// Renvoie la liste des cases de base de votre adversaire qui ont perdu un point d'aspiration (une même case peut apparaître plusieurs fois).
extern "C" std::vector<__internal__cxx__position> api_hist_points_aspiration_retires(void);

/// Renvoie votre numéro de joueur.
extern "C" int api_moi(void);

/// Renvoie le numéro de votre adversaire.
extern "C" int api_adversaire(void);

/// Indique votre nombre de points d'actions restants pour ce tour-ci.
extern "C" int api_points_action(void);

/// Renvoie le score du joueur désigné par le numéro ``id_joueur``. Renvoie -1 si ``id_joueur`` est invalide.
extern "C" int api_score(int id_joueur);

/// Renvoie le numéro du tour actuel.
extern "C" int api_tour_actuel(void);

/// Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
extern "C" bool api_annuler(void);

/// Affiche le contenu d'une valeur de type erreur
extern "C" void api_afficher_erreur(erreur v);

/// Affiche le contenu d'une valeur de type case_type
extern "C" void api_afficher_case_type(case_type v);

/// Affiche le contenu d'une valeur de type position
extern "C" void api_afficher_position(__internal__cxx__position v);

/// Affiche le contenu d'une valeur de type pulsar_info
extern "C" void api_afficher_pulsar_info(__internal__cxx__pulsar_info v);

#endif
