/**
 *Strategy:
 * get the maximum gain by chosing the pulsars to go to wisely (cf. infra)
 * Reinforce the weak chains with the base by doubling them (to avoid losing too much when being bombed)
 * Destroy chain connected to the enemy's base when it is useful (cf. infra)
 * Repare destroyed chains, since the're probably useful
 * Enhance tuyaux to speed things up
 * Redistribute the 'puissances d'aspiration' to get more power
 * Try and steal some plasma collected by the opponent (let them farm, then take it)
 */
#include "prologin.hh"
#include <bits/stdc++.h>
using namespace std;

set<position> mine;
set<position> goals;
set<position> reinforceTodo;

vector<position> surrounding(const position&);

/**
 * compare to positions for inequality
 */
bool operator!=(const position& a, const position& b) {
    return (a.x != b.x || a.y != b.y);
}

/**
 * Union find - disjoint sets
 * Once planned to be used, now unfortunately unnecessary...
 */
template <typename T>
struct UF {
    map<T, T> p;

    T parent(T a) {
        if (p.count(a) == 0)
            return a;
        return p[a] = parent(p[a]);
    }

    bool same(T a, T b) {
        return parent(a) == parent(b);
    }

    void join(T a, T b) {
        if (!same(a, b))
        {
            p[parent(b)] = parent(a);
        }
    }
};

unsigned int H[TAILLE_TERRAIN][TAILLE_TERRAIN]; //The heuristic used by the A* algorithm

/**
 * Fill the heuristic for the A* algorithm
 * Using manhattan distance from every point to the nearest pulsar
 */
void fill_heuristic() {
    memset(H, -1, sizeof(H));
    for (int x = 0; x < TAILLE_TERRAIN; x++)
        for (int y = 0; y < TAILLE_TERRAIN; y++)
            for (const auto& p : liste_pulsars())
                H[x][y] = min(H[x][y], unsigned(abs(x - p.x) + abs(y - p.y)));
}

/// Fonction appelée au début de la partie.
/**
 * Initialisation
 * fill the heuristic used by the A* algorithm
 * Count all my bases as mine
 * make 4 goals around every pulsar, maximum gain!
 */
void partie_init()
{
  // fonction a completer
  srand(time(NULL));

  fill_heuristic();

  for (const auto& b : ma_base())
      mine.insert(b);

  for (const auto& p : liste_pulsars()) {
    for (const auto& k : surrounding(p))
        goals.insert(k);
  }
}

/**
 * Swap two positions o_O
 */
void swap(position& p, position& b) {
    swap(p.x, b.x);
    swap(p.y, b.y);
}

/**
 * Return a vector containing the surrounding positions of `p`
 */
vector<position> surrounding(const position& p) {
    vector<position> r;
    for (int dx = -1; dx < 2; dx++)
        for (int dy = -1; dy < 2; dy++)
            if (abs(dx + dy) == 1)
                r.push_back(position{p.x + dx, p.y + dy});
    return r;
}

/**
 * Calculate the expected gain when connection `p` to a base, given that we still have to do `dist` steps.
 * Uses every possible pulsar around the point, and calculates (obviously) the expected gain from each pulsar
 * by doing `number_of_pulsations_left * pulsation_power`
 */
double calcAdvantage(const position& p, int dist) {
    double ret = 0;
    for (int dx = -1; dx < 2; dx++)
        for (int dy = -1; dy < 2; dy++)
            if (abs(dx + dy) == 1 && type_case(position{p.x + dx, p.y + dy}) == PULSAR)
            {
                auto info = info_pulsar(position{p.x + dx, p.y + dy});
                int puls_before_there = 0;
                for (int i = 0; i < dist; i++)
                    puls_before_there += (tour_actuel() + i + 1) % info.periode == 0;
                ret += (info.pulsations_restantes - puls_before_there) * info_pulsar(position{p.x + dx, p.y + dy}).puissance;
            }
    return ret;
}

/**
 * Reinforce a single line, by searching (using a BFS) the nearest owned base reachable
 * And then connecting to it
 *
 * State of building the reinforcements is resolved by erasing
 * the previous starting point and setting the new one where we run out of action points
 */
void reinforce() {
    while (points_action() && reinforceTodo.size()) {
        position pulsar = *reinforceTodo.begin();
        reinforceTodo.erase(reinforceTodo.begin());
        queue<position> q;
        q.push(pulsar);
        map<position, position> parent;
        parent[pulsar] = pulsar;

        position p;
        while (!q.empty()) {
            p = q.front();
            q.pop();

            if (type_case(p) == BASE && proprietaire_base(p) == moi()) {
                break;
            }

            for (int dx = -1; dx < 2; dx++)
                for (int dy = -1; dy < 2; dy++)
                    if (abs(dx + dy) == 1)
                    {
                        position n = {p.x + dx, p.y + dy};
                        if (parent.find(n) == parent.end() && (find(mine.begin(), mine.end(), n) == mine.end() || type_case(n) == BASE)) {
                            q.push(n);
                            parent[n] = p;
                        }
                    }
        }

        position fin = p;

        stack<position> s;
        if (type_case(p) == BASE && proprietaire_base(p) == moi()) {
            while (p != parent[p]){
                p = parent[p];
                s.push(p);
            }
            while (!s.empty()) {
                if (construire(s.top()) == OK) {
                    mine.insert(s.top());
                    goals.erase(s.top());
                }
                else if (!points_action())
                {
                    reinforceTodo.insert(s.top());
                    return;
                }
                else if (est_tuyau(s.top()))
                {
                    mine.insert(s.top());
                    goals.erase(s.top());
                }
                s.pop();
            }
        }
    }
}

/**
 * Build some tuyaux, originally using the A* algorithm, but now just taking the
 * most cost-effective pulsar to go to (cf. supra)
 */
void aS() {
    using ii = pair<int, int>;
    using T = pair<ii, position>;
    priority_queue<T, deque<T>, greater<T> > q;
    map<position, int> cost;
    map<position, position> parent;

    for (const auto& p : mine)
    {
        q.push(T(ii(H[p.x][p.y], 0), p));
        parent[p] = p;
        cost[p] = 0;
    }

    position p{-1, -1};
    position bestcost{-1, -1};
    double _bestcost = 0;
    while (!q.empty()) {
        T item = q.top();
        q.pop();
        int c = item.first.second;
        p = item.second;

        if (goals.count(p) > 0)
        {
            double adv = calcAdvantage(p, c / 4);
            if (type_case(p) == DEBRIS)
                adv = 10000;

            if (adv > _bestcost)
            {
                bestcost = p;
                _bestcost = adv;
            }
        }

        for (int dx = -1; dx < 2; dx++)
            for (int dy = -1; dy < 2; dy++)
                if (dx == 0 && dy != 0 || dx != 0 && dy == 0)
                {
                    if (cost.count(position{p.x + dx, p.y + dy}) == 0 || cost[position{p.x + dx, p.y + dy}] > c) {
                        switch (type_case(position{p.x + dx, p.y + dy})) {
                            case VIDE: case TUYAU: case SUPER_TUYAU:
                                cost[position{p.x + dx, p.y + dy}] = c;
                                parent[position{p.x + dx, p.y + dy}] = p;
                                q.push(T(ii(c + 1 + H[p.x + dx][p.y + dy], c + 1), position{p.x + dx, p.y + dy}));
                                break;
                            case DEBRIS:
                                cost[position{p.x + dx, p.y + dy}] = c;
                                parent[position{p.x + dx, p.y + dy}] = p;
                                q.push(T(ii(c + 3 + H[p.x + dx][p.y + dy], c + 3), position{p.x + dx, p.y + dy}));
                                break;
                        }
                    }
                }
    }

    p = bestcost;

    stack<position> s;
    while (parent.count(bestcost) > 0 && bestcost != parent[bestcost]) {
        s.push(bestcost);
        bestcost = parent[bestcost];
    }

    if (type_case(bestcost) == BASE)
    {
        if (reinforceTodo.size() && reinforceTodo.count(p) == 0) return;
        reinforceTodo.insert(p);
    }

    while (!s.empty()) {
        p = s.top();
        if (type_case(p) == DEBRIS && deblayer(p) == OK && construire(p) == OK)
        {
            goals.erase(p);
            mine.insert(p);
        }
        else if (type_case(p) == DEBRIS)
        {
            goals.insert(p);
        }
        else if (construire(p) == OK || est_tuyau(p))
        {
            goals.erase(p);
            mine.insert(p);
        }
        else
        {
            break;
        }

        s.pop();
    }
}

/**
 * Repare destroyed tuyaux, since we probably built them, they are usefull enough to rebuild
 */
void repare() {
    vector<position> ps = hist_tuyaux_detruits();
    if (!ps.empty()) {
        if (deblayer(ps[0]) == OK && construire(ps[0]) == OK)
            return;
        else
            goals.insert(ps[0]);
    }
}

/**
 * Let out some straight lines from the corner of the base,
 * This happens to steal quite some plasma in some nice cases
 */
void dummy() {
    for (const auto& b : ma_base()) {
        if (b.x == 38 || b.x == 0)
        {
            for (int k = 0; k < 15; k++)
            {
                if (type_case(position{k+ 1, 13}) == PULSAR) break;
                if (construire(position{k + 1, 13}) == OK)
                    mine.insert(position{k + 1, 13}), goals.erase(position{k + 1, 13});
            }
            for (int k = 0; k < 15; k++)
            {
                if (type_case(position{k+ 1, 25}) == PULSAR) break;
                if (construire(position{k + 1, 25}) == OK)
                    mine.insert(position{k + 1, 25}), goals.erase(position{k + 1, 25});
            }
            for (int k = 36; k > 21; k--)
            {
                if (type_case(position{k+ 1, 13}) == PULSAR) break;
                if (construire(position{k + 1, 13}) == OK)
                    mine.insert(position{k + 1, 13}), goals.erase(position{k + 1, 13});
            }
            for (int k = 36; k > 21; k--)
            {
                if (type_case(position{k+ 1, 25}) == PULSAR) break;
                if (construire(position{k + 1, 25}) == OK)
                    mine.insert(position{k + 1, 25}), goals.erase(position{k + 1, 25});
            }
            break;
        }
        else if (b.y == 38 || b.y == 0)
        {
            for (int k = 0; k < 15; k++)
            {
                if (type_case(position{13, k+ 1}) == PULSAR) break;
                if (construire(position{13, k + 1}) == OK)
                    mine.insert(position{13, k + 1}), goals.erase(position{13, k + 1});
            }
            for (int k = 0; k < 15; k++)
            {
                if (type_case(position{25, k+ 1}) == PULSAR) break;
                if (construire(position{25, k + 1}) == OK)
                    mine.insert(position{25, k + 1}), goals.erase(position{25, k + 1});
            }
            for (int k = 36; k > 21; k--)
            {
                if (type_case(position{13, k+ 1}) == PULSAR) break;
                if (construire(position{13, k + 1}) == OK)
                    mine.insert(position{13, k + 1}), goals.erase(position{13, k + 1});
            }
            for (int k = 36; k > 21; k--)
            {
                if (type_case(position{25, k+ 1}) == PULSAR) break;
                if (construire(position{25, k + 1}) == OK)
                    mine.insert(position{25, k + 1}), goals.erase(position{25, k + 1});
            }
            break;
        }
    }
}

/**
 * Use leftover action points by improving (currently randomly chosen) tuyaux into super-tuyaux
 * Would be better to make them one 'super', one normal
 */
void ameliore() {
    int done = 0;
    while (points_action() && done < 15) {
        int r = rand() % mine.size();
        auto it = mine.begin();
        for (; it != mine.end() && r >= 0; ++it, r--);
        ameliorer(*it);
        ++done;
    }
}

/**
 * Count the number of plasma units that could be destroyed, using a depth limited DFS
 */
int canDestroy(const position& p, int depth, set<position>& used) {
    if (depth <= 0) return 0;
    used.insert(p);
    int sum = charges_presentes(p);
    for (const auto& a : surrounding(p)) {
        if (est_tuyau(a) && used.count(a) == 0) {
            sum += canDestroy(a, depth - 1, used);
        }
    }
    return sum;
}

int canDestroy(const position& p, int depth=10) {
    set<position> used;
    return canDestroy(p, depth, used);
}

/**
 * count the number of bases reachable from a given position, using DFS
 */
int numBasesReachable(const position& p, set<position>& used) {
    if (type_case(p) == BASE)
        return 1;
    if (!est_tuyau(p)) return 0;
    used.insert(p);
    int sum = 0;
    for (auto& n : surrounding(p)) {
        if (used.count(n) == 0)
            sum += numBasesReachable(n, used);
    }
    return sum;
}

int numBasesReachable(const position& p) {
    set<position> used;
    return numBasesReachable(p, used);
}

/**
 * Try to destroy anything if it is worth it
 * Considered 'worth it' if it loses at least 8 plasma points for the enemy
 * Using a normal and a depth limited DFS
 */
void destroy() {
    int best = -1;
    position B{-1, -1};
    for (const auto& b : base_ennemie()) {
        for (const auto& p : surrounding(b)) {
            if (est_tuyau(p)) {
                int destroyable = canDestroy(p);
                if (destroyable > 7 && numBasesReachable(p) <= 1)
                    if (destroyable > best)
                        best = destroyable, B = p;
            }
        }
    }
    if (best > 0)
        detruire(B);
}

/**
 * Test if a tuyau is connected to this position
 */
bool tuyau_connecte(const position& p) {
    for (const auto& a : surrounding(p))
        if (est_tuyau(a))
            return true;
    return false;
}

/**
 * Reallocate the puissances d'aspiration
 * Simply by moving those from unused bases to used bases
 */
void reallocForces() {
    for (auto& c : ma_base()) {
        if (tuyau_connecte(c)) {
            for (const auto& b : ma_base()) {
                if (puissance_aspiration(b) && !tuyau_connecte(b)) {
                    if (deplacer_aspiration(b, c) == OK)
                    {
                        return;
                    }
                }
            }
        }
    }
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    auto t = chrono::high_resolution_clock::now();

    //Main logic, do every time
    aS();
    reinforce();
    reallocForces();
    repare();
    destroy();
    dummy();
    ameliore();

    //Write out the time taken
    chrono::duration<double> duration = chrono::high_resolution_clock::now() - t;
    cout << duration.count() << endl;
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
  // fonction a completer
  if (score(moi()) > score(adversaire())) {
      cout << "Gagné!\n  (42)" << endl;
  }
  else {
      cout << "J'ai perdu" << endl;
      //Et vous aussi (revanche pour la demi-finale...)
  }
}

