# -*- coding: utf-8 -*-
# This file has been generated, if you wish to
# modify it in a permanent way, please refer
# to the script file : gen/generator_python.rb

'''
Objectif: Trouver les bons poids du tri de ma fonction Trouver_Cible. Je choisi une cible qui me raportera beaucoup de points une fois acquise et d'une distance resonnable.
Je retiens l'action que je n'ai pas peu finir au dernier tour pour l'achever. Cela evite des changement de decision et donc de perdre des points d'actions inutilement. 
Je considere les grands liens comme bien car bloque beaucoup l'adversaire.

J'essay de minimiser les calcul pour respecter le time out sur des cartes comportant beaucoup de portails.
'''

from api import *
from math import *


global Mes_Portails
Mes_Portails = set()
global Ses_Portails
Ses_Portails = set()
global Neutre_Portails
Neutre_Portails = set()
global Interne_Portails
Interne_Portails = set()

global Cible_Memoire
Cible_Memoire = None


# UTILITY
'''Renvoi si la liaison entre les deux point est faisable. (On peut exclure certain lien existant)'''
def Lien_Possible(pos1, pos2, exception = set()):
    for lien in liste_liens():
        if intersection_segments(pos1, pos2, lien[0], lien[1]) == True:
            if (not lien in exception) and (not (lien[1], lien[0]) in exception):
                return False
    return True

'''Renvoi le score que l'on obtient si on capture le portail'''
def Score_Portail(portail, exception = set()):
    score = 0
    liste = []
    
    liste = Trouver_Liens(portail, exception)

    for i, obj in enumerate(liste):
        for j in range(i+1, len(liste)):
            obj_ = liste[j]
            if lien_existe(obj, obj_) == True:
                score += score_triangle(portail, obj, obj_)
    
    return score
        
'''Renvoi une liste de portails que l'on peut lier a la position indiquee.'''
def Trouver_Liens(pos, exception = set()):
    liste = []
    for port in Mes_Portails:
        if port != pos:
            if Lien_Possible(pos, port, exception) == True:                              
                liste += [port]
                
                            
    return liste

'''Va choisir la cible optimale a attaquer !'''
def Trouver_Cible(pos):
    tout_portails = []

    for port in Ses_Portails:
        if not port in Interne_Portails:
            tout_portails += [port]
    for port in Neutre_Portails:
        if not port in Interne_Portails:
            tout_portails += [port]
    
    tout_portails = sorted(tout_portails, key=lambda port: (distance(pos, port) * -1000 + Score_Portail(port, liens_incidents_portail(port)) * 100 + portail_boucliers(port) * -10),reverse = True)    
    
    return tout_portails[0]   

'''Deplace au possible l'agent vers l'objectif. Puis renvoi True si l'objectif est atteint, dans le cas contraire False.'''
def Deplacer_Objectif(objectif):
    
    dist = distance(position_agent(moi()), objectif)

    while points_action() >= COUT_TURBO and dist > points_deplacement():
        utiliser_turbo()     

    if dist == 0:
        return True

    elif dist <= points_deplacement():
        deplacer(objectif)
        return True 
      
    else:        
        deltaX = objectif[0] - position_agent(moi())[0]
        deltaY = objectif[1] - position_agent(moi())[1]

        dif_X = 0
        dif_Y = 0

        if deltaX == 0:
            dif_Y = points_deplacement() * (deltaY / abs(deltaY))

        elif deltaY == 0:
            dif_X = points_deplacement() * (deltaX / abs(deltaX))

        else:

            if abs(deltaX) <= points_deplacement():
                dif_X = deltaX
                dif_Y = (points_deplacement() - abs(deltaX)) * (deltaY / abs(deltaY))
            else:
                dif_X = points_deplacement() * (deltaX / abs(deltaX))
        
        pos = (position_agent(moi())[0] + dif_X, position_agent(moi())[1] + dif_Y)
        deplacer(pos)
        return False

'''Rend compte des actions effectuees par l'adversaire'''
def Analyse():
    
    for port in hist_portails_captures():
        Neutre_Portails.discard(port)
        Ses_Portails.add(port)

    for port in hist_portails_neutralises():
        Mes_Portails.remove(port)

    
    Interne_Portails.clear()
    for port in liste_portails():
        if case_dans_champ(port) == True:
            Interne_Portails.add(port)
        
          
        
'''Fonction appelée au début de la partie.'''
def partie_init():
    for port in liste_portails():
        Neutre_Portails.add(port)

'''Fonction appelée à chaque tour.'''
def jouer_tour():

    Analyse()
    
    global Cible_Memoire
    cible = None

    if Cible_Memoire != None:
        cible = Cible_Memoire

    if(Cible_Memoire == None):
        print('Pas de memoire !!!')
    
    # Autrement dit tant que je peux faire des actions...
    while Cible_Memoire == None or points_action() == NB_POINTS_ACTION:
        
        if Cible_Memoire == None:
            cible = Trouver_Cible(position_agent(moi()))
            Cible_Memoire = cible    

        # Deplacement
        if Deplacer_Objectif(cible) == True:    

            #Cas ou l'objectif appartient a l'adversaire
            if (portail_joueur(cible) == adversaire()):            

                if points_action() >= COUT_NEUTRALISATION + COUT_NEUTRALISATION_BOUCLIER * portail_boucliers(cible):
                    neutraliser()
                    Ses_Portails.remove(cible)
                    Neutre_Portails.add(cible)

                    if points_action() >= COUT_CAPTURE:
                        capturer()
                        Mes_Portails.add(cible)
                        Neutre_Portails.remove(cible)

                        portail_liens = Trouver_Liens(cible)
                        for port in portail_liens:
                            if points_action() >= COUT_LIEN:
                                lier(port)                                
                            else:
                                break
                        else:
                            Cible_Memoire = None
                            for port in Neutre_Portails:
                                if case_dans_champ(port) == True:
                                    Interne_Portails.add(port)

                        for i in range(6):
                            if points_action() >= COUT_BOUCLIER:
                                ajouter_bouclier()

            #Cas ou l'objectif est Neutre
            elif (portail_joueur(cible) != moi()):
                
                if points_action() >= COUT_CAPTURE:
                        capturer()
                        Neutre_Portails.discard(cible)
                        Mes_Portails.add(cible)

                        portail_liens = Trouver_Liens(cible)
                        for port in portail_liens:
                            if points_action() >= COUT_LIEN:
                                lier(port)
                            else:
                                break
                        else:
                            Cible_Memoire = None
                            for port in Neutre_Portails:
                                if case_dans_champ(port) == True:
                                    Interne_Portails.add(port)

                        for i in range(6):
                            if points_action() >= COUT_BOUCLIER:
                                ajouter_bouclier()

            #Cas ou l'objectif m'appartient (Donc je changes d'objectif)
            else:
                Cible_Memoire = None   
        
    
            
  
'''Fonction appelée à la fin de la partie.'''
def partie_fin():
    print('gg')
    pass # Place ton code ici

