// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

// Erreurs possibles
enum Erreur {
  OK, // <- L'action a été exécutée avec succès
  PA_INSUFFISANTS, // <- Vous ne possédez pas assez de points d'action pour cette action.
  AUCUN_PORTAIL, // <- La position spécifiée n'est pas un portail.
  POSITION_INVALIDE, // <- La position spécifiée est hors de la carte.
  POSITION_ELOIGNEE, // <- La destination est trop éloignée.
  PORTAIL_AMI, // <- Le portail vous appartient.
  PORTAIL_NEUTRE, // <- Le portail est neutre.
  PORTAIL_ENNEMI, // <- Le portail appartient à votre adversaire.
  LIEN_INTERSECTION, // <- Le lien croise un lien existant.
  LIEN_CHAMP, // <- Le lien se trouve dans un champ existant.
  LIEN_DEGENERE, // <- Les deux extrémités du lien coïncident.
  LIMITE_BOUCLIERS, // <- Ce portail est équipé du nombre maximal de boucliers.
}

// Position sur la carte, donnée par deux coordonnées.
class Position {
  public int x; // Coordonnée en X
  public int y; // Coordonnée en Y
}

// Représente un lien existant.
class Lien {
  public Position extr1 = new Position(); // Première extrémité du lien.
  public Position extr2 = new Position(); // Seconde extrémité du lien.
  public int joueur_l; // Joueur possédant ce lien.
}

// Représente un champ de contrôle existant.
class Champ {
  public Position som1 = new Position(); // Premier sommet du champ.
  public Position som2 = new Position(); // Deuxième sommet du champ.
  public Position som3 = new Position(); // Troisième sommet du champ.
  public int joueur_c; // Joueur possédant ce champ.
}

public class Interface
{
  // Taille du terrain (longueur et largeur).
  public static final int TAILLE_TERRAIN = 30;

  // Nombre de tours à jouer avant la fin de la partie.
  public static final int NB_TOURS = 100;

  // Nombre de points de déplacement par tour (avant utilisation du turbo).
  public static final int NB_POINTS_DEPLACEMENT = 6;

  // Nombre de points d'action par tour.
  public static final int NB_POINTS_ACTION = 42;

  // Nombre de points d'action que coûte la capture d'un portail.
  public static final int COUT_CAPTURE = 3;

  // Nombre de points d'action que coûte la création d'un lien.
  public static final int COUT_LIEN = 2;

  // Nombre de points d'action que coûte la neutralisation d'un portail de base.
  public static final int COUT_NEUTRALISATION = 10;

  // Nombre de points d'action supplémentaires que coûte la neutralisation pour chaque bouclier présent.
  public static final int COUT_NEUTRALISATION_BOUCLIER = 5;

  // Nombre de points d'action que coûte la mise en place d'un bouclier sur un portail sans bouclier.
  public static final int COUT_BOUCLIER = 3;

  // Nombre de points d'action que coûte l'utilisation d'un turbo.
  public static final int COUT_TURBO = 6;

  // Nombre maximum de boucliers sur un même portail.
  public static final int MAX_BOUCLIERS = 6;

  // Nombre de points que rapporte la capture d'un portail.
  public static final int POINTS_CAPTURE = 10;

  // Constante de proportionnalité reliant l'aire d'un champ au nombre de points qu'il rapporte par tour.
  public static final int POINTS_CHAMP = 2;

  // Déplace votre agent sur la case passée en argument.
  public static native Erreur deplacer(Position dest);

  // Utilise un turbo.
  public static native Erreur utiliser_turbo();

  // Capture le portail où est positionné votre agent.
  public static native Erreur capturer();

  // Crée un lien entre le portail où se trouve votre agent et le portail de destination donné en argument.
  public static native Erreur lier(Position portail);

  // Neutralise le portail où se trouve votre agent.
  public static native Erreur neutraliser();

  // Ajoute un bouclier au portail sur lequel se trouve votre agent.
  public static native Erreur ajouter_bouclier();

  // Renvoie la liste de tous les liens présents.
  public static native Lien[] liste_liens();

  // Renvoie la liste de tous les champs de contrôle.
  public static native Champ[] liste_champs();

  // Renvoie la liste de tous les portails de la carte.
  public static native Position[] liste_portails();

  // Renvoie la liste de tous les liens existants qui croisent un segment, entravant la création d'un lien.
  public static native Lien[] liens_bloquants(Position ext1, Position ext2);

  // Prend les positions de deux portails, et renvoie un booléen indiquant s'ils sont reliés. Le résultat est `false` lorsque l'une des deux positions ne repère pas un portail.
  public static native boolean lien_existe(Position ext1, Position ext2);

  // Renvoie un booléen indiquant si les 3 positions repèrent bien 3 portails tous reliés entre eux.
  public static native boolean champ_existe(Position som1, Position som2, Position som3);

  // Renvoie un booléen indiquant si la case ``pos`` se trouve dans un champ.
  public static native boolean case_dans_champ(Position pos);

  // Renvoie la liste des champs à l'intérieur desquels ``pos`` se trouve. Si la case est un portail, le résultat de ``case_champs`` sera disjoint de celui de ``champs_incidents_portail``.
  public static native Champ[] case_champs(Position pos);

  // Renvoie le numéro du joueur correspondant au portail donné, -1 si le portail est neutre, -2 si la case n'est pas un portail. Vous pouvez utiliser cette fonction pour vérifier qu'une case donnée est bien un portail.
  public static native int portail_joueur(Position portail);

  // Renvoie le nombre de boucliers présents sur un portail (-2 si la case n'est pas un portail).
  public static native int portail_boucliers(Position portail);

  // Renvoie la liste de tous les liens dont le portail donné est une extrémité.
  public static native Lien[] liens_incidents_portail(Position portail);

  // Renvoie la liste de tous les champs dont le portail donné est un sommet.
  public static native Champ[] champs_incidents_portail(Position portail);

  // Renvoie la liste de tous les champs dont le lien donné est un côté. Si le segment n'est pas un lien présent, renvoie la liste de tous les champs que la création du lien ferait apparaître.
  public static native Champ[] champs_incidents_segment(Position ext1, Position ext2);

  // Renvoie la liste des portails capturés par votre adversaire au dernier tour.
  public static native Position[] hist_portails_captures();

  // Renvoie la liste des portails neutralisés par votre adversaire au dernier tour.
  public static native Position[] hist_portails_neutralises();

  // Renvoie la liste des liens créés par votre adversaire au dernier tour.
  public static native Lien[] hist_liens_crees();

  // Renvoie la liste des champs créés par votre adversaire au dernier tour.
  public static native Champ[] hist_champs_crees();

  // Renvoie la liste des positions où votre adversaire a ajouté des boucliers au dernier tour.
  public static native Position[] hist_boucliers_ajoutes();

  // Renvoie la distance de Manhattan entre deux positions.
  public static native int distance(Position pos1, Position pos2);

  // Renvoie le nombre de points que rapporte(rait) chaque tour un champ existant ou hypothétique.
  public static native int score_triangle(Position som1, Position som2, Position som3);

  // Indique si deux segments se croisent. Cette fonction correspond exactement à la condition d'interférence entre liens, c'est-à-dire qu'elle renvoie ``false`` si l'intersection est une extrémité des deux segments.
  public static native boolean intersection_segments(Position a1, Position a2, Position b1, Position b2);

  // Indique si un point se trouve à l'intérieur d'un triangle. Le critère coïncide avec celui de ``case_champs``.
  public static native boolean point_dans_triangle(Position p, Position som1, Position som2, Position som3);

  // Renvoie votre numéro de joueur.
  public static native int moi();

  // Renvoie le numéro de votre adversaire.
  public static native int adversaire();

  // Indique la position de l'agent du joueur désigné par le numéro ``id_joueur``.
  public static native Position position_agent(int id_joueur);

  // Indique votre nombre de points d'actions restants pour ce tour-ci.
  public static native int points_action();

  // Indique votre nombre de points de déplacement restants pour ce tour-ci.
  public static native int points_deplacement();

  // Renvoie le score du joueur désigné par le numéro ``id_joueur``.
  public static native int score(int id_joueur);

  // Renvoie le numéro du tour actuel.
  public static native int tour_actuel();

  // Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
  public static native boolean annuler();

  // Affiche le contenu d'une valeur de type erreur
  public static native void afficher_erreur(Erreur v);

  // Affiche le contenu d'une valeur de type position
  public static native void afficher_position(Position v);

  // Affiche le contenu d'une valeur de type lien
  public static native void afficher_lien(Lien v);

  // Affiche le contenu d'une valeur de type champ
  public static native void afficher_champ(Champ v);

}
