<?php
/*
 * Taille du terrain (longueur et largeur).
 */
define('TAILLE_TERRAIN', 39);

/*
 * Longueur de chacune de vos deux bases.
 */
define('LONGUEUR_BASE', 13);

/*
 * Nombre de tours à jouer avant la fin de la partie.
 */
define('NB_TOURS', 100);

/*
 * Nombre de points d'action par tour.
 */
define('NB_POINTS_ACTION', 4);

/*
 * Nombre de points d'action que coûte la construction d'un tuyau.
 */
define('COUT_CONSTRUCTION', 1);

/*
 * Nombre de points d'action que coûte l'amélioration d'un tuyau.
 */
define('COUT_AMELIORATION', 1);

/*
 * Nombre de points d'action que coûte la destruction d'un tuyau.
 */
define('COUT_DESTRUCTION', 3);

/*
 * Nombre de points d'action que coûte la destruction d'un Super Tuyau™.
 */
define('COUT_DESTRUCTION_SUPER_TUYAU', 4);

/*
 * Charge en plasma nécessaire pour la destruction d'un tuyau ou d'un Super Tuyau™.
 */
define('CHARGE_DESTRUCTION', 2.0);

/*
 * Nombre de points d'action que coûte le déblayage d'une case de débris.
 */
define('COUT_DEBLAYAGE', 2);

/*
 * Nombre de points d'action que coûte le déplacement d'une unité de puissance d'aspiration de la base (la première modification de chaque tour est offerte).
 */
define('COUT_MODIFICATION_ASPIRATION', 1);

/*
 * Limite de puissance d'aspiration sur une case de base.
 */
define('LIMITE_ASPIRATION', 5);

/*
 * Vitesse du plasma dans un tuyau normal, en nombre de cases par tour.
 */
define('VITESSE_TUYAU', 1);

/*
 * Multiplicateur de la vitesse du plasma dans un Super Tuyau™.
 */
define('MULTIPLICATEUR_VITESSE_SUPER_TUYAU', 2);

/*
 * Erreurs possibles
 */
define('OK', 0); // L'action a été exécutée avec succès.
define('PA_INSUFFISANTS', 1); // Vous ne possédez pas assez de points d'action pour cette action.
define('AUCUN_TUYAU', 2); // Il n'y a pas de tuyau à la position spécifiée.
define('POSITION_INVALIDE', 3); // La position spécifiée est hors de la carte.
define('PUISSANCE_INSUFFISANTE', 4); // Vous ne possédez pas assez de puissance d'asipration sur cette partie de la base.
define('DEPLACEMENT_INVALIDE', 5); // Vous ne pouvez pas déplacer de la puissance d'aspiration d'une case à elle-même.
define('PAS_DANS_BASE', 6); // Cette case n'appartient pas à votre base.
define('AMELIORATION_IMPOSSIBLE', 7); // Il y a déjà un Super Tuyau™ sur cette case.
define('CONSTRUCTION_IMPOSSIBLE', 8); // Il est impossible de construire un tuyau à la position indiquée.
define('DESTRUCTION_IMPOSSIBLE', 9); // Il n'y a pas de tuyau à la position spécifiée.
define('PAS_DE_PULSAR', 10); // Il n'y a pas de pulsar à la position spécifiée.
define('PAS_DE_DEBRIS', 11); // Il n'y a pas de débris à la position spécifiée.
define('CHARGE_INSUFFISANTE', 12); // Vous ne possédez pas assez de plasma pour lancer une destruction.
define('LIMITE_ASPIRATION_ATTEINTE', 13); // Vous avez atteint la limite d'aspiration sur cette case.

/*
 * Types de cases
 */
define('VIDE', 0); // Case vide
define('TUYAU', 1); // Case contenant un tuyau
define('SUPER_TUYAU', 2); // Case contenant un Super Tuyau™
define('DEBRIS', 3); // Case contenant des débris à déblayer
define('PULSAR', 4); // Case contenant un pulsar
define('BASE', 5); // Case appartenant à une base d'un des joueurs
define('INTERDIT', 6); // Case où aucune action n'est possible

?>
