/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
using namespace std;

const double e = 0.9;

int MOI,ADV;
int power[2];
double scores[39][39]={{0}};
double maxi=0;
int nbplay[39][39]={{0}};
int nbtotplay = 1;
case_type carte[39][39];
int aspi[39][39]={{0}};
int potentiel[39][39]={{0}};
map<position,pulsar_info> pulsars;
map<position,double> plasmas;
set<position> tuyaux;
map<position,set<position>> graphe;
set<position> sommets;
map<position,int> base;
int points[2]={0,0};

int potentielfake[39][39]={{0}};
map<position,pulsar_info> pulsarsfake;
map<position,double> plasmasfake;
set<position> tuyauxfake;
map<position,set<position>> graphefake;
set<position> sommetsfake;
int pointsfake[2];


int dist(position pos1, position pos2){
    return abs(pos1.x-pos2.x) + abs(pos1.y-pos2.y);
}

double f(int i, int j, int p){
    if(nbplay[i][j]<=1)
        return -1;
    else
        return max(0.,p*scores[i][j]) + sqrt(2*log(nbplay[i][j])/nbtotplay);
}

void evolPlasma(int t){
    double points0=0,points1=0;
    map<position,double> aux;
    aux.swap(plasmas);
    for(auto& x:aux){
        position pos=x.first;
        vector<position> directions;
        if(0<=pos.x-1 and pos.x-1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x-1][pos.y]==potentiel[pos.x][pos.y]+1){
            directions.emplace_back(position{pos.x-1,pos.y});
        }
        if(0<=pos.x+1 and pos.x+1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x+1][pos.y]==potentiel[pos.x][pos.y]+1){
            directions.emplace_back(position{pos.x+1,pos.y});
        }
        if(0<=pos.x and pos.x<39 and 0<=pos.y-1 and pos.y-1<39 and potentiel[pos.x][pos.y-1]==potentiel[pos.x][pos.y]+1){
            directions.emplace_back(position{pos.x,pos.y-1});
        }
        if(0<=pos.x and pos.x<39 and 0<=pos.y+1 and pos.y+1<39 and potentiel[pos.x][pos.y+1]==potentiel[pos.x][pos.y]+1){
            directions.emplace_back(position{pos.x,pos.y+1});
        }
        if(carte[pos.x][pos.y]==SUPER_TUYAU){
            for(position pos:directions){
                vector<position> directions2;
                if(0<=pos.x-1 and pos.x-1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x-1][pos.y]==potentiel[pos.x][pos.y]+1){
                    directions2.emplace_back(position{pos.x-1,pos.y});
                }
                if(0<=pos.x+1 and pos.x+1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x+1][pos.y]==potentiel[pos.x][pos.y]+1){
                    directions2.emplace_back(position{pos.x+1,pos.y});
                }
                if(0<=pos.x and pos.x<39 and 0<=pos.y-1 and pos.y-1<39 and potentiel[pos.x][pos.y-1]==potentiel[pos.x][pos.y]+1){
                    directions2.emplace_back(position{pos.x,pos.y-1});
                }
                if(0<=pos.x and pos.x<39 and 0<=pos.y+1 and pos.y+1<39 and potentiel[pos.x][pos.y+1]==potentiel[pos.x][pos.y]+1){
                    directions2.emplace_back(position{pos.x,pos.y+1});
                }
                for(position pos:directions2){
                    if(base.count(pos)==0)
                        plasmas[pos]+=x.second/(directions2.size()*directions.size());
                    else{
                        double pt = base[pos]*x.second/(directions2.size()*directions.size());
                        points0+=max(0.,pt);
                        points1+=max(0.,-pt);
                    }
                }
            }
        }
    }
    for(auto& x:pulsars){
        position pos= x.first;
        pulsar_info& puls = x.second;
        if(puls.pulsations_restantes>0 and (t+1)%puls.periode == 0){///A VERIFIER
            if(0<=pos.x-1 and pos.x-1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x-1][pos.y]!=5){
                plasmas[position{pos.x-1,pos.y}]+=puls.puissance;
            }
            if(0<=pos.x+1 and pos.x+1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x+1][pos.y]!=5){
                plasmas[position{pos.x+1,pos.y}]+=puls.puissance;
            }
            if(0<=pos.x and pos.x<39 and 0<=pos.y-1 and pos.y-1<39 and potentiel[pos.x][pos.y-1]!=5){
                plasmas[position{pos.x,pos.y-1}]+=puls.puissance;
            }
            if(0<=pos.x and pos.x<39 and 0<=pos.y+1 and pos.y+1<39 and potentiel[pos.x][pos.y+1]!=5){
                plasmas[position{pos.x,pos.y+1}]+=puls.puissance;
            }
            --puls.pulsations_restantes;
        }
    }
    points[0]+=(int)points0;
    points[1]+=(int)points1;
}

double evolPlasmafake(int t){
    map<position,double> aux;
    double res=0,pointsfake0=0,pointsfake1=0;
    aux.swap(plasmasfake);
    for(auto& x:aux){
        position pos=x.first;
        vector<position> directions;
        if(0<=pos.x-1 and pos.x-1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x-1][pos.y]==potentiel[pos.x][pos.y]+1){
            directions.emplace_back(position{pos.x-1,pos.y});
        }
        if(0<=pos.x+1 and pos.x+1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x+1][pos.y]==potentiel[pos.x][pos.y]+1){
            directions.emplace_back(position{pos.x+1,pos.y});
        }
        if(0<=pos.x and pos.x<39 and 0<=pos.y-1 and pos.y-1<39 and potentiel[pos.x][pos.y-1]==potentiel[pos.x][pos.y]+1){
            directions.emplace_back(position{pos.x,pos.y-1});
        }
        if(0<=pos.x and pos.x<39 and 0<=pos.y+1 and pos.y+1<39 and potentiel[pos.x][pos.y+1]==potentiel[pos.x][pos.y]+1){
            directions.emplace_back(position{pos.x,pos.y+1});
        }
        if(carte[pos.x][pos.y]==SUPER_TUYAU){
            for(position pos:directions){
                vector<position> directions2;
                if(0<=pos.x-1 and pos.x-1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x-1][pos.y]==potentiel[pos.x][pos.y]+1){
                    directions2.emplace_back(position{pos.x-1,pos.y});
                }
                if(0<=pos.x+1 and pos.x+1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x+1][pos.y]==potentiel[pos.x][pos.y]+1){
                    directions2.emplace_back(position{pos.x+1,pos.y});
                }
                if(0<=pos.x and pos.x<39 and 0<=pos.y-1 and pos.y-1<39 and potentiel[pos.x][pos.y-1]==potentiel[pos.x][pos.y]+1){
                    directions2.emplace_back(position{pos.x,pos.y-1});
                }
                if(0<=pos.x and pos.x<39 and 0<=pos.y+1 and pos.y+1<39 and potentiel[pos.x][pos.y+1]==potentiel[pos.x][pos.y]+1){
                    directions2.emplace_back(position{pos.x,pos.y+1});
                }
                for(position pos:directions2){
                    if(base.count(pos)==0)
                        plasmasfake[pos]+=x.second/(directions2.size()*directions.size());
                    else{
                        double pt = base[pos]*x.second/(directions2.size()*directions.size());
                        res+=pt;
                        pointsfake0+=max(0.,pt);
                        pointsfake1+=max(0.,-pt);
                    }
                }
            }
        }
    }
    for(auto& x:pulsarsfake){
        position pos= x.first;
        pulsar_info& puls = x.second;
        if(puls.pulsations_restantes>0 and (t+1)%puls.periode == 0){///A VERIFIER
            if(0<=pos.x-1 and pos.x-1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x-1][pos.y]!=5){
                plasmasfake[position{pos.x-1,pos.y}]+=puls.puissance;
            }
            if(0<=pos.x+1 and pos.x+1<39 and 0<=pos.y and pos.y<39 and potentiel[pos.x+1][pos.y]!=5){
                plasmasfake[position{pos.x+1,pos.y}]+=puls.puissance;
            }
            if(0<=pos.x and pos.x<39 and 0<=pos.y-1 and pos.y-1<39 and potentiel[pos.x][pos.y-1]!=5){
                plasmasfake[position{pos.x,pos.y-1}]+=puls.puissance;
            }
            if(0<=pos.x and pos.x<39 and 0<=pos.y+1 and pos.y+1<39 and potentiel[pos.x][pos.y+1]!=5){
                plasmasfake[position{pos.x,pos.y+1}]+=puls.puissance;
            }
            --puls.pulsations_restantes;
        }
    }
    pointsfake[0]+=(int)pointsfake0;
    pointsfake[1]+=(int)pointsfake1;
    return res;
}

void actualise(){
    for(int i=1;i<38;++i)
        for(int j=1;j<38;++j)
            potentiel[i][j] = 5;
    vector<vector<position>> toSee(700);
    for(auto& x:base){
        position pos = x.first;
        toSee[4-potentiel[pos.x][pos.y]].push_back(pos);
    }
    int i;
    for(i=0;i<5;++i){
        for(position pos:toSee[i]){
            if(0<pos.x-1 and pos.x-1<38 and 0<pos.y and pos.y<38 and (carte[pos.x-1][pos.y] == TUYAU or carte[pos.x-1][pos.y] == SUPER_TUYAU) and potentiel[pos.x-1][pos.y]==5){
                potentiel[pos.x-1][pos.y]=3-i;
            }
            if(0<pos.x+1 and pos.x+1<38 and 0<pos.y and pos.y<38 and (carte[pos.x+1][pos.y] == TUYAU or carte[pos.x+1][pos.y] == SUPER_TUYAU) and potentiel[pos.x+1][pos.y]==5){
                potentiel[pos.x+1][pos.y]=3-i;
            }
            if(0<pos.x and pos.x<38 and 0<pos.y-1 and pos.y-1<38 and (carte[pos.x][pos.y-1] == TUYAU or carte[pos.x][pos.y-1] == SUPER_TUYAU) and potentiel[pos.x][pos.y-1]==5){
                potentiel[pos.x][pos.y-1]=3-i;
            }
            if(0<pos.x and pos.x<38 and 0<pos.y+1 and pos.y+1<38 and (carte[pos.x][pos.y+1] == TUYAU or carte[pos.x][pos.y+1] == SUPER_TUYAU) and potentiel[pos.x][pos.y+1]==5){
                potentiel[pos.x][pos.y+1]=3-i;
            }
        }
    }
    while(!toSee[i].empty()){
        for(position pos:toSee[i]){
            if(0<pos.x-1 and pos.x-1<38 and 0<pos.y and pos.y<38 and (carte[pos.x-1][pos.y] == TUYAU or carte[pos.x-1][pos.y] == SUPER_TUYAU) and potentiel[pos.x-1][pos.y]==5){
                potentiel[pos.x-1][pos.y]=3-i;
            }
            if(0<pos.x+1 and pos.x+1<38 and 0<pos.y and pos.y<38 and (carte[pos.x+1][pos.y] == TUYAU or carte[pos.x+1][pos.y] == SUPER_TUYAU) and potentiel[pos.x+1][pos.y]==5){
                potentiel[pos.x+1][pos.y]=3-i;
            }
            if(0<pos.x and pos.x<38 and 0<pos.y-1 and pos.y-1<38 and (carte[pos.x][pos.y-1] == TUYAU or carte[pos.x][pos.y-1] == SUPER_TUYAU) and potentiel[pos.x][pos.y-1]==5){
                potentiel[pos.x][pos.y-1]=3-i;
            }
            if(0<pos.x and pos.x<38 and 0<pos.y+1 and pos.y+1<38 and (carte[pos.x][pos.y+1] == TUYAU or carte[pos.x][pos.y+1] == SUPER_TUYAU) and potentiel[pos.x][pos.y+1]==5){
                potentiel[pos.x][pos.y+1]=3-i;
            }
        }
        ++i;
    }
}

void actualisefake(){
    for(int i=1;i<38;++i)
        for(int j=1;j<38;++j)
            potentielfake[i][j] = 5;
    vector<vector<position>> toSee(700);
    for(auto& x:base){
        position pos = x.first;
        toSee[4-potentielfake[pos.x][pos.y]].push_back(pos);
    }
    int i;
    for(i=0;i<5;++i){
        for(position pos:toSee[i]){
            if(0<pos.x-1 and pos.x-1<38 and 0<pos.y and pos.y<38 and (carte[pos.x-1][pos.y] == TUYAU or carte[pos.x-1][pos.y] == SUPER_TUYAU) and potentielfake[pos.x-1][pos.y]==5){
                potentielfake[pos.x-1][pos.y]=3-i;
            }
            if(0<pos.x+1 and pos.x+1<38 and 0<pos.y and pos.y<38 and (carte[pos.x+1][pos.y] == TUYAU or carte[pos.x+1][pos.y] == SUPER_TUYAU) and potentielfake[pos.x+1][pos.y]==5){
                potentielfake[pos.x+1][pos.y]=3-i;
            }
            if(0<pos.x and pos.x<38 and 0<pos.y-1 and pos.y-1<38 and (carte[pos.x][pos.y-1] == TUYAU or carte[pos.x][pos.y-1] == SUPER_TUYAU) and potentielfake[pos.x][pos.y-1]==5){
                potentielfake[pos.x][pos.y-1]=3-i;
            }
            if(0<pos.x and pos.x<38 and 0<pos.y+1 and pos.y+1<38 and (carte[pos.x][pos.y+1] == TUYAU or carte[pos.x][pos.y+1] == SUPER_TUYAU) and potentielfake[pos.x][pos.y+1]==5){
                potentielfake[pos.x][pos.y+1]=3-i;
            }
        }
    }
    while(!toSee[i].empty()){
        for(position pos:toSee[i]){
            if(0<pos.x-1 and pos.x-1<38 and 0<pos.y and pos.y<38 and (carte[pos.x-1][pos.y] == TUYAU or carte[pos.x-1][pos.y] == SUPER_TUYAU) and potentielfake[pos.x-1][pos.y]==5){
                potentielfake[pos.x-1][pos.y]=3-i;
            }
            if(0<pos.x+1 and pos.x+1<38 and 0<pos.y and pos.y<38 and (carte[pos.x+1][pos.y] == TUYAU or carte[pos.x+1][pos.y] == SUPER_TUYAU) and potentielfake[pos.x+1][pos.y]==5){
                potentielfake[pos.x+1][pos.y]=3-i;
            }
            if(0<pos.x and pos.x<38 and 0<pos.y-1 and pos.y-1<38 and (carte[pos.x][pos.y-1] == TUYAU or carte[pos.x][pos.y-1] == SUPER_TUYAU) and potentielfake[pos.x][pos.y-1]==5){
                potentielfake[pos.x][pos.y-1]=3-i;
            }
            if(0<pos.x and pos.x<38 and 0<pos.y+1 and pos.y+1<38 and (carte[pos.x][pos.y+1] == TUYAU or carte[pos.x][pos.y+1] == SUPER_TUYAU) and potentielfake[pos.x][pos.y+1]==5){
                potentielfake[pos.x][pos.y+1]=3-i;
            }
        }
        ++i;
    }
}

void nextTurn(int t){
    actualise();
    evolPlasma(t);
}

int nextTurnfake(int t){
    actualisefake();
    return evolPlasmafake(t);
}

double play(int t, int p, int score){
    if(t==100){
        return score;
    }
    int PA = 4;
    vector<pair<int,int>> constr;
    vector<pair<int,int>> renf;
    vector<pair<int,int>> debl;
    vector<pair<int,int>> destr;
    vector<pair<int,int>> destrultra;
    vector<pair<pair<int,int>,case_type>> annule;
    while(PA!=0){
        int r=rand()%120;
        bool bcont = true;
        if(0<=r and r<24){///debl
            vector<pair<int,int>>opti;
            int mini=0;
            for(int i=1;i<38;++i){
                for(int j=1;j<38;++j){
                    double aux = f(i,j,p);
                    if(carte[i][j]==DEBRIS and (aux>mini or (aux==-1 and mini!=-1))){
                        mini=aux;
                        opti.clear();
                        bcont=false;
                    }
                    if(mini==aux){
                        opti.emplace_back(i,j);
                    }
                }
            }
            int r2=rand()%opti.size();
            debl.push_back(opti[r2]);
            annule.emplace_back(opti[r2],DEBRIS);
            carte[opti[r2].first][opti[r2].second]=VIDE;
            if(bcont)
                r=rand()%96+24;
        }



        if(24<=r and r<48){///destr
            if(PA>=3 and points[(1-p)/2]>=2){
                vector<pair<int,int>>opti;
                int mini=0;
                for(int i=1;i<38;++i){
                    for(int j=1;j<38;++j){
                        double aux = f(i,j,-p);
                        if(carte[i][j]==TUYAU and (aux>mini or (aux==-1 and mini!=-1))){
                            mini=aux;
                            opti.clear();
                            bcont=false;
                        }
                        if(mini==aux){
                            opti.emplace_back(i,j);
                        }
                    }
                }
                int r2=rand()%opti.size();
                destr.push_back(opti[r2]);
                annule.emplace_back(opti[r2],TUYAU);
                carte[opti[r2].first][opti[r2].second]=VIDE;
            }
            if(bcont)
                r=rand()%72+48;
        }



        if(48<=r and r<72){///renf
            vector<pair<int,int>>opti;
            int mini=0;
            for(int i=1;i<38;++i){
                for(int j=1;j<38;++j){
                    double aux = f(i,j,p);
                    if(carte[i][j]==TUYAU and (aux>mini or (aux==-1 and mini!=-1))){
                        mini=aux;
                        opti.clear();
                        bcont=false;
                    }
                    if(mini==aux){
                        opti.emplace_back(i,j);
                    }
                }
            }
            int r2=rand()%opti.size();
            renf.push_back(opti[r2]);
            annule.emplace_back(opti[r2],TUYAU);
            carte[opti[r2].first][opti[r2].second]=SUPER_TUYAU;
            if(bcont)
                r=rand()%48+72;
        }



        if(72<=r and r<96){///destrultra
            if(PA>=4 and points[(1-p)/2]>=2){
                vector<pair<int,int>>opti;
                int mini=0;
                for(int i=1;i<38;++i){
                    for(int j=1;j<38;++j){
                        double aux = f(i,j,-p);
                        if(carte[i][j]==SUPER_TUYAU and (aux>mini or (aux==-1 and mini!=-1))){
                            mini=aux;
                            opti.clear();
                            bcont=false;
                        }
                        if(mini==aux){
                            opti.emplace_back(i,j);
                        }
                    }
                }
                int r2=rand()%opti.size();
                destrultra.push_back(opti[r2]);
                annule.emplace_back(opti[r2],SUPER_TUYAU);
                carte[opti[r2].first][opti[r2].second]=VIDE;
            }
        }



        if(96<=r and r<120){///constr
            vector<pair<int,int>>opti;
            int mini=0;
            for(int i=1;i<38;++i){
                for(int j=1;j<38;++j){
                    double aux = f(i,j,p);
                    if(carte[i][j]==VIDE and (aux>mini or (aux==-1 and mini!=-1))){
                        mini=aux;
                        opti.clear();
                        bcont=false;
                    }
                    if(mini==aux){
                        opti.emplace_back(i,j);
                    }
                }
            }
            int r2=rand()%opti.size();
            constr.push_back(opti[r2]);
            annule.emplace_back(opti[r2],VIDE);
            carte[opti[r2].first][opti[r2].second]=TUYAU;
        }
        if(bcont)
            return score;
    }
    score += p*nextTurnfake(t);
    int toAdd = play(t+1,-p,score);
/// TODO: actualiser carte,
    for(auto& x:constr){
        scores[x.first][x.second]*=nbplay[x.first][x.second];
        scores[x.first][x.second]+=toAdd*t;
        ++nbplay[x.first][x.second];
        scores[x.first][x.second]/=nbplay[x.first][x.second];
        if(abs(scores[x.first][x.second])>maxi)
            maxi=abs(scores[x.first][x.second]);
    }
    for(auto& x:renf){
        scores[x.first][x.second]*=nbplay[x.first][x.second];
        scores[x.first][x.second]+=toAdd*t;
        ++nbplay[x.first][x.second];
        scores[x.first][x.second]/=nbplay[x.first][x.second];
        if(abs(scores[x.first][x.second])>maxi)
            maxi=abs(scores[x.first][x.second]);

    }
    for(auto& x:debl){
        scores[x.first][x.second]*=nbplay[x.first][x.second];
        scores[x.first][x.second]+=2*toAdd*t;
        nbplay[x.first][x.second]+=2;
        scores[x.first][x.second]/=nbplay[x.first][x.second];
        if(abs(scores[x.first][x.second])>maxi)
            maxi=abs(scores[x.first][x.second]);

    }
    for(auto& x:destr){
        scores[x.first][x.second]*=nbplay[x.first][x.second];
        scores[x.first][x.second]-=3*toAdd*t;
        nbplay[x.first][x.second]+=3;
        scores[x.first][x.second]/=nbplay[x.first][x.second];
        if(abs(scores[x.first][x.second])>maxi)
            maxi=abs(scores[x.first][x.second]);
    }
    for(auto& x:destrultra){
        scores[x.first][x.second]*=nbplay[x.first][x.second];
        scores[x.first][x.second]-=4*toAdd*t;
        nbplay[x.first][x.second]+=4;
        scores[x.first][x.second]/=nbplay[x.first][x.second];
        if(abs(scores[x.first][x.second])>maxi)
            maxi=abs(scores[x.first][x.second]);
    }
    for(int i = annule.size()-1;i>=0;++i){
        int x=annule[i].first.first;
        int y=annule[i].first.second;
        case_type c = annule[i].second;
        carte[x][y] = c;
    }
///VERIFER QUE 1.4*toAdd GARDE MEME SIGNE
    return 1.4*toAdd;
}
/// Fonction appelée au début de la partie.
void partie_init()
{
    for(int i=1;i<38;++i)
        for(int j=1;j<38;++j)
            carte[i][j] = VIDE;
    MOI=moi();
    ADV=adversaire();
    srand(time(nullptr));
    for(position pos:liste_pulsars()){
        pulsars.emplace(pos,info_pulsar(pos));
        sommets.emplace(pos);
        carte[pos.x][pos.y]=PULSAR;
    }
    for(position pos:ma_base()){
        base[pos]=1;
    }
    for(position pos:base_ennemie()){
        base[pos]=-1;
    }
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    chrono::time_point<chrono::system_clock> start = chrono::system_clock::now();;

    ///initialiser le tour
    for(position pos:hist_debris_deblayes()){
        carte[pos.x][pos.y]=VIDE;
    }
    for(position pos:hist_tuyaux_construits()){
        carte[pos.x][pos.y]=TUYAU;
        potentiel[pos.x][pos.y]=5;
    }
    for(position pos:hist_tuyaux_ameliores()){
        carte[pos.x][pos.y]=SUPER_TUYAU;
    }
    for(position pos:hist_tuyaux_detruits()){
        carte[pos.x][pos.y]=DEBRIS;
        potentiel[pos.x][pos.y]=5;
    }
    for(position pos:hist_points_aspiration_retires()){
        --aspi[pos.x][pos.y];
        potentiel[pos.x][pos.y]-=1;
    }
    for(position pos:hist_points_aspiration_ajoutes()){
        ++aspi[pos.x][pos.y];
        potentiel[pos.x][pos.y]+=1;
    }
    int t=tour_actuel();
    nextTurn(t-1);

    for(int i=1;i<38;++i)
        for(int j=1;j<38;++j)
            nbplay[i][j] = 1;
    nbtotplay=1;
    ///simuler des parties
    while(((chrono::duration<double>)(chrono::system_clock::now() - start)).count()<e){
        pulsarsfake=pulsars;
        plasmasfake=plasmas;
        tuyauxfake=tuyaux;
        graphefake=graphe;
        sommetsfake=sommets;
        play(t,1,0);
        ++nbtotplay;
    }

    ///choisir coup
    set<pair<int,int>> vus;
    int PA=4;
    while(PA>0){
        position pos;
        int i=1,j=1;
        for(int k = 1;k<38;++k)
            for(int l = 1;l<38;++l)
                if(vus.count(make_pair(i,j)) or (abs(scores[i][j])<abs(scores[k][l]) and vus.count(make_pair(k,l))==0))
                    i=k,j=l;
        pos.x=i;
        pos.y=j;
        if(vus.count(make_pair(i,j))){
            break;
        }
        vus.emplace(i,j);
        switch(carte[i][j]){
        case VIDE:
            if(scores[i][j]>=0){
                construire(pos);
                --PA;
            }
            break;
        case TUYAU:
            if(scores[i][j]>=0){
                ameliorer(pos);
                --PA;
            }
            else{
                detruire(pos);
                PA-=3;
            }
            break;
        case SUPER_TUYAU:
            if(scores[i][j]<0){
                detruire(pos);
                PA-=4;
            }
            break;
        case DEBRIS:
            if(scores[i][j]>=0){
                deblayer(pos);
                PA-=2;
            }
            break;
        default:
            break;
        }
    }
    position source, dest;
    for(auto& x:base){
        if(x.second==1){
            if(aspi[x.first.x][x.first.y]!=4 and carte[(x.first.x==0)?1:((x.first.x==38)?37:x.first.x)][(x.first.y==0)?1:((x.first.y==38)?37:x.first.y)]==TUYAU)
                dest = x.first;
            else if(aspi[x.first.x][x.first.y]!=4 and aspi[x.first.x][x.first.y]!=-1)
                source = x.first;
        }
    }
    deplacer_aspiration(source,dest);
    nextTurn(t);
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
  // fonction a completer
}

