{-# LANGUAGE ForeignFunctionInterface #-}
{-# LANGUAGE TypeFamilies #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE UndecidableInstances #-}

{-# OPTIONS_HADDOCK hide #-}

-- This file has been generated, if you wish to
-- modify it in a permanent way, please refer
-- to the script file : gen/generator_haskell.rb

module CApi where

import Data.List (foldl')
import Foreign
import Foreign.C.Types

import Foreign.Marshal.Array

#include "interface_c.hh"
type CBool = CChar

class ApiStorable a where
  type ApiStorableType a
  toStorable :: a -> (ApiStorableType a -> IO b) -> IO b
  unStorable :: ApiStorableType a -> IO a
  type ApiStorableBaseType a
  toStorableBase :: a -> (ApiStorableBaseType a -> IO b) -> IO b
  unStorableBase :: ApiStorableBaseType a -> IO a

instance ApiStorable () where
  type ApiStorableType () = ()
  toStorable () f = f ()
  {-# INLINE toStorable #-}
  unStorable _ = return ()
  {-# INLINE unStorable #-}
  type ApiStorableBaseType () = ()
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Int where
  type ApiStorableType Int = CInt
  toStorable x f = f (fromIntegral x)
  {-# INLINE toStorable #-}
  unStorable = return . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Int = ApiStorableType Int
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Bool where
  type ApiStorableType Bool = CBool
  toStorable x f = f ((\bx -> if bx then 1 else 0) x)
  {-# INLINE toStorable #-}
  unStorable = return . (/= 0)
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Bool = ApiStorableType Bool
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Double where
  type ApiStorableType Double = CDouble
  toStorable x f = f (CDouble x)
  {-# INLINE toStorable #-}
  unStorable = return . (\(CDouble x) -> x)
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Double = ApiStorableType Double
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Erreurs possibles
data Erreur =
    Ok -- ^ L'action a été exécutée avec succès. 
  | Pa_insuffisants -- ^ Vous ne possédez pas assez de points d'action pour cette action. 
  | Aucun_tuyau -- ^ Il n'y a pas de tuyau à la position spécifiée. 
  | Position_invalide -- ^ La position spécifiée est hors de la carte. 
  | Puissance_insuffisante -- ^ Vous ne possédez pas assez de puissance d'asipration sur cette partie de la base. 
  | Deplacement_invalide -- ^ Vous ne pouvez pas déplacer de la puissance d'aspiration d'une case à elle-même. 
  | Pas_dans_base -- ^ Cette case n'appartient pas à votre base. 
  | Amelioration_impossible -- ^ Il y a déjà un Super Tuyau™ sur cette case. 
  | Construction_impossible -- ^ Il est impossible de construire un tuyau à la position indiquée. 
  | Destruction_impossible -- ^ Il n'y a pas de tuyau à la position spécifiée. 
  | Pas_de_pulsar -- ^ Il n'y a pas de pulsar à la position spécifiée. 
  | Pas_de_debris -- ^ Il n'y a pas de débris à la position spécifiée. 
  | Charge_insuffisante -- ^ Vous ne possédez pas assez de plasma pour lancer une destruction. 
  | Limite_aspiration_atteinte -- ^ Vous avez atteint la limite d'aspiration sur cette case. 
  deriving(Show, Eq, Enum)
type CErreur = CInt

instance ApiStorable Erreur where
  type ApiStorableType Erreur = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Erreur = ApiStorableType Erreur
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Types de cases
data Case_type =
    Vide -- ^ Case vide 
  | Tuyau -- ^ Case contenant un tuyau 
  | Super_tuyau -- ^ Case contenant un Super Tuyau™ 
  | Debris -- ^ Case contenant des débris à déblayer 
  | Pulsar -- ^ Case contenant un pulsar 
  | Base -- ^ Case appartenant à une base d'un des joueurs 
  | Interdit -- ^ Case où aucune action n'est possible 
  deriving(Show, Eq, Enum)
type CCase_type = CInt

instance ApiStorable Case_type where
  type ApiStorableType Case_type = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Case_type = ApiStorableType Case_type
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Position sur la carte, donnée par deux coordonnées.
data Position = Position Int Int
  deriving(Show, Eq)
data CPosition = CPosition CInt CInt
instance Storable CPosition where
  sizeOf    _ = (#size position)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    ax <- (#peek position, x) ptr
    ay <- (#peek position, y) ptr
    return $ CPosition ax ay
  {-# INLINE peek #-}
  poke ptr (CPosition ax ay) = do
    (#poke position, x) ptr ax
    (#poke position, y) ptr ay
  {-# INLINE poke #-}
instance ApiStorable Position where
  type ApiStorableType Position = Ptr CPosition
  toStorable (Position ax ay) f = toStorableBase ax $ \ax' ->  toStorableBase ay $ \ay' ->  do
    alloca $ \ptr -> do
      poke ptr $ CPosition ax' ay'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CPosition ax' ay') <- peek ptr
    ax <- unStorableBase ax'
    ay <- unStorableBase ay'
    return $ Position ax ay
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Position = CPosition
  toStorableBase (Position ax ay) f =
    toStorableBase ax $ \ax' ->  toStorableBase ay $ \ay' ->  f (CPosition ax' ay')
  {-# INLINE toStorableBase #-}
  unStorableBase (CPosition ax' ay') = do
    ax <- unStorableBase ax'
    ay <- unStorableBase ay'
    return $ Position ax ay
  {-# INLINE unStorableBase #-}
-- | Représente un pulsar existant.
data Pulsar_info = Pulsar_info {
      periode :: Int -- ^ Période de pulsation du pulsar
  ,   puissance :: Double -- ^ Quantité de plasma émise par chaque pulsation dans chaque direction
  ,   pulsations_restantes :: Int -- ^ Nombre de pulsations restantes
  ,   pulsations_totales :: Int -- ^ Nombre total de pulsations au début de la partie
}
  deriving(Show, Eq)
data CPulsar_info = CPulsar_info {
      cperiode :: CInt -- ^ Période de pulsation du pulsar
  ,   cpuissance :: CDouble -- ^ Quantité de plasma émise par chaque pulsation dans chaque direction
  ,   cpulsations_restantes :: CInt -- ^ Nombre de pulsations restantes
  ,   cpulsations_totales :: CInt -- ^ Nombre total de pulsations au début de la partie
}
instance Storable CPulsar_info where
  sizeOf    _ = (#size pulsar_info)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    aperiode <- (#peek pulsar_info, periode) ptr
    apuissance <- (#peek pulsar_info, puissance) ptr
    apulsations_restantes <- (#peek pulsar_info, pulsations_restantes) ptr
    apulsations_totales <- (#peek pulsar_info, pulsations_totales) ptr
    return $ CPulsar_info aperiode apuissance apulsations_restantes apulsations_totales
  {-# INLINE peek #-}
  poke ptr (CPulsar_info aperiode apuissance apulsations_restantes apulsations_totales) = do
    (#poke pulsar_info, periode) ptr aperiode
    (#poke pulsar_info, puissance) ptr apuissance
    (#poke pulsar_info, pulsations_restantes) ptr apulsations_restantes
    (#poke pulsar_info, pulsations_totales) ptr apulsations_totales
  {-# INLINE poke #-}
instance ApiStorable Pulsar_info where
  type ApiStorableType Pulsar_info = Ptr CPulsar_info
  toStorable (Pulsar_info aperiode apuissance apulsations_restantes apulsations_totales) f = toStorableBase aperiode $ \aperiode' ->  toStorableBase apuissance $ \apuissance' ->  toStorableBase apulsations_restantes $ \apulsations_restantes' ->  toStorableBase apulsations_totales $ \apulsations_totales' ->  do
    alloca $ \ptr -> do
      poke ptr $ CPulsar_info aperiode' apuissance' apulsations_restantes' apulsations_totales'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CPulsar_info aperiode' apuissance' apulsations_restantes' apulsations_totales') <- peek ptr
    aperiode <- unStorableBase aperiode'
    apuissance <- unStorableBase apuissance'
    apulsations_restantes <- unStorableBase apulsations_restantes'
    apulsations_totales <- unStorableBase apulsations_totales'
    return $ Pulsar_info aperiode apuissance apulsations_restantes apulsations_totales
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Pulsar_info = CPulsar_info
  toStorableBase (Pulsar_info aperiode apuissance apulsations_restantes apulsations_totales) f =
    toStorableBase aperiode $ \aperiode' ->  toStorableBase apuissance $ \apuissance' ->  toStorableBase apulsations_restantes $ \apulsations_restantes' ->  toStorableBase apulsations_totales $ \apulsations_totales' ->  f (CPulsar_info aperiode' apuissance' apulsations_restantes' apulsations_totales')
  {-# INLINE toStorableBase #-}
  unStorableBase (CPulsar_info aperiode' apuissance' apulsations_restantes' apulsations_totales') = do
    aperiode <- unStorableBase aperiode'
    apuissance <- unStorableBase apuissance'
    apulsations_restantes <- unStorableBase apulsations_restantes'
    apulsations_totales <- unStorableBase apulsations_totales'
    return $ Pulsar_info aperiode apuissance apulsations_restantes apulsations_totales
  {-# INLINE unStorableBase #-}
data CPosition_array = CPosition_array { cPosition_arrayPtr :: Ptr CPosition, cPosition_arraySize :: CSize }

instance Storable CPosition_array where
  sizeOf    _ = (#size position_array)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    length <- (#peek position_array, length) ptr
    datas <- (#peek position_array, datas) ptr
    return $ CPosition_array datas length
  {-# INLINE peek #-}
  poke ptr (CPosition_array datas length) = do
    (#poke position_array, length) ptr length
    (#poke position_array, datas) ptr datas
  {-# INLINE poke #-}

instance ApiStorable [Position] where
  type ApiStorableType [Position] = Ptr CPosition_array
  toStorable xs f = toStorableBase xs $ \a -> alloca $ \ptr -> do
    poke ptr a
    f ptr
  {-# INLINE toStorable #-}
  unStorable xa = do
    (CPosition_array xa' xl) <- peek xa
    xs <- peekArray (fromIntegral xl) xa'
    mapM unStorableBase xs
  {-# INLINE unStorable #-}
  type ApiStorableBaseType [Position] = CPosition_array

  toStorableBase xs f = do
    let xl = length xs
    allocaArray xl $ \xa ->
      foldl'
        (\acc (i, c) -> toStorableBase c $ \c' -> do
          poke (advancePtr xa i) c'
          acc
        )
        (f $ CPosition_array xa (fromIntegral xl))
        (zip [0..] xs)
  {-# INLINE toStorableBase #-}
  unStorableBase (CPosition_array xa xl) = do
    xs <- peekArray (fromIntegral xl) xa
    mapM unStorableBase xs
  {-# INLINE unStorableBase #-}
-- | Construit un tuyau sur une case donnée.
construire :: Position -> IO Erreur
construire pos = toStorable pos $ \pos' ->  (hs_construire pos') >>= unStorable

foreign import ccall
  hs_construire :: (ApiStorableType Position) ->  IO (ApiStorableType Erreur)
-- | Améliore un tuyau en Super Tuyau™.
ameliorer :: Position -> IO Erreur
ameliorer pos = toStorable pos $ \pos' ->  (hs_ameliorer pos') >>= unStorable

foreign import ccall
  hs_ameliorer :: (ApiStorableType Position) ->  IO (ApiStorableType Erreur)
-- | Détruit un tuyau sur une case donnée.
detruire :: Position -> IO Erreur
detruire pos = toStorable pos $ \pos' ->  (hs_detruire pos') >>= unStorable

foreign import ccall
  hs_detruire :: (ApiStorableType Position) ->  IO (ApiStorableType Erreur)
-- | Déplace une unité de puissance d'aspiration d'une case de votre base vers une autre.
deplacer_aspiration :: Position ->  Position -> IO Erreur
deplacer_aspiration source destination = toStorable source $ \source' ->  toStorable destination $ \destination' ->  (hs_deplacer_aspiration source' destination') >>= unStorable

foreign import ccall
  hs_deplacer_aspiration :: (ApiStorableType Position) -> (ApiStorableType Position) ->  IO (ApiStorableType Erreur)
-- | Déblaye une case de débris.
deblayer :: Position -> IO Erreur
deblayer pos = toStorable pos $ \pos' ->  (hs_deblayer pos') >>= unStorable

foreign import ccall
  hs_deblayer :: (ApiStorableType Position) ->  IO (ApiStorableType Erreur)
-- | Renvoie le type d'une case donnée.
type_case :: Position -> IO Case_type
type_case pos = toStorable pos $ \pos' ->  (hs_type_case pos') >>= unStorable

foreign import ccall
  hs_type_case :: (ApiStorableType Position) ->  IO (ApiStorableType Case_type)
-- | Renvoie la liste de tous les pulsars présents.
liste_pulsars :: IO [Position]
liste_pulsars  =  (hs_liste_pulsars ) >>= unStorable

foreign import ccall
  hs_liste_pulsars ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des cases contenant du plasma.
liste_plasmas :: IO [Position]
liste_plasmas  =  (hs_liste_plasmas ) >>= unStorable

foreign import ccall
  hs_liste_plasmas ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des cases contenant un tuyau ou Super Tuyau™.
liste_tuyaux :: IO [Position]
liste_tuyaux  =  (hs_liste_tuyaux ) >>= unStorable

foreign import ccall
  hs_liste_tuyaux ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des cases contenant un Super Tuyau™.
liste_super_tuyaux :: IO [Position]
liste_super_tuyaux  =  (hs_liste_super_tuyaux ) >>= unStorable

foreign import ccall
  hs_liste_super_tuyaux ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des cases contenant des débris.
liste_debris :: IO [Position]
liste_debris  =  (hs_liste_debris ) >>= unStorable

foreign import ccall
  hs_liste_debris ::  IO (ApiStorableType [Position])
-- | Renvoie vrai si et seulement si la case contient un pulsar.
est_pulsar :: Position -> IO Bool
est_pulsar pos = toStorable pos $ \pos' ->  (hs_est_pulsar pos') >>= unStorable

foreign import ccall
  hs_est_pulsar :: (ApiStorableType Position) ->  IO (ApiStorableType Bool)
-- | Renvoie vrai si et seulement si la case contient un tuyau ou un Super Tuyau™.
est_tuyau :: Position -> IO Bool
est_tuyau pos = toStorable pos $ \pos' ->  (hs_est_tuyau pos') >>= unStorable

foreign import ccall
  hs_est_tuyau :: (ApiStorableType Position) ->  IO (ApiStorableType Bool)
-- | Renvoie vrai si et seulement si la case contient un simple tuyau.
est_simple_tuyau :: Position -> IO Bool
est_simple_tuyau pos = toStorable pos $ \pos' ->  (hs_est_simple_tuyau pos') >>= unStorable

foreign import ccall
  hs_est_simple_tuyau :: (ApiStorableType Position) ->  IO (ApiStorableType Bool)
-- | Renvoie vrai si et seulement si la case contient un Super Tuyau™.
est_super_tuyau :: Position -> IO Bool
est_super_tuyau pos = toStorable pos $ \pos' ->  (hs_est_super_tuyau pos') >>= unStorable

foreign import ccall
  hs_est_super_tuyau :: (ApiStorableType Position) ->  IO (ApiStorableType Bool)
-- | Renvoie vrai si et seulement si la case contient un débris.
est_debris :: Position -> IO Bool
est_debris pos = toStorable pos $ \pos' ->  (hs_est_debris pos') >>= unStorable

foreign import ccall
  hs_est_debris :: (ApiStorableType Position) ->  IO (ApiStorableType Bool)
-- | Renvoie vrai si et seulement s'il est possible de construire sur cette case.
est_libre :: Position -> IO Bool
est_libre pos = toStorable pos $ \pos' ->  (hs_est_libre pos') >>= unStorable

foreign import ccall
  hs_est_libre :: (ApiStorableType Position) ->  IO (ApiStorableType Bool)
-- | Renvoie les informations propres au pulsar à la position donnée.
info_pulsar :: Position -> IO Pulsar_info
info_pulsar pos = toStorable pos $ \pos' ->  (hs_info_pulsar pos') >>= unStorable

foreign import ccall
  hs_info_pulsar :: (ApiStorableType Position) ->  IO (ApiStorableType Pulsar_info)
-- | Renvoie la quantité de plasma sur une case donnée.
charges_presentes :: Position -> IO Double
charges_presentes pos = toStorable pos $ \pos' ->  (hs_charges_presentes pos') >>= unStorable

foreign import ccall
  hs_charges_presentes :: (ApiStorableType Position) ->  IO (ApiStorableType Double)
-- | Renvoie le numéro du joueur ayant dernièrement construit ou amélioré un tuyau sur une case.
constructeur_tuyau :: Position -> IO Int
constructeur_tuyau pos = toStorable pos $ \pos' ->  (hs_constructeur_tuyau pos') >>= unStorable

foreign import ccall
  hs_constructeur_tuyau :: (ApiStorableType Position) ->  IO (ApiStorableType Int)
-- | Renvoie le numéro du propriétaire d'une case de base.
proprietaire_base :: Position -> IO Int
proprietaire_base pos = toStorable pos $ \pos' ->  (hs_proprietaire_base pos') >>= unStorable

foreign import ccall
  hs_proprietaire_base :: (ApiStorableType Position) ->  IO (ApiStorableType Int)
-- | Renvoie la liste des cases composant votre base.
ma_base :: IO [Position]
ma_base  =  (hs_ma_base ) >>= unStorable

foreign import ccall
  hs_ma_base ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des cases composant la base de votre ennemi.
base_ennemie :: IO [Position]
base_ennemie  =  (hs_base_ennemie ) >>= unStorable

foreign import ccall
  hs_base_ennemie ::  IO (ApiStorableType [Position])
-- | Renvoie la puissance d'aspiration d'une case de base donnée. Renvoie -1 si la position n'est pas celle d'une base.
puissance_aspiration :: Position -> IO Int
puissance_aspiration pos = toStorable pos $ \pos' ->  (hs_puissance_aspiration pos') >>= unStorable

foreign import ccall
  hs_puissance_aspiration :: (ApiStorableType Position) ->  IO (ApiStorableType Int)
-- | Renvoie pour une case donnée la liste des cases vers lesquelles le plasma se propagera. Renvoie la liste vide si la case n'est pas une case contenant un tuyau ou si elle n'est reliée à aucune base.
directions_plasma :: Position -> IO [Position]
directions_plasma pos = toStorable pos $ \pos' ->  (hs_directions_plasma pos') >>= unStorable

foreign import ccall
  hs_directions_plasma :: (ApiStorableType Position) ->  IO (ApiStorableType [Position])
-- | Renvoie la valeur du coût de la prochaine modification de vos puissances d'aspiration.
cout_prochaine_modification_aspiration :: IO Int
cout_prochaine_modification_aspiration  =  (hs_cout_prochaine_modification_aspiration ) >>= unStorable

foreign import ccall
  hs_cout_prochaine_modification_aspiration ::  IO (ApiStorableType Int)
-- | Renvoie la liste des tuyaux construits par votre adversaire au dernier tour.
hist_tuyaux_construits :: IO [Position]
hist_tuyaux_construits  =  (hs_hist_tuyaux_construits ) >>= unStorable

foreign import ccall
  hs_hist_tuyaux_construits ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des tuyaux détruits par votre adversaire au dernier tour.
hist_tuyaux_detruits :: IO [Position]
hist_tuyaux_detruits  =  (hs_hist_tuyaux_detruits ) >>= unStorable

foreign import ccall
  hs_hist_tuyaux_detruits ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des tuyaux améliorés par votre adversaire au dernier tour.
hist_tuyaux_ameliores :: IO [Position]
hist_tuyaux_ameliores  =  (hs_hist_tuyaux_ameliores ) >>= unStorable

foreign import ccall
  hs_hist_tuyaux_ameliores ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des débris déblayés par votre adversaire au dernier tour.
hist_debris_deblayes :: IO [Position]
hist_debris_deblayes  =  (hs_hist_debris_deblayes ) >>= unStorable

foreign import ccall
  hs_hist_debris_deblayes ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des cases de base de votre adversaire qui ont reçu un point d'aspiration (une même case peut apparaître plusieurs fois).
hist_points_aspiration_ajoutes :: IO [Position]
hist_points_aspiration_ajoutes  =  (hs_hist_points_aspiration_ajoutes ) >>= unStorable

foreign import ccall
  hs_hist_points_aspiration_ajoutes ::  IO (ApiStorableType [Position])
-- | Renvoie la liste des cases de base de votre adversaire qui ont perdu un point d'aspiration (une même case peut apparaître plusieurs fois).
hist_points_aspiration_retires :: IO [Position]
hist_points_aspiration_retires  =  (hs_hist_points_aspiration_retires ) >>= unStorable

foreign import ccall
  hs_hist_points_aspiration_retires ::  IO (ApiStorableType [Position])
-- | Renvoie votre numéro de joueur.
moi :: IO Int
moi  =  (hs_moi ) >>= unStorable

foreign import ccall
  hs_moi ::  IO (ApiStorableType Int)
-- | Renvoie le numéro de votre adversaire.
adversaire :: IO Int
adversaire  =  (hs_adversaire ) >>= unStorable

foreign import ccall
  hs_adversaire ::  IO (ApiStorableType Int)
-- | Indique votre nombre de points d'actions restants pour ce tour-ci.
points_action :: IO Int
points_action  =  (hs_points_action ) >>= unStorable

foreign import ccall
  hs_points_action ::  IO (ApiStorableType Int)
-- | Renvoie le score du joueur désigné par le numéro ``id_joueur``. Renvoie -1 si ``id_joueur`` est invalide.
score :: Int -> IO Int
score id_joueur = toStorable id_joueur $ \id_joueur' ->  (hs_score id_joueur') >>= unStorable

foreign import ccall
  hs_score :: (ApiStorableType Int) ->  IO (ApiStorableType Int)
-- | Renvoie le numéro du tour actuel.
tour_actuel :: IO Int
tour_actuel  =  (hs_tour_actuel ) >>= unStorable

foreign import ccall
  hs_tour_actuel ::  IO (ApiStorableType Int)
-- | Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
annuler :: IO Bool
annuler  =  (hs_annuler ) >>= unStorable

foreign import ccall
  hs_annuler ::  IO (ApiStorableType Bool)
-- | Affiche le contenu d'une valeur de type erreur
afficher_erreur :: Erreur -> IO ()
afficher_erreur v = toStorable v $ \v' ->  (hs_afficher_erreur v') >>= unStorable

foreign import ccall
  hs_afficher_erreur :: (ApiStorableType Erreur) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type case_type
afficher_case_type :: Case_type -> IO ()
afficher_case_type v = toStorable v $ \v' ->  (hs_afficher_case_type v') >>= unStorable

foreign import ccall
  hs_afficher_case_type :: (ApiStorableType Case_type) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type position
afficher_position :: Position -> IO ()
afficher_position v = toStorable v $ \v' ->  (hs_afficher_position v') >>= unStorable

foreign import ccall
  hs_afficher_position :: (ApiStorableType Position) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type pulsar_info
afficher_pulsar_info :: Pulsar_info -> IO ()
afficher_pulsar_info v = toStorable v $ \v' ->  (hs_afficher_pulsar_info v') >>= unStorable

foreign import ccall
  hs_afficher_pulsar_info :: (ApiStorableType Pulsar_info) ->  IO (ApiStorableType ())
