<?php
/*
 * Taille du terrain (longueur et largeur).
 */
define('TAILLE_TERRAIN', 30);

/*
 * Nombre de tours à jouer avant la fin de la partie.
 */
define('NB_TOURS', 100);

/*
 * Nombre de points de déplacement par tour (avant utilisation du turbo).
 */
define('NB_POINTS_DEPLACEMENT', 6);

/*
 * Nombre de points d'action par tour.
 */
define('NB_POINTS_ACTION', 42);

/*
 * Nombre de points d'action que coûte la capture d'un portail.
 */
define('COUT_CAPTURE', 3);

/*
 * Nombre de points d'action que coûte la création d'un lien.
 */
define('COUT_LIEN', 2);

/*
 * Nombre de points d'action que coûte la neutralisation d'un portail de base.
 */
define('COUT_NEUTRALISATION', 10);

/*
 * Nombre de points d'action supplémentaires que coûte la neutralisation pour chaque bouclier présent.
 */
define('COUT_NEUTRALISATION_BOUCLIER', 5);

/*
 * Nombre de points d'action que coûte la mise en place d'un bouclier sur un portail sans bouclier.
 */
define('COUT_BOUCLIER', 3);

/*
 * Nombre de points d'action que coûte l'utilisation d'un turbo.
 */
define('COUT_TURBO', 6);

/*
 * Nombre maximum de boucliers sur un même portail.
 */
define('MAX_BOUCLIERS', 6);

/*
 * Nombre de points que rapporte la capture d'un portail.
 */
define('POINTS_CAPTURE', 10);

/*
 * Constante de proportionnalité reliant l'aire d'un champ au nombre de points qu'il rapporte par tour.
 */
define('POINTS_CHAMP', 2);

/*
 * Erreurs possibles
 */
define('OK', 0); // L'action a été exécutée avec succès
define('PA_INSUFFISANTS', 1); // Vous ne possédez pas assez de points d'action pour cette action.
define('AUCUN_PORTAIL', 2); // La position spécifiée n'est pas un portail.
define('POSITION_INVALIDE', 3); // La position spécifiée est hors de la carte.
define('POSITION_ELOIGNEE', 4); // La destination est trop éloignée.
define('PORTAIL_AMI', 5); // Le portail vous appartient.
define('PORTAIL_NEUTRE', 6); // Le portail est neutre.
define('PORTAIL_ENNEMI', 7); // Le portail appartient à votre adversaire.
define('LIEN_INTERSECTION', 8); // Le lien croise un lien existant.
define('LIEN_CHAMP', 9); // Le lien se trouve dans un champ existant.
define('LIEN_DEGENERE', 10); // Les deux extrémités du lien coïncident.
define('LIMITE_BOUCLIERS', 11); // Ce portail est équipé du nombre maximal de boucliers.

?>
