public class Action {

	public int type;
	public Position pos;

	public Action(Type type) {
		this.type = getType(type);
	}

	public Action(Type type, Position pos) {
		this.type = getType(type);
		this.pos = pos;
	}

	public int getCost() {
		switch (type) {
		case 0:
			return Interface.COUT_CAPTURE;
		case 1:
			return Interface.COUT_BOUCLIER + Interface.portail_boucliers(pos);
		case 2:
			return Interface.COUT_LIEN;
		case 3:
			return Interface.COUT_NEUTRALISATION
					+ (Interface.portail_boucliers(pos) * Interface.COUT_NEUTRALISATION_BOUCLIER);
		case 4:
			return Interface.COUT_TURBO;
		case 5:
			return 0;
		}
		return 0;
	}

	public Erreur makeAction() {
		switch (type) {
		case 0:
			return Interface.capturer();
		case 1:
			return Interface.ajouter_bouclier();
		case 2:
			return Interface.lier(pos);
		case 3:
			return Interface.neutraliser();
		case 4:
			return Interface.utiliser_turbo();
		case 5:
			return Interface.deplacer(pos);
		}
		return null;
	}

	public static int getType(Type type) {
		switch (type) {
		case capturer:
			return 0;
		case bouclier:
			return 1;
		case lien:
			return 2;
		case neutralisation:
			return 3;
		case turbo:
			return 4;
		case move:
			return 5;
		}
		return -1;
	}

}
