/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithWorkingTreeHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        if (selection.isEmpty()) {
            return null;
        }
        RevCommit commit = (RevCommit)selection.getFirstElement();
        Object input = this.getPage(event).getInputInternal().getSingleFile();
        Repository repository = this.getRepository(event);
        try {
            String dstRevCommit = commit.getId().getName();
            IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            if (input instanceof IFile) {
                IResource[] resources = new IResource[]{(IFile)input};
                CompareUtils.compare(resources, repository, "HEAD", dstRevCommit, true, workBenchPage);
            } else {
                Path location = new Path(((File)input).getAbsolutePath());
                CompareUtils.compare((IPath)location, repository, "HEAD", dstRevCommit, true, workBenchPage);
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        int size = this.getSelection(page).size();
        if (size != 1) {
            return false;
        }
        return page.getInputInternal().isSingleFile();
    }
}

