/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.iproduct.IAboutInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.EditorUtilities;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.validation.TextValidator;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.FileExtensionsFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AboutSection
extends PDESection {
    private FormEntry fImageEntry;
    private FormEntry fTextEntry;
    private TextValidator fImageEntryValidator;

    public AboutSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 70;
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.AboutSection_title);
        section.setDescription(PDEUIMessages.AboutSection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        client.setLayoutData((Object)new GridData(1808));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fImageEntry = new FormEntry(client, toolkit, PDEUIMessages.AboutSection_image, PDEUIMessages.AboutSection_browse, this.isEditable());
        this.fImageEntry.setEditable(this.isEditable());
        this.fImageEntryValidator = new TextValidator(this.getManagedForm(), this.fImageEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return AboutSection.this.validateImageEntry();
            }
        };
        this.fImageEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                AboutSection.this.getAboutInfo().setImagePath(entry.getValue());
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                AboutSection.this.handleBrowse();
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                EditorUtilities.openImage(AboutSection.this.fImageEntry.getValue(), AboutSection.this.getProduct().getDefiningPluginId());
            }
        });
        int style = 578;
        this.fTextEntry = new FormEntry(client, toolkit, PDEUIMessages.AboutSection_text, style);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.horizontalIndent = 3;
        this.fTextEntry.getText().setLayoutData((Object)data);
        data = new GridData(1, 1, false, false);
        this.fTextEntry.getLabel().setLayoutData((Object)data);
        this.fTextEntry.setEditable(this.isEditable());
        this.fTextEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                AboutSection.this.getAboutInfo().setText(entry.getValue());
            }
        });
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private boolean validateImageEntry() {
        return EditorUtilities.imageEntrySizeDoesNotExceed(this.fImageEntryValidator, this.fImageEntry, this.getProduct(), 500, 330, 250, 330);
    }

    private void handleBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSection().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.AboutSection_imgTitle);
        dialog.setMessage(PDEUIMessages.AboutSection_imgMessage);
        FileExtensionsFilter filter = new FileExtensionsFilter();
        filter.addFileExtension("gif");
        filter.addFileExtension("png");
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            this.fImageEntry.setValue(file.getFullPath().toString());
        }
    }

    public void refresh() {
        this.fImageEntry.setValue(this.getAboutInfo().getImagePath(), true);
        this.fTextEntry.setValue(this.getAboutInfo().getText(), true);
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fImageEntry.commit();
        this.fTextEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fImageEntry.cancelEdit();
        this.fTextEntry.cancelEdit();
        super.cancelEdit();
    }

    private IAboutInfo getAboutInfo() {
        IAboutInfo info = this.getProduct().getAboutInfo();
        if (info == null) {
            info = this.getModel().getFactory().createAboutInfo();
            this.getProduct().setAboutInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }
}

