/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsComparator;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsContentProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsLabelProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;

public class EmbeddedBreakpointsViewer {
    private IStructuredSelection fSelection = null;
    private BreakpointsContentProvider fProvider = null;
    private Tree fTree = null;
    private BreakpointsViewer fViewer = null;
    private ICheckStateListener fCheckListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            EmbeddedBreakpointsViewer.this.updateCheckedState(event.getElement(), event.getChecked());
        }
    };

    public EmbeddedBreakpointsViewer(Composite parent, Object input, IStructuredSelection selection) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)input);
        this.createControl(parent, input, selection);
    }

    private void createControl(Composite parent, Object input, IStructuredSelection selection) {
        this.fSelection = selection;
        if (this.fSelection == null) {
            IViewPart fViewpart = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
            this.fSelection = fViewpart != null ? (IStructuredSelection)fViewpart.getViewSite().getSelectionProvider().getSelection() : new StructuredSelection();
        }
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 1808, 0, 0);
        this.fTree = new Tree(composite, 2850);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.fTree.setLayoutData((Object)gd);
        this.fProvider = new BreakpointsContentProvider();
        BreakpointsView view = (BreakpointsView)DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
        this.fViewer = new BreakpointsViewer(this.fTree);
        BreakpointsLabelProvider labelprovider = new BreakpointsLabelProvider();
        if (view != null) {
            HashMap<String, Object> map = null;
            IDebugModelPresentation current = (IDebugModelPresentation)view.getAdapter(IDebugModelPresentation.class);
            if (current instanceof DelegatingModelPresentation) {
                map = ((DelegatingModelPresentation)current).getAttributes();
            }
            if (map != null) {
                Object key2 = null;
                IDebugModelPresentation newpres = labelprovider.getPresentation();
                for (Object key2 : map.keySet()) {
                    newpres.setAttribute(key2, map.get(key2));
                }
            }
        }
        this.fViewer.setComparator(new BreakpointsComparator());
        this.fViewer.setLabelProvider((IBaseLabelProvider)labelprovider);
        this.fViewer.addCheckStateListener(this.fCheckListener);
        IBreakpointOrganizer[] orgs = null;
        if (view != null) {
            orgs = view.getBreakpointOrganizers();
        }
        this.fViewer.setContentProvider((IContentProvider)this.fProvider);
        this.fViewer.setInput(input);
        this.fProvider.setOrganizers(orgs);
        this.initViewerState();
    }

    private void initViewerState() {
        Object[] items = this.fSelection.toArray();
        this.fViewer.setGrayedElements(new Object[0]);
        this.fViewer.setCheckedElements(new Object[0]);
        ArrayList<IBreakpoint> list = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < items.length) {
            Object item = items[i];
            IBreakpoint breakpoint = (IBreakpoint)DebugPlugin.getAdapter((Object)item, IBreakpoint.class);
            if (breakpoint != null) {
                list.add(breakpoint);
            } else if (item instanceof IBreakpointContainer) {
                this.getBreakpointsFromContainers((IBreakpointContainer)item, list);
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            this.updateCheckedState(list.get(i), true);
            ++i;
        }
    }

    private void getBreakpointsFromContainers(IBreakpointContainer container, ArrayList<IBreakpoint> list) {
        IBreakpoint[] bps = container.getBreakpoints();
        list.ensureCapacity(list.size() + bps.length);
        int j = 0;
        while (j < bps.length) {
            list.add(bps[j]);
            ++j;
        }
    }

    public IStructuredSelection getCheckedElements() {
        Object[] list = this.fViewer.getCheckedElements();
        Vector<Object> selected = new Vector<Object>();
        int i = 0;
        while (i < list.length) {
            if (!selected.contains(list[i])) {
                selected.addElement(list[i]);
            }
            ++i;
        }
        return new StructuredSelection(selected);
    }

    public BreakpointsViewer getViewer() {
        return this.fViewer;
    }

    private Widget[] searchItems(Object element) {
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] items = this.fTree.getItems();
        int i = 0;
        while (i < items.length) {
            this.findAllOccurrences(items[i], element, list);
            ++i;
        }
        return list.toArray(new Widget[0]);
    }

    private void findAllOccurrences(TreeItem item, Object element, ArrayList<TreeItem> list) {
        if (element.equals(item.getData())) {
            list.add(item);
        }
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.findAllOccurrences(items[i], element, list);
            ++i;
        }
    }

    private void updateCheckedState(Object obj, boolean enable) {
        block3: {
            block2: {
                IBreakpoint breakpoint = (IBreakpoint)DebugPlugin.getAdapter((Object)obj, IBreakpoint.class);
                if (breakpoint == null) break block2;
                Widget[] list = this.searchItems(obj);
                TreeItem item = null;
                int i = 0;
                while (i < list.length) {
                    item = (TreeItem)list[i];
                    item.setChecked(enable);
                    this.refreshParents(item);
                    ++i;
                }
                break block3;
            }
            if (!(obj instanceof BreakpointContainer)) break block3;
            ArrayList<IBreakpoint> bps = new ArrayList<IBreakpoint>();
            this.getBreakpointsFromContainers((BreakpointContainer)obj, bps);
            int j = 0;
            while (j < bps.size()) {
                this.updateCheckedState(bps.get(j), enable);
                ++j;
            }
        }
    }

    private void refreshParents(TreeItem item) {
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            int checked = this.getNumberChildrenChecked(parent);
            if (checked == 0) {
                parent.setGrayed(false);
                parent.setChecked(false);
            } else if (checked == parent.getItemCount()) {
                if (this.getNumberChildrenGrayed(parent) > 0) {
                    parent.setGrayed(true);
                } else {
                    parent.setGrayed(false);
                }
                parent.setChecked(true);
            } else {
                parent.setGrayed(true);
                parent.setChecked(true);
            }
            parent = parent.getParentItem();
        }
    }

    private int getNumberChildrenGrayed(TreeItem parent) {
        TreeItem[] children = parent.getItems();
        int count = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i].getGrayed()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private int getNumberChildrenChecked(TreeItem parent) {
        TreeItem[] children = parent.getItems();
        int count = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i].getChecked()) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

