/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.DiffStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;

public class Diff
extends Command {
    public static final Command.LocalOption UNIFIED_FORMAT = new Command.LocalOption("-u");
    public static final Command.LocalOption CONTEXT_FORMAT = new Command.LocalOption("-c");
    public static final Command.LocalOption INCLUDE_NEWFILES = new Command.LocalOption("-N");
    public static final Command.LocalOption BRIEF = new Command.LocalOption("--brief");

    protected Diff() {
    }

    protected String getRequestId() {
        return "diff";
    }

    protected IStatus doExecute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
        try {
            IStatus status = super.doExecute(session, globalOptions, localOptions, arguments, listener, monitor);
            if (status.getCode() == -10 && status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                int i = 0;
                while (i < children.length) {
                    IStatus child = children[i];
                    if (child.getMessage().indexOf("[diff aborted]") != -1) {
                        throw new CVSServerException(status);
                    }
                    ++i;
                }
            }
            return status;
        }
        catch (CVSServerException e) {
            if (e.containsErrors()) {
                throw e;
            }
            return e.getStatus();
        }
    }

    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        this.checkResourcesManaged(session, resources);
        DiffStructureVisitor visitor = new DiffStructureVisitor(session, localOptions);
        visitor.visit(session, resources, monitor);
        return resources;
    }

    protected String getServerErrorMessage() {
        return CVSMessages.Diff_serverError;
    }
}

