/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiAccess;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;

public class CompositeApiDescription
implements IApiDescription {
    private IApiDescription[] fDescriptions;

    public CompositeApiDescription(IApiDescription[] descriptions) {
        this.fDescriptions = descriptions;
    }

    @Override
    public void accept(ApiDescriptionVisitor visitor, IProgressMonitor monitor) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            this.fDescriptions[i].accept(visitor, monitor);
            ++i;
        }
    }

    @Override
    public boolean accept(ApiDescriptionVisitor visitor, IElementDescriptor element, IProgressMonitor monitor) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            if (this.fDescriptions[i].accept(visitor, element, monitor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public IApiAnnotations resolveAnnotations(IElementDescriptor element) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            IApiAnnotations ann = this.fDescriptions[i].resolveAnnotations(element);
            if (ann != null) {
                return ann;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IStatus setRestrictions(IElementDescriptor element, int restrictions) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            IStatus status = this.fDescriptions[i].setRestrictions(element, restrictions);
            if (status.isOK() || i == this.fDescriptions.length - 1) {
                return status;
            }
            ++i;
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public IStatus setAddedProfile(IElementDescriptor element, int addedProfile) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setRemovedProfile(IElementDescriptor element, int removedProfile) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setSuperclass(IElementDescriptor element, String superclass) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setSuperinterfaces(IElementDescriptor element, String superinterfaces) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setInterface(IElementDescriptor element, boolean interfaceFlag) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setVisibility(IElementDescriptor element, int visibility) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            IStatus status = this.fDescriptions[i].setVisibility(element, visibility);
            if (status.isOK() || i == this.fDescriptions.length - 1) {
                return status;
            }
            ++i;
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public void setAccessLevel(IElementDescriptor element, IPackageDescriptor pelement, int access) {
    }

    @Override
    public IApiAccess resolveAccessLevel(IElementDescriptor element, IPackageDescriptor pelement) {
        IApiAccess access = null;
        int i = 0;
        while (i < this.fDescriptions.length) {
            access = this.fDescriptions[i].resolveAccessLevel(element, pelement);
            if (access != null) {
                return access;
            }
            ++i;
        }
        return null;
    }
}

