/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class LazyStackRenderer
extends SWTPartRenderer {
    private EventHandler lazyLoader = new EventHandler(){

        public void handleEvent(Event event) {
            Object element = event.getProperty("ChangedElement");
            if (!(element instanceof MGenericStack)) {
                return;
            }
            MGenericStack stack = (MGenericStack)element;
            if (stack.getRenderer() != LazyStackRenderer.this) {
                return;
            }
            LazyStackRenderer lsr = (LazyStackRenderer)((Object)stack.getRenderer());
            MUIElement oldSel = (MUIElement)event.getProperty("OldValue");
            if (oldSel != null) {
                LazyStackRenderer.this.hideElementRecursive(oldSel);
            }
            if (stack.getSelectedElement() != null) {
                lsr.showTab(stack.getSelectedElement());
            }
        }
    };

    public void init(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.lazyLoader);
    }

    public void contextDisposed(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
    }

    public void postProcess(MUIElement element) {
        if (!(element instanceof MPerspectiveStack || element instanceof MGenericStack && !this.isMinimizedStack(element))) {
            return;
        }
        MGenericStack stack = (MGenericStack)element;
        MUIElement selPart = stack.getSelectedElement();
        if (selPart != null) {
            this.showTab(selPart);
        } else if (stack.getChildren().size() > 0) {
            for (MUIElement kid : stack.getChildren()) {
                if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                stack.setSelectedElement(kid);
                break;
            }
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class.getName());
        for (MUIElement element : me.getChildren()) {
            MPlaceholder ph;
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            boolean lazy = true;
            if (element instanceof MPlaceholder && (ph = (MPlaceholder)element).getRef() instanceof MPart && ph.getRef().getWidget() != null) {
                lazy = false;
            }
            if (lazy) {
                this.createTab(me, element);
                continue;
            }
            renderer.createGui(element);
        }
    }

    protected void createTab(MElementContainer<MUIElement> me, MUIElement part) {
    }

    protected void showTab(MUIElement element) {
        MUIElement curSel = element.getParent().getSelectedElement();
        if (curSel != null) {
            this.showElementRecursive(curSel);
        }
    }

    private void hideElementRecursive(MUIElement element) {
        block7: {
            block8: {
                MGenericStack container;
                block6: {
                    if (element == null || element.getWidget() == null) {
                        return;
                    }
                    if (element instanceof MPlaceholder) {
                        MPlaceholder ph = (MPlaceholder)element;
                        element = ph.getRef();
                    }
                    if (element instanceof MWindow && element.getWidget() != null) {
                        element.setVisible(false);
                    }
                    if (!(element instanceof MGenericStack)) break block6;
                    container = (MGenericStack)element;
                    MUIElement curSel = container.getSelectedElement();
                    this.hideElementRecursive(curSel);
                    break block7;
                }
                if (!(element instanceof MElementContainer)) break block7;
                container = (MElementContainer)element;
                for (MUIElement childElement : container.getChildren()) {
                    this.hideElementRecursive(childElement);
                }
                if (!(element instanceof MWindow)) break block8;
                for (MWindow w : ((MWindow)element).getWindows()) {
                    this.hideElementRecursive((MUIElement)w);
                }
                break block7;
            }
            if (!(element instanceof MPerspective)) break block7;
            for (MWindow w : ((MPerspective)element).getWindows()) {
                this.hideElementRecursive((MUIElement)w);
            }
        }
    }

    private void showElementRecursive(MUIElement element) {
        IEclipseContext context;
        if (!element.isToBeRendered()) {
            return;
        }
        if (element instanceof MPartStack && element.getRenderer() instanceof StackRenderer) {
            MPartStack stackModel = (MPartStack)element;
            StackRenderer sr = (StackRenderer)((Object)element.getRenderer());
            CTabFolder ctf = (CTabFolder)element.getWidget();
            MUIElement curSel = stackModel.getSelectedElement();
            MPart part = (MPart)(curSel instanceof MPlaceholder ? ((MPlaceholder)curSel).getRef() : curSel);
            if (curSel instanceof MPlaceholder) {
                part.setCurSharedRef((MPlaceholder)curSel);
            }
            sr.adjustTopRight(ctf);
        }
        if (element instanceof MPlaceholder && element.getWidget() != null) {
            MPlaceholder ph = (MPlaceholder)element;
            MUIElement ref = ph.getRef();
            ref.setCurSharedRef(ph);
            Composite phComp = (Composite)ph.getWidget();
            Control refCtrl = (Control)ph.getRef().getWidget();
            refCtrl.setParent(phComp);
            element = ref;
        }
        if (element instanceof MContext && (context = ((MContext)element).getContext()) != null) {
            IEclipseContext newParentContext = this.modelService.getContainingContext(element);
            if (context.getParent() != newParentContext) {
                context.setParent(newParentContext);
            }
        }
        Shell layoutShellLater = null;
        if (element instanceof MWindow && element.getWidget() != null) {
            int visCount = 0;
            for (MUIElement kid : ((MWindow)element).getChildren()) {
                if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                ++visCount;
            }
            if (visCount > 0) {
                element.setVisible(true);
                Object widget = element.getWidget();
                if (widget instanceof Shell) {
                    Shell shell;
                    layoutShellLater = shell = (Shell)widget;
                }
            }
        }
        if (element instanceof MGenericStack) {
            MGenericStack container = (MGenericStack)element;
            MUIElement curSel = container.getSelectedElement();
            if (curSel == null && container.getChildren().size() > 0) {
                curSel = (MUIElement)container.getChildren().get(0);
            }
            if (curSel != null) {
                this.showElementRecursive(curSel);
            }
        } else if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            ArrayList kids = new ArrayList(container.getChildren());
            for (MUIElement childElement : kids) {
                this.showElementRecursive(childElement);
            }
            if (element instanceof MWindow) {
                for (MWindow w : ((MWindow)element).getWindows()) {
                    this.showElementRecursive((MUIElement)w);
                }
            } else if (element instanceof MPerspective) {
                for (MWindow w : ((MPerspective)element).getWindows()) {
                    this.showElementRecursive((MUIElement)w);
                }
            }
        }
        if (layoutShellLater != null) {
            layoutShellLater.layout(true, true);
        }
    }

    private boolean isMinimizedStack(MUIElement stack) {
        return stack.getTags().contains("Minimized") && !stack.getTags().contains("active");
    }
}

