/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;

public class MoveResourceAction
extends CopyResourceAction {
    public static final String ID = "org.eclipse.ui.MoveResourceAction";
    protected List destinations;

    public MoveResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.MoveResourceAction_text);
        this.initAction();
    }

    public MoveResourceAction(IShellProvider provider) {
        super(provider, IDEWorkbenchMessages.MoveResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.MoveResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.move_resource_action_context");
    }

    @Override
    protected CopyFilesAndFoldersOperation createOperation() {
        return new MoveFilesAndFoldersOperation(this.getShell());
    }

    protected List getDestinations() {
        return this.destinations;
    }

    @Override
    protected IResource[] getResources(List resourceList) {
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), IDEWorkbenchMessages.MoveResourceAction_title, IDEWorkbenchMessages.MoveResourceAction_checkMoveMessage);
        return checker.checkReadOnlyResources(super.getResources(resourceList));
    }

    @Override
    protected void runOperation(IResource[] resources, IContainer destination) {
        this.destinations = new ArrayList();
        IResource[] copiedResources = this.operation.copyResources(resources, destination);
        int i = 0;
        while (i < copiedResources.length) {
            this.destinations.add(destination.getFullPath().append(copiedResources[i].getName()));
            ++i;
        }
    }

    @Override
    public void run() {
        if (LTKLauncher.openMoveWizard(this.getStructuredSelection())) {
            return;
        }
        super.run();
    }
}

