/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;

public class ProposalInfo {
    private boolean fJavadocResolved = false;
    private String fJavadoc = null;
    protected IJavaElement fElement;

    public ProposalInfo(IMember member) {
        this.fElement = member;
    }

    protected ProposalInfo() {
        this.fElement = null;
    }

    public IJavaElement getJavaElement() throws JavaModelException {
        return this.fElement;
    }

    public final String getInfo(IProgressMonitor monitor) {
        if (!this.fJavadocResolved) {
            this.fJavadocResolved = true;
            this.fJavadoc = this.computeInfo(monitor);
        }
        return this.fJavadoc;
    }

    private String computeInfo(IProgressMonitor monitor) {
        try {
            IJavaElement javaElement = this.getJavaElement();
            return this.extractJavadoc(javaElement);
        }
        catch (CoreException e) {
            JavaDocLocations.handleFailedJavadocFetch(e);
            return null;
        }
    }

    private String extractJavadoc(IJavaElement element) throws CoreException {
        if (element instanceof IMember) {
            return JavadocContentAccess2.getHTMLContent((IMember)element, true);
        }
        if (element instanceof IPackageDeclaration) {
            return JavadocContentAccess2.getHTMLContent((IPackageDeclaration)element);
        }
        if (element instanceof IPackageFragment) {
            return JavadocContentAccess2.getHTMLContent((IPackageFragment)element);
        }
        return null;
    }
}

