/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringScopeFactory {
    private static void addReferencingProjects(IJavaProject focus, Set<IJavaProject> projects) throws JavaModelException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IClasspathEntry entry;
            IJavaProject candidate = JavaCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addReferencingProjects(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static void addRelatedReferencing(IJavaProject focus, Set<IJavaProject> projects) throws CoreException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IClasspathEntry entry;
            IJavaProject candidate = JavaCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static void addRelatedReferenced(IJavaProject focus, Set<IJavaProject> projects) throws CoreException {
        IProject[] referencedProjects = focus.getProject().getReferencedProjects();
        int i = 0;
        while (i < referencedProjects.length) {
            IClasspathEntry entry;
            IJavaProject candidate = JavaCore.create((IProject)referencedProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(focus, candidate)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                }
            }
            ++i;
        }
    }

    public static IJavaSearchScope create(IJavaElement javaElement) throws JavaModelException {
        return RefactoringScopeFactory.create(javaElement, true, true);
    }

    public static IJavaSearchScope create(IJavaElement javaElement, boolean considerVisibility) throws JavaModelException {
        return RefactoringScopeFactory.create(javaElement, considerVisibility, true);
    }

    public static IJavaSearchScope create(IJavaElement javaElement, boolean considerVisibility, boolean sourceReferencesOnly) throws JavaModelException {
        IMember member;
        if (considerVisibility & javaElement instanceof IMember && JdtFlags.isPrivate(member = (IMember)javaElement)) {
            if (member.getCompilationUnit() != null) {
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member.getCompilationUnit()});
            }
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member});
        }
        IJavaProject javaProject = javaElement.getJavaProject();
        return SearchEngine.createJavaSearchScope((IJavaElement[])RefactoringScopeFactory.getAllScopeElements(javaProject, sourceReferencesOnly), (boolean)false);
    }

    public static IJavaSearchScope create(IMember[] members) throws JavaModelException {
        return RefactoringScopeFactory.create(members, true);
    }

    public static IJavaSearchScope create(IMember[] members, boolean sourceReferencesOnly) throws JavaModelException {
        Assert.isTrue((members != null && members.length > 0 ? 1 : 0) != 0);
        IMember candidate = members[0];
        int visibility = RefactoringScopeFactory.getVisibility(candidate);
        int i = 1;
        while (i < members.length) {
            int mv = RefactoringScopeFactory.getVisibility(members[i]);
            if (mv > visibility) {
                visibility = mv;
                candidate = members[i];
            }
            ++i;
        }
        return RefactoringScopeFactory.create((IJavaElement)candidate, true, sourceReferencesOnly);
    }

    public static IJavaSearchScope createReferencedScope(IJavaElement[] javaElements) {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        int i = 0;
        while (i < javaElements.length) {
            projects.add(javaElements[i].getJavaProject());
            ++i;
        }
        IJavaProject[] prj = projects.toArray(new IJavaProject[projects.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])prj, (boolean)true);
    }

    public static IJavaSearchScope createReferencedScope(IJavaElement[] javaElements, int includeMask) {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        int i = 0;
        while (i < javaElements.length) {
            projects.add(javaElements[i].getJavaProject());
            ++i;
        }
        IJavaProject[] prj = projects.toArray(new IJavaProject[projects.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])prj, (int)includeMask);
    }

    public static IJavaSearchScope createRelatedProjectsScope(IJavaProject project, int includeMask) throws CoreException {
        IJavaProject[] projects = RefactoringScopeFactory.getRelatedProjects(project);
        return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)includeMask);
    }

    private static IPackageFragmentRoot[] getAllScopeElements(IJavaProject project, boolean onlySourceRoots) throws JavaModelException {
        Collection<IJavaProject> referencingProjects = RefactoringScopeFactory.getReferencingProjects(project);
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        for (IJavaProject javaProject : referencingProjects) {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (!onlySourceRoots || root.getKind() == 1) {
                    result.add(root);
                }
                ++i;
            }
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private static IClasspathEntry getReferencingClassPathEntry(IJavaProject referencingProject, IJavaProject referencedProject) throws JavaModelException {
        IClasspathEntry result = null;
        IPath path = referencedProject.getProject().getFullPath();
        IClasspathEntry[] classpath = referencingProject.getResolvedClasspath(true);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 2 && path.equals((Object)entry.getPath())) {
                if (entry.isExported()) {
                    return entry;
                }
                result = entry;
            }
            ++i;
        }
        return result;
    }

    private static IJavaProject[] getRelatedProjects(IJavaProject focus) throws CoreException {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        RefactoringScopeFactory.addRelatedReferencing(focus, projects);
        RefactoringScopeFactory.addRelatedReferenced(focus, projects);
        projects.add(focus);
        return projects.toArray(new IJavaProject[projects.size()]);
    }

    private static Collection<IJavaProject> getReferencingProjects(IJavaProject focus) throws JavaModelException {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        RefactoringScopeFactory.addReferencingProjects(focus, projects);
        projects.add(focus);
        return projects;
    }

    private static int getVisibility(IMember member) throws JavaModelException {
        if (JdtFlags.isPrivate(member)) {
            return 0;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 1;
        }
        if (JdtFlags.isProtected(member)) {
            return 2;
        }
        return 4;
    }

    private RefactoringScopeFactory() {
    }
}

