/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UseMetadata
implements IMetadata {
    public static final String RUNATDATE = "runatdate";
    public static final String FLAGS = "flags";
    public static final String BASELINELOCATION = "baselinelocation";
    public static final String REPORTLOCATION = "reportlocation";
    public static final String SCOPEPATTERN = "scopepattern";
    public static final String REFERENCEPATTERN = "referencepattern";
    public static final String APIPATTERNS = "apipatterns";
    public static final String INTERNALPATTERNS = "internalpatterns";
    public static final String ARCHIVEPATTERNS = "archivepatterns";
    public static final String PATTERN = "pattern";
    public static final String VALUE = "value";
    public static final String METADATA = "metadata";
    public static final String DESCRIPTION = "description";
    int searchflags = 0;
    String[] apipatterns = null;
    String[] intpatterns = null;
    String[] archivepatterns = null;
    String baselinelocation = null;
    String reportlocation = null;
    String scopepattern = null;
    String refpattern = null;
    String runatdate = null;
    String description = null;

    public UseMetadata() {
    }

    public UseMetadata(int searchflags, String scopepattern, String refpattern, String baselinelocation, String reportlocation, String[] apipatterns, String[] internalpatterns, String[] archivepatterns, String runatdate, String description) {
        this.searchflags = searchflags;
        this.scopepattern = scopepattern;
        this.refpattern = refpattern;
        this.baselinelocation = baselinelocation;
        this.reportlocation = reportlocation;
        this.apipatterns = apipatterns;
        this.intpatterns = internalpatterns;
        this.archivepatterns = archivepatterns;
        this.runatdate = runatdate;
        this.description = description;
    }

    @Override
    public void serializeToFile(File file) throws IOException, CoreException {
        BufferedWriter writer = null;
        try {
            int i;
            Document doc = Util.newDocument();
            Element root = doc.createElement(METADATA);
            doc.appendChild(root);
            Element child = doc.createElement(FLAGS);
            root.appendChild(child);
            child.setAttribute(VALUE, Integer.toString(this.searchflags));
            child = doc.createElement(RUNATDATE);
            root.appendChild(child);
            child.setAttribute(VALUE, this.runatdate);
            child = doc.createElement(DESCRIPTION);
            root.appendChild(child);
            child.setAttribute(VALUE, this.description);
            child = doc.createElement(BASELINELOCATION);
            root.appendChild(child);
            child.setAttribute(VALUE, this.baselinelocation);
            child = doc.createElement(REPORTLOCATION);
            root.appendChild(child);
            child.setAttribute(VALUE, this.reportlocation);
            child = doc.createElement(SCOPEPATTERN);
            root.appendChild(child);
            child.setAttribute(VALUE, this.scopepattern);
            child = doc.createElement(REFERENCEPATTERN);
            root.appendChild(child);
            child.setAttribute(VALUE, this.refpattern);
            child = doc.createElement(APIPATTERNS);
            root.appendChild(child);
            Element sub = null;
            if (this.apipatterns != null) {
                i = 0;
                while (i < this.apipatterns.length) {
                    sub = doc.createElement(PATTERN);
                    child.appendChild(sub);
                    sub.setAttribute(VALUE, this.apipatterns[i]);
                    ++i;
                }
            }
            child = doc.createElement(INTERNALPATTERNS);
            root.appendChild(child);
            if (this.intpatterns != null) {
                i = 0;
                while (i < this.intpatterns.length) {
                    sub = doc.createElement(PATTERN);
                    child.appendChild(sub);
                    sub.setAttribute(VALUE, this.intpatterns[i]);
                    ++i;
                }
            }
            child = doc.createElement(ARCHIVEPATTERNS);
            root.appendChild(child);
            if (this.archivepatterns != null) {
                i = 0;
                while (i < this.archivepatterns.length) {
                    sub = doc.createElement(PATTERN);
                    child.appendChild(sub);
                    sub.setAttribute(VALUE, this.archivepatterns[i]);
                    ++i;
                }
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            writer.write(Util.serializeDocument(doc));
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public boolean includesAPI() {
        return (this.searchflags & 1) != 0;
    }

    public boolean includesInternal() {
        return (this.searchflags & 2) != 0;
    }

    public boolean includesIllegalUse() {
        return (this.searchflags & 4) != 0;
    }

    public void setRunAtDate(String date) {
        this.runatdate = date;
    }

    public String getRunAtDate() {
        return this.runatdate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSearchflags(int flags) {
        this.searchflags = flags;
    }

    public String[] getApiPatterns() {
        return this.apipatterns;
    }

    public void setApiPatterns(String[] patterns) {
        this.apipatterns = patterns;
    }

    public String[] getInternalPatterns() {
        return this.intpatterns;
    }

    public void setInternalPatterns(String[] patterns) {
        this.intpatterns = patterns;
    }

    public String[] getArchivePatterns() {
        return this.archivepatterns;
    }

    public void setArchivePatterns(String[] patterns) {
        this.archivepatterns = patterns;
    }

    public String getBaselineLocation() {
        return this.baselinelocation;
    }

    public void setBaselineLocation(String location) {
        this.baselinelocation = location;
    }

    public String getReportLocation() {
        return this.reportlocation;
    }

    public void setReportLocation(String location) {
        this.reportlocation = location;
    }

    public void setReferencePattern(String pattern) {
        this.refpattern = pattern;
    }

    public String getReferencePattern() {
        return this.refpattern;
    }

    public void setScopePattern(String pattern) {
        this.scopepattern = pattern;
    }

    public String getScopePattern() {
        return this.scopepattern;
    }
}

