/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IDescriptionProvider;

public final class NavigatorContentServiceDescriptionProvider
implements IDescriptionProvider {
    private final NavigatorContentService contentService;

    public NavigatorContentServiceDescriptionProvider(NavigatorContentService aContentService) {
        Assert.isNotNull((Object)aContentService);
        this.contentService = aContentService;
    }

    public String getDescription(Object anElement) {
        Object target;
        if (anElement instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)anElement;
            if (structuredSelection.size() > 1) {
                return this.getDefaultStatusBarMessage(structuredSelection.size());
            }
            target = structuredSelection.getFirstElement();
        } else {
            target = anElement;
        }
        String message = null;
        ILabelProvider[] providers = this.contentService.findRelevantLabelProviders(target);
        if (providers.length == 0) {
            return this.getDefaultStatusBarMessage(0);
        }
        int i = 0;
        while (i < providers.length && (message == null || message.length() == 0)) {
            if (providers[i] instanceof ICommonLabelProvider) {
                message = ((ICommonLabelProvider)providers[i]).getDescription(target);
            }
            ++i;
        }
        message = message != null ? message : this.getDefaultStatusBarMessage(1);
        return message;
    }

    protected final String getDefaultStatusBarMessage(int aSize) {
        return NLS.bind((String)(aSize != 1 ? CommonNavigatorMessages.Navigator_statusLineMultiSelect : CommonNavigatorMessages.Navigator_statusLineSingleSelect), (Object[])new Object[]{new Integer(aSize)});
    }
}

