/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.menus.CommandContributionItem;

public class CoolBarToTrimManager
extends ContributionManager
implements ICoolBarManager2 {
    private static final String TOOLBAR_SEPARATOR = "toolbarSeparator";
    private static final String MAIN_TOOLBAR_ID = "org.eclipse.ui.main.toolbar";
    private static final String OBJECT = "coolbar.object";
    private static final String PREV_CHILD_VISIBLE = "prevChildVisible";
    private MTrimBar topTrim;
    private List<MTrimElement> workbenchTrimElements;
    private IRendererFactory rendererFactory;
    private ToolBarManagerRenderer renderer;
    private MApplication application;
    private MTrimmedWindow window;
    private IContributionManagerOverrides toolbarOverrides;
    private boolean trimBarsAdded = false;
    private EModelService modelService;

    public CoolBarToTrimManager(MApplication app, MTrimmedWindow window, List<MTrimElement> workbenchTrimElements, IRendererFactory rf) {
        this.application = app;
        this.window = window;
        this.rendererFactory = rf;
        this.workbenchTrimElements = workbenchTrimElements;
        this.modelService = (EModelService)window.getContext().get(EModelService.class);
        this.topTrim = (MTrimBar)this.modelService.find(MAIN_TOOLBAR_ID, (MUIElement)window);
        if (this.topTrim == null) {
            this.topTrim = this.modelService.getTrim(window, SideValue.TOP);
            this.topTrim.setElementId(MAIN_TOOLBAR_ID);
        }
        this.topTrim.setToBeRendered(false);
        this.renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)MenuFactoryImpl.eINSTANCE.createToolBar(), null);
    }

    public void add(IAction action) {
    }

    public void add(IContributionItem item) {
        this.add(this.topTrim, -1, item);
    }

    private void add(MTrimBar trimBar, int idx, IContributionItem item) {
        MUIElement spacer;
        if (idx == -1 && (spacer = this.modelService.find("PerspectiveSpacer", (MUIElement)trimBar)) != null) {
            idx = trimBar.getChildren().indexOf(spacer);
        }
        if (item instanceof IToolBarContributionItem) {
            boolean tbFound;
            IToolBarManager mgr = ((IToolBarContributionItem)item).getToolBarManager();
            if (!(mgr instanceof ToolBarManager)) {
                return;
            }
            ToolBarManager manager = (ToolBarManager)mgr;
            if (this.renderer.getToolBarModel(manager) != null) {
                return;
            }
            MToolBar toolBar = (MToolBar)this.modelService.find(item.getId(), (MUIElement)this.window);
            boolean bl = tbFound = toolBar != null;
            if (!tbFound) {
                toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
            } else {
                toolBar.getChildren().clear();
            }
            toolBar.setElementId(item.getId());
            toolBar.getTransientData().put(OBJECT, item);
            if (manager instanceof ToolBarManager) {
                this.renderer.linkModelToManager(toolBar, manager);
            }
            toolBar.setToBeRendered(true);
            if (!tbFound) {
                if (idx < 0) {
                    trimBar.getChildren().add(toolBar);
                } else {
                    trimBar.getChildren().add(idx, toolBar);
                }
            }
            this.workbenchTrimElements.add((MTrimElement)toolBar);
            manager.setOverrides(this.toolbarOverrides);
        } else if (item instanceof IContributionManager) {
            new Exception("Have to deal with " + item).printStackTrace();
        } else if (item instanceof AbstractGroupMarker) {
            boolean tbFound;
            if (item.getId() == null) {
                return;
            }
            for (MTrimElement toolBar : this.topTrim.getChildren()) {
                if (!item.getId().equals(toolBar.getElementId()) || !toolBar.getTags().contains(TOOLBAR_SEPARATOR)) continue;
                return;
            }
            MToolBarSeparator separator = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
            separator.setToBeRendered(false);
            separator.setElementId(item.getId());
            List toolbars = this.modelService.findElements((MUIElement)this.window, item.getId(), MToolBar.class, null);
            MToolBar toolBar = toolbars.isEmpty() ? null : (MToolBar)toolbars.get(0);
            boolean bl = tbFound = toolBar != null;
            if (!tbFound) {
                toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
            } else {
                toolBar.getChildren().clear();
            }
            toolBar.getTransientData().put(OBJECT, item);
            toolBar.getTags().add(TOOLBAR_SEPARATOR);
            toolBar.setElementId(item.getId());
            toolBar.getChildren().add(separator);
            toolBar.setToBeRendered(false);
            if (!tbFound) {
                if (idx < 0) {
                    this.topTrim.getChildren().add(toolBar);
                } else {
                    this.topTrim.getChildren().add(idx, toolBar);
                }
            }
            this.workbenchTrimElements.add((MTrimElement)toolBar);
        }
    }

    public void add(IToolBarManager toolBarManager) {
        if (toolBarManager instanceof ToolBarManager) {
            this.add((IContributionItem)new ToolBarContributionItem(toolBarManager));
        }
    }

    public void appendToGroup(String groupName, IAction action) {
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        List toolBars = this.modelService.findElements((MUIElement)this.window, groupName, MToolBar.class, null);
        if (toolBars.size() == 1) {
            MToolBar el = (MToolBar)toolBars.get(0);
            MTrimBar trimBar = this.getTrim((MTrimElement)el);
            int index = trimBar.getChildren().indexOf(el);
            index = index + 1 < trimBar.getChildren().size() ? index : -1;
            this.add(trimBar, index, item);
        }
        this.add(this.topTrim, -1, item);
    }

    public Control createControl2(Composite parent) {
        new Exception("CBTTM:createControl2()").printStackTrace();
        return null;
    }

    public void dispose() {
        ArrayList<MToolBarElement> toRemove = new ArrayList<MToolBarElement>();
        for (MTrimElement child : this.topTrim.getChildren()) {
            if (!(child instanceof MToolBar)) continue;
            MToolBar toolbar = (MToolBar)child;
            for (MToolBarElement element : toolbar.getChildren()) {
                if (!OpaqueElementUtil.isOpaqueToolItem((MUIElement)element)) continue;
                toRemove.add(element);
            }
            if (toRemove.isEmpty()) continue;
            toolbar.getChildren().removeAll(toRemove);
            toRemove.clear();
        }
    }

    public IContributionItem find(String id) {
        List toolbars = this.modelService.findElements((MUIElement)this.window, id, MToolBar.class, null);
        if (toolbars.isEmpty()) {
            return null;
        }
        final MToolBar model = (MToolBar)toolbars.get(0);
        if (model.getTransientData().get(OBJECT) != null) {
            return (IContributionItem)model.getTransientData().get(OBJECT);
        }
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)model, null);
        ToolBarManager manager = renderer.getManager(model);
        if (manager != null) {
            ToolBarContributionItem toolBarContributionItem = new ToolBarContributionItem((IToolBarManager)manager, model.getElementId()){

                public void setVisible(boolean visible) {
                    super.setVisible(visible);
                    model.setVisible(visible);
                }
            };
            model.getTransientData().put(OBJECT, toolBarContributionItem);
            return toolBarContributionItem;
        }
        if (model.getTags().contains(TOOLBAR_SEPARATOR)) {
            if (model.getTransientData().get(OBJECT) != null) {
                return (IContributionItem)model.getTransientData().get(OBJECT);
            }
            return new GroupMarker(model.getElementId());
        }
        return null;
    }

    public IMenuManager getContextMenuManager() {
        new Exception("CBTTM:getContextMenuManager()").printStackTrace();
        return null;
    }

    public Control getControl2() {
        new Exception("CBTTM:getControl2()").printStackTrace();
        return null;
    }

    public IContributionItem[] getItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        List toolBars = this.modelService.findElements((MUIElement)this.window, null, MToolBar.class, null);
        for (MToolBar el : toolBars) {
            final MToolBar tb = el;
            if (tb.getTransientData().get(OBJECT) != null) {
                items.add((IContributionItem)tb.getTransientData().get(OBJECT));
                continue;
            }
            ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)tb, null);
            ToolBarManager manager = renderer.getManager(tb);
            if (manager != null) {
                ToolBarContributionItem toolBarContributionItem = new ToolBarContributionItem((IToolBarManager)manager, tb.getElementId()){

                    public void setVisible(boolean visible) {
                        super.setVisible(visible);
                        tb.setVisible(visible);
                    }
                };
                tb.getTransientData().put(OBJECT, toolBarContributionItem);
                items.add(toolBarContributionItem);
                continue;
            }
            if (!tb.getTags().contains(TOOLBAR_SEPARATOR)) continue;
            if (tb.getTransientData().get(OBJECT) != null) {
                items.add((IContributionItem)tb.getTransientData().get(OBJECT));
            }
            items.add(new GroupMarker(tb.getElementId()));
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    public boolean getLockLayout() {
        return false;
    }

    public IContributionManagerOverrides getOverrides() {
        return this.toolbarOverrides;
    }

    public int getStyle() {
        return 0;
    }

    public void insertAfter(String id, IAction action) {
    }

    private MTrimBar getTrim(MTrimElement te) {
        if (te == null) {
            return null;
        }
        MElementContainer parentElement = te.getParent();
        return (MTrimBar)(parentElement instanceof MTrimBar ? parentElement : null);
    }

    private MToolBar getToolBar(String id) {
        List toolbars = this.modelService.findElements((MUIElement)this.window, id, MToolBar.class, null);
        if (toolbars.size() == 1) {
            return (MToolBar)toolbars.get(0);
        }
        return null;
    }

    public void insertAfter(String id, IContributionItem item) {
        MToolBar afterElement = this.getToolBar(id);
        if (afterElement == null || this.getTrim((MTrimElement)afterElement) == null) {
            return;
        }
        MTrimBar trimBar = this.getTrim((MTrimElement)afterElement);
        int index = trimBar.getChildren().indexOf(afterElement);
        index = index + 1 < trimBar.getChildren().size() ? index + 1 : -1;
        this.add(trimBar, index, item);
    }

    public void insertBefore(String id, IAction action) {
    }

    public void insertBefore(String id, IContributionItem item) {
        MToolBar beforeElement = this.getToolBar(id);
        if (beforeElement == null || this.getTrim((MTrimElement)beforeElement) == null) {
            return;
        }
        MTrimBar trimBar = this.getTrim((MTrimElement)beforeElement);
        int index = trimBar.getChildren().indexOf(beforeElement);
        this.add(trimBar, index, item);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEmpty() {
        return this.topTrim.getChildren().isEmpty();
    }

    public void markDirty() {
    }

    public void prependToGroup(String groupName, IAction action) {
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        MUIElement gnElement = this.modelService.find(groupName, (MUIElement)this.window);
        if (gnElement instanceof MToolBar) {
            MTrimBar trimBar = this.getTrim((MTrimElement)gnElement);
            int index = trimBar.getChildren().indexOf(gnElement);
            this.add(trimBar, index, item);
        }
        this.add(this.topTrim, -1, item);
    }

    public void refresh() {
    }

    public IContributionItem remove(IContributionItem item) {
        List children = this.modelService.findElements((MUIElement)this.window, null, MToolBar.class, null);
        int i = 0;
        while (i < children.size()) {
            MToolBar child = (MToolBar)children.get(i);
            Object obj = child.getTransientData().get(OBJECT);
            if (obj != null && obj.equals(item)) {
                IToolBarManager parent;
                if (child instanceof MToolBarElement) {
                    this.renderer.clearModelToContribution((MToolBarElement)child, item);
                }
                if (item instanceof IToolBarContributionItem && (parent = ((IToolBarContributionItem)item).getToolBarManager()) instanceof ToolBarManager) {
                    this.renderer.clearModelToManager(child, (ToolBarManager)parent);
                }
                this.workbenchTrimElements.remove(child);
                child.setToBeRendered(false);
                child.getParent().getChildren().remove(child);
                return (IContributionItem)obj;
            }
            if (item.getId() != null && item.getId().equals(child.getElementId())) {
                new Exception("CBTTM:remove(IContributionItem item) " + item + "\n\t" + child).printStackTrace();
            }
            ++i;
        }
        return null;
    }

    public IContributionItem remove(String id) {
        new Exception("CBTTM:remove(String id) " + id).printStackTrace();
        return null;
    }

    public void removeAll() {
        new Exception("CBTTM:removeAll").printStackTrace();
    }

    public void resetItemOrder() {
        this.updateAll(true);
    }

    public void setContextMenuManager(IMenuManager menuManager) {
    }

    public void setItems(IContributionItem[] newItems) {
        new Exception("CBTTM:setItems(IContributionItem[] newItems)").printStackTrace();
    }

    public void setLockLayout(boolean value) {
    }

    public void setOverrides(IContributionManagerOverrides newOverrides) {
        this.toolbarOverrides = newOverrides;
        this.topTrim.getTransientData().put(IContributionManagerOverrides.class.getName(), newOverrides);
    }

    public void update(boolean force) {
        List children = this.modelService.findElements((MUIElement)this.window, null, MToolBar.class, null);
        for (MToolBar el : children) {
            ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)el, null);
            ToolBarManager manager = renderer.getManager(el);
            if (manager == null) continue;
            this.fill(el, (IContributionManager)manager);
            ToolBar tb = manager.getControl();
            if (tb == null || tb.isDisposed()) continue;
            tb.getShell().layout(new Control[]{tb}, 4);
        }
        if (!this.trimBarsAdded) {
            boolean hidden;
            boolean bl = hidden = !this.topTrim.isVisible();
            if (hidden) {
                this.topTrim.setVisible(true);
            }
            this.topTrim.setToBeRendered(true);
            if (hidden) {
                this.topTrim.setVisible(false);
            }
            this.trimBarsAdded = true;
        }
    }

    public void updateAll(boolean force) {
        List children = this.modelService.findElements((MUIElement)this.window, null, MToolBar.class, null);
        for (MToolBar el : children) {
            if (!(el instanceof MToolBar)) continue;
            MToolBar toolbar = el;
            ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)el, null);
            ToolBarManager manager = renderer.getManager(toolbar);
            if (manager == null) continue;
            manager.update(true);
            ToolBar tb = manager.getControl();
            if (tb == null || tb.isDisposed()) continue;
            tb.getShell().layout(new Control[]{tb}, 4);
        }
    }

    private void fill(MToolBar container, IContributionManager manager) {
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)container, null);
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item != null) {
                MToolBarElement toolBarElem = renderer.getToolElement(item);
                if (toolBarElem != null) {
                    if (container.isVisible()) {
                        this.setChildVisible(toolBarElem, item, manager);
                    }
                } else if (item instanceof IToolBarContributionItem) {
                    IToolBarManager manager2 = ((IToolBarContributionItem)item).getToolBarManager();
                    this.fill(container, (IContributionManager)manager2);
                } else if (!(item instanceof IMenuManager)) {
                    if (item instanceof IContributionManager) {
                        this.fill(container, (IContributionManager)item);
                    } else if (item instanceof CommandContributionItem) {
                        CommandContributionItem cci = (CommandContributionItem)item;
                        MToolItem toolItem = MenuHelper.createToolItem(this.application, cci);
                        manager.remove(item);
                        if (toolItem != null) {
                            container.getChildren().add(toolItem);
                        }
                    } else {
                        MToolItem toolItem = OpaqueElementUtil.createOpaqueToolItem();
                        toolItem.setElementId(item.getId());
                        OpaqueElementUtil.setOpaqueItem((MUIElement)toolItem, (Object)item);
                        if (item instanceof AbstractGroupMarker) {
                            toolItem.setVisible(item.isVisible());
                        }
                        renderer.linkModelToContribution((MToolBarElement)toolItem, item);
                        container.getChildren().add(toolItem);
                    }
                }
            }
            ++n2;
        }
    }

    private void setChildVisible(MToolBarElement modelItem, IContributionItem item, IContributionManager manager) {
        Boolean currentChildVisible = this.isChildVisible(item, manager);
        Boolean prevChildVisible = (Boolean)modelItem.getTransientData().get(PREV_CHILD_VISIBLE);
        if (currentChildVisible != null) {
            if (prevChildVisible == null) {
                modelItem.getTransientData().put(PREV_CHILD_VISIBLE, modelItem.isVisible());
                modelItem.setVisible(currentChildVisible.booleanValue());
            }
        } else if (prevChildVisible != null) {
            modelItem.setVisible(prevChildVisible.booleanValue());
            modelItem.getTransientData().remove(PREV_CHILD_VISIBLE);
        }
    }

    private Boolean isChildVisible(IContributionItem item, IContributionManager manager) {
        IContributionManagerOverrides overrides = manager.getOverrides();
        Boolean v = overrides == null ? null : overrides.getVisible(item);
        if (v != null) {
            return (boolean)v;
        }
        return null;
    }
}

