/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.mpc.ui;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.mpc.core.model.ICatalog;
import org.eclipse.epp.mpc.core.model.ICatalogBranding;
import org.eclipse.jface.resource.ImageDescriptor;

public final class CatalogDescriptor {
    private URL url;
    private String label;
    private String description;
    private ImageDescriptor icon;
    private ICatalogBranding catalogBranding;
    private boolean installFromAllRepositories;
    private URL dependenciesRepository;

    public CatalogDescriptor() {
    }

    public CatalogDescriptor(URL url, String label) {
        this.url = url;
        this.label = label;
    }

    public CatalogDescriptor(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.url = catalogDescriptor.url;
        this.label = catalogDescriptor.label;
        this.description = catalogDescriptor.description;
        this.icon = catalogDescriptor.icon;
        this.catalogBranding = catalogDescriptor.catalogBranding;
        this.dependenciesRepository = catalogDescriptor.dependenciesRepository;
        this.installFromAllRepositories = catalogDescriptor.installFromAllRepositories;
    }

    public CatalogDescriptor(ICatalog catalog) throws MalformedURLException {
        this.setLabel(catalog.getName());
        this.setUrl(URLUtil.toURL((String)catalog.getUrl()));
        this.setIcon(ImageDescriptor.createFromURL((URL)URLUtil.toURL((String)catalog.getImageUrl())));
        this.setDescription(catalog.getDescription());
        this.setInstallFromAllRepositories(!catalog.isSelfContained());
        if (catalog.getDependencyRepository() != null) {
            this.setDependenciesRepository(URLUtil.toURL((String)catalog.getDependencyRepository()));
        }
        this.setCatalogBranding(catalog.getBranding());
        if (catalog.getNews() != null) {
            CatalogRegistry.getInstance().addCatalogNews(this, catalog.getNews());
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public void setIcon(ImageDescriptor icon) {
        this.icon = icon;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isInstallFromAllRepositories() {
        return this.installFromAllRepositories;
    }

    public void setInstallFromAllRepositories(boolean installFromAllRepositories) {
        this.installFromAllRepositories = installFromAllRepositories;
    }

    public URL getDependenciesRepository() {
        return this.dependenciesRepository;
    }

    public void setDependenciesRepository(URL dependenciesRepository) {
        this.dependenciesRepository = dependenciesRepository;
    }

    public ICatalogBranding getCatalogBranding() {
        return this.catalogBranding;
    }

    public void setCatalogBranding(ICatalogBranding catalogBranding) {
        this.catalogBranding = catalogBranding;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogDescriptor other = (CatalogDescriptor)obj;
        return CatalogDescriptor.urlEquals(this.url, other.url);
    }

    private static boolean urlEquals(URL url1, URL url2) {
        if (url1 == url2) {
            return true;
        }
        if (url1 == null) {
            return false;
        }
        if (url2 == null) {
            return false;
        }
        try {
            return url1.toURI().equals(url2.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public String toString() {
        return "CatalogDescriptor [url=" + this.url + "]";
    }
}

