/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.operations.FeatureDescriptor;
import org.eclipse.epp.internal.mpc.ui.operations.ResolveFeatureNamesOperation;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.dialogs.RemediationGroup;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSelectionWizardPage
extends WizardPage {
    private CheckboxTreeViewer viewer;
    private Text detailStatusText;
    private Group detailsControl;
    private TreeViewerColumn column;
    private Composite container;
    private RemediationGroup remediationGroup;
    private Composite defaultComposite;
    private StackLayout switchResultLayout;

    protected FeatureSelectionWizardPage() {
        super(FeatureSelectionWizardPage.class.getName());
        this.setTitle(Messages.FeatureSelectionWizardPage_confirmSelectedFeatures);
        this.setDescription(Messages.FeatureSelectionWizardPage_confirmSelectedFeatures_description);
    }

    public MarketplaceWizard getWizard() {
        return (MarketplaceWizard)super.getWizard();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.switchResultLayout = new StackLayout();
        this.container.setLayout((Layout)this.switchResultLayout);
        GridData data = new GridData(1808);
        this.container.setLayoutData((Object)data);
        this.defaultComposite = new Composite(this.container, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.defaultComposite);
        Composite treeContainer = new Composite(this.defaultComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)treeContainer);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        treeContainer.setLayout((Layout)columnLayout);
        this.viewer = new CheckboxTreeViewer(treeContainer, 68354);
        this.viewer.setUseHashlookup(true);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s2;
                String s1;
                if (e1 == e2) {
                    return 0;
                }
                if (e1 instanceof SelectionModel.CatalogItemEntry) {
                    s1 = ((SelectionModel.CatalogItemEntry)e1).getItem().getName();
                    s2 = ((SelectionModel.CatalogItemEntry)e2).getItem().getName();
                } else {
                    s1 = ((SelectionModel.FeatureEntry)e1).getFeatureDescriptor().getName();
                    s2 = ((SelectionModel.FeatureEntry)e2).getFeatureDescriptor().getName();
                }
                int i = s1.compareToIgnoreCase(s2);
                if (i == 0 && (i = s1.compareTo(s2)) == 0) {
                    i = new Integer(System.identityHashCode(e1)).compareTo(System.identityHashCode(e2));
                }
                return i;
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setInput((Object)this.getWizard().getSelectionModel());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof SelectionModel.CatalogItemEntry) {
                    SelectionModel.CatalogItemEntry entry = (SelectionModel.CatalogItemEntry)event.getElement();
                    for (SelectionModel.FeatureEntry child : entry.getChildren()) {
                        child.setChecked(event.getChecked());
                    }
                } else if (event.getElement() instanceof SelectionModel.FeatureEntry) {
                    ((SelectionModel.FeatureEntry)event.getElement()).setChecked(event.getChecked());
                }
                FeatureSelectionWizardPage.this.computeCheckedViewerState();
                FeatureSelectionWizardPage.this.updateMessage();
                FeatureSelectionWizardPage.this.setPageComplete(FeatureSelectionWizardPage.this.computePageComplete());
            }
        });
        this.column = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        this.column.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LabelProvider()));
        columnLayout.setColumnData((Widget)this.column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        this.detailsControl = new Group(this.defaultComposite, 4);
        this.detailsControl.setText(Messages.FeatureSelectionWizardPage_details);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 300).exclude(true).applyTo((Control)this.detailsControl);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.detailsControl);
        this.detailStatusText = new Text((Composite)this.detailsControl, 586);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.detailStatusText);
        this.setControl((Control)this.container);
        Dialog.applyDialogFont((Control)this.container);
        MarketplaceClientUi.setDefaultHelp(this.getControl());
        this.flipToDefaultComposite();
    }

    public RemediationGroup getRemediationGroup() {
        return this.remediationGroup;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    block4: {
                        if (FeatureSelectionWizardPage.this.getControl() == null || FeatureSelectionWizardPage.this.getControl().isDisposed() || FeatureSelectionWizardPage.this.getWizard().getContainer().getCurrentPage() != FeatureSelectionWizardPage.this) {
                            return;
                        }
                        if (FeatureSelectionWizardPage.this.getWizard().wantInitializeInitialSelection()) {
                            try {
                                FeatureSelectionWizardPage.this.getWizard().initializeInitialSelection();
                            }
                            catch (CoreException e) {
                                boolean wasCancelled;
                                boolean bl = wasCancelled = e.getStatus().getSeverity() == 8;
                                if (wasCancelled) break block4;
                                StatusManager.getManager().handle(e.getStatus(), 7);
                            }
                        }
                    }
                    FeatureSelectionWizardPage.this.updateFeatures();
                }
            });
        }
    }

    private void updateFeatures() {
        this.viewer.setInput((Object)this.getWizard().getSelectionModel());
        ResolveFeatureNamesOperation operation = new ResolveFeatureNamesOperation(new ArrayList<CatalogItem>(this.getWizard().getSelectionModel().getItemToSelectedOperation().keySet())){
            Display display;
            {
                this.display = FeatureSelectionWizardPage.this.getControl().getDisplay();
            }

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                super.run(progressMonitor);
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        if (!FeatureSelectionWizardPage.this.getControl().isDisposed()) {
                            FeatureSelectionWizardPage.this.updateFeatureDescriptors(this.getFeatureDescriptors(), this.getUnresolvedFeatureDescriptors());
                        }
                    }
                });
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            IStatus status;
            this.refresh();
            int statusFlags = 1;
            if (e.getCause() instanceof ProvisionException) {
                status = ((ProvisionException)e.getCause()).getStatus();
            } else {
                status = MarketplaceClientUi.computeStatus(e, Messages.FeatureSelectionWizardPage_unexpectedException_verifyingFeatures);
                statusFlags |= 6;
            }
            StatusManager.getManager().handle(status, statusFlags);
        }
        catch (InterruptedException interruptedException) {
            this.refresh();
        }
    }

    private void maybeUpdateProfileChangeOperation() {
        if (this.getWizard().getProfileChangeOperation() == null) {
            this.getWizard().updateProfileChangeOperation();
        }
        this.updateMessage();
        this.setPageComplete(this.computePageComplete());
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage(false) != null;
    }

    public IWizardPage getNextPage(boolean computeChanges) {
        if (this.getWizard() == null) {
            return null;
        }
        return this.getWizard().getNextPage((IWizardPage)this, computeChanges);
    }

    public IWizardPage getNextPage() {
        return this.getNextPage(true);
    }

    void updateMessage() {
        ProfileChangeOperation profileChangeOperation = this.getWizard().getProfileChangeOperation();
        if (profileChangeOperation != null) {
            if (profileChangeOperation instanceof RemediationOperation && ((RemediationOperation)profileChangeOperation).getResolutionResult() == Status.OK_STATUS) {
                if (this.remediationGroup == null) {
                    this.remediationGroup = new RemediationGroup((WizardPage)this);
                    this.remediationGroup.createRemediationControl(this.container);
                }
                this.setMessage(this.remediationGroup.getMessage(), 2);
                this.remediationGroup.getDetailsGroup().setDetailText(this.getWizard().getErrorMessage());
                this.remediationGroup.update((RemediationOperation)profileChangeOperation);
                this.flipToRemediationComposite();
            } else {
                IStatus resolutionResult = profileChangeOperation.getResolutionResult();
                if (!resolutionResult.isOK()) {
                    String newText;
                    String message = resolutionResult.getMessage();
                    if (resolutionResult.getSeverity() == 4) {
                        message = Messages.FeatureSelectionWizardPage_provisioningErrorAdvisory;
                    } else if (resolutionResult.getSeverity() == 2) {
                        message = Messages.FeatureSelectionWizardPage_provisioningWarningAdvisory;
                    }
                    this.setMessage(message, Util.computeMessageType(resolutionResult));
                    String originalText = this.detailStatusText.getText();
                    try {
                        newText = profileChangeOperation.getResolutionDetails();
                    }
                    catch (Exception e) {
                        MarketplaceClientUi.error(e);
                        newText = Messages.FeatureSelectionWizardPage_detailsUnavailable;
                    }
                    if (newText != originalText || newText != null && !newText.equals(originalText)) {
                        this.detailStatusText.setText(newText);
                    }
                    ((GridData)this.detailsControl.getLayoutData()).exclude = false;
                } else {
                    this.setMessage(null, 0);
                    ((GridData)this.detailsControl.getLayoutData()).exclude = true;
                }
            }
        } else {
            this.setMessage(null, 0);
            ((GridData)this.detailsControl.getLayoutData()).exclude = true;
        }
        ((Composite)this.getControl()).layout(true);
        this.defaultComposite.layout(true);
    }

    public IWizardPage getPreviousPage() {
        if (this.switchResultLayout.topControl != this.defaultComposite) {
            return this;
        }
        return super.getPreviousPage();
    }

    private void updateFeatureDescriptors(Set<FeatureDescriptor> featureDescriptors, Set<FeatureDescriptor> unresolvedFeatureDescriptors) {
        boolean pageComplete;
        if (featureDescriptors != null) {
            this.updateSelectionModel(featureDescriptors);
            this.refresh();
        }
        if ((pageComplete = this.computePageComplete()) != this.isPageComplete()) {
            this.setPageComplete(pageComplete);
        }
    }

    private void refresh() {
        this.viewer.refresh();
        this.computeCheckedViewerState();
        this.viewer.expandAll();
    }

    private boolean computePageComplete() {
        return this.getWizard().getSelectionModel().computeProvisioningOperationViable();
    }

    private void updateSelectionModel(Set<FeatureDescriptor> featureDescriptors) {
        HashMap<String, FeatureDescriptor> descriptorById = new HashMap<String, FeatureDescriptor>();
        for (FeatureDescriptor fd : featureDescriptors) {
            descriptorById.put(fd.getId(), fd);
        }
        SelectionModel selectionModel = this.getWizard().getSelectionModel();
        for (SelectionModel.CatalogItemEntry entry : selectionModel.getCatalogItemEntries()) {
            for (SelectionModel.FeatureEntry child : entry.getChildren()) {
                FeatureDescriptor descriptor = (FeatureDescriptor)descriptorById.get(child.getFeatureDescriptor().getId());
                if (descriptor == null) continue;
                child.setFeatureDescriptor(descriptor);
            }
        }
    }

    public void computeCheckedViewerState() {
        ArrayList<Object> checkedElements = new ArrayList<Object>();
        ArrayList<SelectionModel.CatalogItemEntry> grayCheckedElements = new ArrayList<SelectionModel.CatalogItemEntry>();
        for (SelectionModel.CatalogItemEntry entry : this.getWizard().getSelectionModel().getCatalogItemEntries()) {
            int childCheckCount = 0;
            for (SelectionModel.FeatureEntry child : entry.getChildren()) {
                if (!child.isChecked()) continue;
                checkedElements.add(child);
                ++childCheckCount;
            }
            if (childCheckCount == entry.getChildren().size()) {
                checkedElements.add(entry);
                continue;
            }
            if (childCheckCount <= 0) continue;
            grayCheckedElements.add(entry);
            checkedElements.add(entry);
        }
        this.viewer.setCheckedElements(checkedElements.toArray());
        this.viewer.setGrayedElements(grayCheckedElements.toArray());
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }

    public void flipToRemediationComposite() {
        this.switchResultLayout.topControl = this.remediationGroup.getComposite();
        this.container.layout();
    }

    public void flipToDefaultComposite() {
        this.switchResultLayout.topControl = this.defaultComposite;
        this.container.layout();
    }

    public boolean isInRemediationMode() {
        return this.switchResultLayout.topControl != this.defaultComposite;
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private Object input;

        private ContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == this.input && this.input != null) {
                return ((SelectionModel)this.input).getCatalogItemEntries().toArray();
            }
            if (inputElement instanceof SelectionModel.CatalogItemEntry) {
                return ((SelectionModel.CatalogItemEntry)inputElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return element == this.input || element instanceof SelectionModel.CatalogItemEntry;
        }

        public Object getParent(Object element) {
            if (element instanceof SelectionModel.FeatureEntry) {
                return ((SelectionModel.FeatureEntry)element).getParent();
            }
            return this.input;
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }
    }

    private static class LabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private LabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            styledString.append(this.getText(element));
            if (element instanceof SelectionModel.CatalogItemEntry) {
                SelectionModel.CatalogItemEntry entry = (SelectionModel.CatalogItemEntry)element;
                styledString.append("  " + entry.getItem().getSiteUrl(), StyledString.QUALIFIER_STYLER);
            }
            return styledString;
        }

        public Image getImage(Object element) {
            if (element instanceof SelectionModel.FeatureEntry) {
                SelectionModel.FeatureEntry entry = (SelectionModel.FeatureEntry)element;
                switch (entry.getParent().getSelectedOperation()) {
                    case UPDATE: {
                        if (entry.isInstalled()) {
                            return MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("IU_ICON_UPDATE");
                        }
                    }
                    case INSTALL: {
                        return MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("IU_ICON");
                    }
                }
            } else if (element instanceof SelectionModel.CatalogItemEntry) {
                return MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("IU_ICON");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof SelectionModel.CatalogItemEntry) {
                SelectionModel.CatalogItemEntry entry = (SelectionModel.CatalogItemEntry)element;
                return entry.getItem().getName();
            }
            if (element instanceof SelectionModel.FeatureEntry) {
                SelectionModel.FeatureEntry entry = (SelectionModel.FeatureEntry)element;
                return entry.getFeatureDescriptor().getName();
            }
            return element.toString();
        }
    }
}

