/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiToolsLabelProvider;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiBaselinesConfigurationBlock;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiBaselineWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ApiBaselinePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.pde.api.tools.ui.apiprofiles.prefpage";
    IApiBaselineManager manager = ApiPlugin.getDefault().getApiBaselineManager();
    private static HashSet<String> removed = new HashSet(8);
    CheckboxTableViewer tableviewer = null;
    ArrayList<IApiBaseline> backingcollection = new ArrayList(8);
    String newdefault = null;
    private Button newbutton = null;
    Button removebutton = null;
    Button editbutton = null;
    protected static int rebuildcount = 0;
    String origdefault = null;
    boolean dirty = false;
    private boolean defaultcontentchanged = false;
    boolean defaultchanged = false;
    private ApiBaselinesConfigurationBlock block = null;

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        SWTFactory.createWrapLabel(comp, PreferenceMessages.ApiProfilesPreferencePage_0, 2, 200);
        SWTFactory.createVerticalSpacer(comp, 1);
        Composite lcomp = SWTFactory.createComposite(comp, 2, 1, 1808, 0, 0);
        SWTFactory.createWrapLabel(lcomp, PreferenceMessages.ApiProfilesPreferencePage_1, 2);
        Table table = new Table(lcomp, 67618);
        table.setLayoutData((Object)new GridData(1808));
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    ApiBaselinePreferencePage.this.doRemove();
                }
            }
        });
        this.tableviewer = new CheckboxTableViewer(table);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new BaselineLabelProvider());
        this.tableviewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                ApiBaselinePreferencePage.this.doEdit((IApiBaseline)ss.getFirstElement());
            }
        });
        this.tableviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IApiBaseline[] state = ApiBaselinePreferencePage.this.getCurrentSelection();
                ApiBaselinePreferencePage.this.removebutton.setEnabled(state.length > 0);
                ApiBaselinePreferencePage.this.editbutton.setEnabled(state.length == 1);
            }
        });
        this.tableviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IApiBaseline baseline = (IApiBaseline)event.getElement();
                boolean checked = event.getChecked();
                if (checked) {
                    ApiBaselinePreferencePage.this.tableviewer.setCheckedElements(new Object[]{baseline});
                    ApiBaselinePreferencePage.this.newdefault = baseline.getName();
                    ApiBaselinePreferencePage.this.defaultchanged = !ApiBaselinePreferencePage.this.newdefault.equals(ApiBaselinePreferencePage.this.origdefault);
                } else {
                    ApiBaselinePreferencePage.this.tableviewer.setChecked((Object)baseline, checked);
                    ApiBaselinePreferencePage.this.newdefault = null;
                    ApiBaselinePreferencePage.this.manager.setDefaultApiBaseline(null);
                    ApiBaselinePreferencePage.this.defaultchanged = true;
                }
                rebuildcount = 0;
                ApiBaselinePreferencePage.this.tableviewer.refresh(true);
                ApiBaselinePreferencePage.this.dirty = true;
            }
        });
        this.tableviewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IApiBaseline)e1).getName().compareTo(((IApiBaseline)e2).getName());
            }
        });
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ApiBaselinePreferencePage.this.backingcollection.addAll(Arrays.asList(ApiBaselinePreferencePage.this.manager.getApiBaselines()));
                ApiBaselinePreferencePage.this.tableviewer.setInput(ApiBaselinePreferencePage.this.backingcollection);
            }
        });
        Composite bcomp = SWTFactory.createComposite(lcomp, 1, 1, 1042, 0, 0);
        this.newbutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_2, null);
        this.newbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IApiBaseline profile;
                ApiBaselineWizard wizard = new ApiBaselineWizard(null);
                WizardDialog dialog = new WizardDialog(ApiUIPlugin.getShell(), (IWizard)wizard);
                if (dialog.open() == 0 && (profile = wizard.getProfile()) != null) {
                    ApiBaselinePreferencePage.this.backingcollection.add(profile);
                    ApiBaselinePreferencePage.this.tableviewer.refresh();
                    ApiBaselinePreferencePage.this.tableviewer.setSelection((ISelection)new StructuredSelection((Object)profile), true);
                    if (ApiBaselinePreferencePage.this.backingcollection.size() == 1) {
                        ApiBaselinePreferencePage.this.newdefault = profile.getName();
                        ApiBaselinePreferencePage.this.tableviewer.setCheckedElements(new Object[]{profile});
                        ApiBaselinePreferencePage.this.tableviewer.refresh((Object)profile);
                        ApiBaselinePreferencePage.this.defaultchanged = true;
                        rebuildcount = 0;
                    }
                    ApiBaselinePreferencePage.this.dirty = true;
                }
            }
        });
        this.editbutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_4, null);
        this.editbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiBaselinePreferencePage.this.doEdit(ApiBaselinePreferencePage.this.getCurrentSelection()[0]);
            }
        });
        this.editbutton.setEnabled(false);
        this.removebutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_3, null);
        this.removebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiBaselinePreferencePage.this.doRemove();
            }
        });
        this.removebutton.setEnabled(false);
        SWTFactory.createVerticalSpacer(bcomp, 1);
        IApiBaseline baseline = this.manager.getDefaultApiBaseline();
        if (baseline != null) {
            this.tableviewer.setCheckedElements(new Object[]{baseline});
        }
        this.newdefault = baseline == null ? null : baseline.getName();
        this.origdefault = this.newdefault;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IApiToolsHelpContextIds.APIBASELINE_PREF_PAGE);
        this.block = new ApiBaselinesConfigurationBlock((IWorkbenchPreferenceContainer)this.getContainer());
        this.block.createControl(comp, this);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    public static boolean isRemovedBaseline(String name) {
        return removed.contains(name);
    }

    protected void doRemove() {
        IApiBaseline[] states = this.getCurrentSelection();
        int i = 0;
        while (i < states.length) {
            if (this.isDefault(states[i])) {
                this.newdefault = null;
                this.manager.setDefaultApiBaseline(null);
                this.defaultchanged = true;
                rebuildcount = 0;
            }
            removed.add(states[i].getName());
            ++i;
        }
        if (this.backingcollection.removeAll(Arrays.asList(states))) {
            this.dirty = true;
        }
        this.tableviewer.refresh();
    }

    protected void doEdit(IApiBaseline baseline) {
        IApiBaseline newbaseline;
        ApiBaselineWizard wizard = new ApiBaselineWizard(baseline);
        WizardDialog dialog = new WizardDialog(ApiUIPlugin.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (newbaseline = wizard.getProfile()) != null) {
            removed.add(baseline.getName());
            this.backingcollection.remove(baseline);
            this.backingcollection.add(newbaseline);
            this.tableviewer.refresh();
            if (this.isDefault(baseline)) {
                this.tableviewer.setSelection((ISelection)new StructuredSelection((Object)newbaseline), true);
                this.tableviewer.setCheckedElements(new Object[]{newbaseline});
                this.newdefault = newbaseline.getName();
                rebuildcount = 0;
                this.defaultcontentchanged = wizard.contentChanged();
                this.tableviewer.refresh(true);
            }
            this.dirty = true;
        }
    }

    protected boolean isDefault(Object element) {
        if (element instanceof IApiBaseline) {
            IApiBaseline profile = (IApiBaseline)element;
            if (this.newdefault == null) {
                IApiBaseline def = ApiPlugin.getDefault().getApiBaselineManager().getDefaultApiBaseline();
                if (def != null) {
                    return profile.getName().equals(def.getName());
                }
            } else {
                return profile.getName().equals(this.newdefault);
            }
        }
        return false;
    }

    protected IApiBaseline[] getCurrentSelection() {
        IStructuredSelection ss = (IStructuredSelection)this.tableviewer.getSelection();
        if (ss.isEmpty()) {
            return new IApiBaseline[0];
        }
        return ((IStructuredSelection)this.tableviewer.getSelection()).toList().toArray(new IApiBaseline[ss.size()]);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        this.manager.setDefaultApiBaseline(this.origdefault);
        this.backingcollection.clear();
        removed.clear();
        if (this.block != null) {
            this.block.performCancel();
        }
        return super.performCancel();
    }

    protected void applyChanges() {
        if (!this.dirty) {
            return;
        }
        Iterator<String> iter = removed.iterator();
        while (iter.hasNext()) {
            this.manager.removeApiBaseline(iter.next());
        }
        iter = this.backingcollection.iterator();
        while (iter.hasNext()) {
            this.manager.addApiBaseline((IApiBaseline)iter.next());
        }
        this.manager.setDefaultApiBaseline(this.newdefault);
        if ((this.defaultchanged || this.defaultcontentchanged) && rebuildcount < 1) {
            ++rebuildcount;
            IProject[] projects = Util.getApiProjects();
            if (projects != null && MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferenceMessages.ApiProfilesPreferencePage_6, (String)PreferenceMessages.ApiProfilesPreferencePage_7)) {
                Util.getBuildJob((IProject[])projects).schedule();
            }
        }
        this.origdefault = this.newdefault;
        this.dirty = false;
        this.defaultcontentchanged = false;
        this.defaultchanged = false;
        removed.clear();
    }

    public boolean performOk() {
        this.block.performOK();
        this.applyChanges();
        return true;
    }

    protected void performApply() {
        this.block.performApply();
        this.applyChanges();
    }

    protected void performDefaults() {
        this.block.performDefaults();
        this.applyChanges();
    }

    class BaselineLabelProvider
    extends ApiToolsLabelProvider {
        BaselineLabelProvider() {
        }

        @Override
        protected boolean isDefaultBaseline(Object element) {
            return ApiBaselinePreferencePage.this.isDefault(element);
        }
    }
}

