/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.internal.CachedCheckboxTreeViewer;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.FilteredCheckboxTree;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchSelectionDialog<T>
extends MessageDialog {
    private final List<T> nodes;
    private TableViewer branchesList;
    private FilteredCheckboxTree fTree;
    private List<T> selected = new ArrayList<T>();
    private final int style;
    private final boolean multiMode;

    public BranchSelectionDialog(Shell parentShell, List<T> nodes, String title, String message, int style) {
        super(parentShell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.nodes = nodes;
        this.style = style;
        this.multiMode = (this.style & 2) > 0;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)area);
        area.setLayout((Layout)new GridLayout(1, false));
        if (this.multiMode) {
            this.fTree = new FilteredCheckboxTree(area, null, 0, new PatternFilter()){

                protected WorkbenchJob doCreateRefreshJob() {
                    WorkbenchJob refreshJob = super.doCreateRefreshJob();
                    refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (event.getResult().isOK()) {
                                this.getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        BranchSelectionDialog.this.checkPage();
                                    }
                                });
                            }
                        }
                    });
                    return refreshJob;
                }
            };
            CachedCheckboxTreeViewer viewer = this.fTree.getCheckboxTreeViewer();
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fTree);
            viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void inputChanged(Viewer actViewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    return ((List)inputElement).toArray();
                }

                public Object[] getChildren(Object parentElement) {
                    return null;
                }
            });
            viewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    BranchSelectionDialog.this.checkPage();
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)new GitLabelProvider());
            viewer.setComparator(new ViewerComparator(CommonUtils.STRING_ASCENDING_COMPARATOR));
            viewer.setInput(this.nodes);
        } else {
            this.branchesList = new TableViewer(area, this.style | 0x100 | 0x200 | 0x800);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(this.branchesList.getControl());
            this.branchesList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.branchesList.setLabelProvider((IBaseLabelProvider)new GitLabelProvider());
            this.branchesList.setComparator(new ViewerComparator(CommonUtils.STRING_ASCENDING_COMPARATOR));
            this.branchesList.setInput(this.nodes);
            this.branchesList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    BranchSelectionDialog.this.checkPage();
                }
            });
            this.branchesList.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    BranchSelectionDialog.this.buttonPressed(0);
                }
            });
        }
        return area;
    }

    private void checkPage() {
        if (this.multiMode) {
            this.getButton(0).setEnabled(this.fTree.getCheckboxTreeViewer().getCheckedLeafCount() > 0);
        } else {
            this.getButton(0).setEnabled(!this.branchesList.getSelection().isEmpty());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.multiMode) {
                Object[] checked;
                this.selected.clear();
                Object[] objectArray = checked = this.fTree.getCheckboxTreeViewer().getCheckedElements();
                int n = checked.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    this.selected.add(o);
                    ++n2;
                }
            } else {
                this.selected = ((IStructuredSelection)this.branchesList.getSelection()).toList();
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public T getSelectedNode() {
        if (this.selected.isEmpty()) {
            return null;
        }
        return this.selected.get(0);
    }

    public List<T> getSelectedNodes() {
        return this.selected;
    }
}

