/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;

public class JavaWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String fExpressionText;
    private IWatchExpressionListener fListener;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.fExpressionText = expression;
        this.fListener = listener;
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (frame == null) {
            this.fListener.watchEvaluationFinished(null);
        } else {
            IJavaStackFrame javaStackFrame = (IJavaStackFrame)frame.getAdapter(IJavaStackFrame.class);
            if (javaStackFrame != null) {
                this.doEvaluation(javaStackFrame);
            } else {
                this.fListener.watchEvaluationFinished(null);
            }
        }
    }

    protected void doEvaluation(IJavaStackFrame javaStackFrame) {
        IJavaThread thread = (IJavaThread)javaStackFrame.getThread();
        if (this.preEvaluationCheck(thread)) {
            thread.queueRunnable((Runnable)new EvaluationRunnable(javaStackFrame));
        } else {
            this.fListener.watchEvaluationFinished(null);
        }
    }

    private boolean preEvaluationCheck(IJavaThread javaThread) {
        if (javaThread == null) {
            return false;
        }
        return !javaThread.isSuspended() || !((JDIThread)javaThread).isInvokingMethod();
    }

    private final class EvaluationRunnable
    implements Runnable {
        private final IJavaStackFrame fStackFrame;

        private EvaluationRunnable(IJavaStackFrame frame) {
            this.fStackFrame = frame;
        }

        public void run() {
            IJavaProject project = JavaDebugUtils.resolveJavaProject((IJavaStackFrame)this.fStackFrame);
            if (project == null) {
                JavaWatchExpressionDelegate.this.fListener.watchEvaluationFinished(null);
                return;
            }
            IAstEvaluationEngine evaluationEngine = JDIDebugPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)this.fStackFrame.getDebugTarget());
            IEvaluationListener listener = new IEvaluationListener(){

                public void evaluationComplete(final IEvaluationResult result) {
                    IWatchExpressionResult watchResult = new IWatchExpressionResult(){

                        public IValue getValue() {
                            return result.getValue();
                        }

                        public boolean hasErrors() {
                            return result.hasErrors();
                        }

                        public String[] getErrorMessages() {
                            return JavaInspectExpression.getErrorMessages(result);
                        }

                        public String getExpressionText() {
                            return result.getSnippet();
                        }

                        public DebugException getException() {
                            return result.getException();
                        }
                    };
                    JavaWatchExpressionDelegate.this.fListener.watchEvaluationFinished(watchResult);
                }
            };
            try {
                evaluationEngine.evaluate(JavaWatchExpressionDelegate.this.fExpressionText, this.fStackFrame, listener, 128, false);
            }
            catch (DebugException e) {
                JDIDebugPlugin.log((Throwable)e);
                JavaWatchExpressionDelegate.this.fListener.watchEvaluationFinished(null);
            }
        }
    }
}

