/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import org.eclipse.equinox.p2.internal.repository.comparator.java.AnnotationComponentValue;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPoolEntry;

public class AnnotationComponent
extends ClassFileStruct {
    private int componentNameIndex;
    private char[] componentName;
    private AnnotationComponentValue componentValue;
    private int readOffset;

    public AnnotationComponent(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        AnnotationComponentValue value;
        int nameIndex;
        this.componentNameIndex = nameIndex = this.u2At(classFileBytes, 0, offset);
        if (nameIndex != 0) {
            ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(nameIndex);
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            this.componentName = constantPoolEntry.getUtf8Value();
        }
        this.readOffset = 2;
        this.componentValue = value = new AnnotationComponentValue(classFileBytes, constantPool, offset + this.readOffset);
        this.readOffset += value.sizeInBytes();
    }

    public int getComponentNameIndex() {
        return this.componentNameIndex;
    }

    public char[] getComponentName() {
        return this.componentName;
    }

    public AnnotationComponentValue getComponentValue() {
        return this.componentValue;
    }

    int sizeInBytes() {
        return this.readOffset;
    }
}

