/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TodoTaskInputDialog;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TodoTaskConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_COMPILER_TASK_TAGS = TodoTaskConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.taskTags");
    private static final OptionsConfigurationBlock.Key PREF_COMPILER_TASK_PRIORITIES = TodoTaskConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.taskPriorities");
    private static final OptionsConfigurationBlock.Key PREF_COMPILER_TASK_CASE_SENSITIVE = TodoTaskConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.taskCaseSensitive");
    private static final String PRIORITY_HIGH = "HIGH";
    private static final String PRIORITY_NORMAL = "NORMAL";
    private static final String PRIORITY_LOW = "LOW";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_DEFAULT = 4;
    private IStatus fTaskTagsStatus;
    private ListDialogField<TodoTask> fTodoTasksList;
    private SelectionButtonDialogField fCaseSensitiveCheckBox;

    public TodoTaskConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, TodoTaskConfigurationBlock.getKeys(), container);
        TaskTagAdapter adapter = new TaskTagAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_add_button;
        stringArray[1] = PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_edit_button;
        stringArray[2] = PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_remove_button;
        stringArray[4] = PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_setdefault_button;
        String[] buttons = stringArray;
        this.fTodoTasksList = new ListDialogField<TodoTask>(adapter, buttons, (ILabelProvider)new TodoTaskLabelProvider());
        this.fTodoTasksList.setDialogFieldListener(adapter);
        this.fTodoTasksList.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_name_column, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_priority_column};
        this.fTodoTasksList.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.fTodoTasksList.setViewerComparator(new TodoTaskSorter());
        this.fCaseSensitiveCheckBox = new SelectionButtonDialogField(32);
        this.fCaseSensitiveCheckBox.setLabelText(PreferencesMessages.TodoTaskConfigurationBlock_casesensitive_label);
        this.fCaseSensitiveCheckBox.setDialogFieldListener(adapter);
        this.unpackTodoTasks();
        if (this.fTodoTasksList.getSize() > 0) {
            this.fTodoTasksList.selectFirstElement();
        } else {
            this.fTodoTasksList.enableButton(1, false);
            this.fTodoTasksList.enableButton(4, false);
        }
        this.fTaskTagsStatus = new StatusInfo();
    }

    public void setEnabled(boolean isEnabled) {
        this.fTodoTasksList.setEnabled(isEnabled);
        this.fCaseSensitiveCheckBox.setEnabled(isEnabled);
    }

    final boolean isDefaultTask(TodoTask task) {
        return this.fTodoTasksList.getIndexOfElement(task) == 0;
    }

    private void setToDefaultTask(TodoTask task) {
        List<TodoTask> elements = this.fTodoTasksList.getElements();
        elements.remove(task);
        elements.add(0, task);
        this.fTodoTasksList.setElements(elements);
        this.fTodoTasksList.enableButton(4, false);
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_COMPILER_TASK_TAGS, PREF_COMPILER_TASK_PRIORITIES, PREF_COMPILER_TASK_CASE_SENSITIVE};
    }

    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite markersComposite = this.createMarkersTabContent(parent);
        this.validateSettings(null, null, null);
        return markersComposite;
    }

    private Composite createMarkersTabContent(Composite folder) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)folder);
        Composite markersComposite = new Composite(folder, 0);
        markersComposite.setLayout((Layout)layout);
        markersComposite.setFont(folder.getFont());
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.fTodoTasksList.getListControl(markersComposite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.fTodoTasksList.getButtonBox(markersComposite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        this.fCaseSensitiveCheckBox.doFillIntoGrid(markersComposite, 2);
        return markersComposite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            if (!PREF_COMPILER_TASK_TAGS.equals(changedKey)) return;
            this.fTaskTagsStatus = this.validateTaskTags();
        } else {
            this.fTaskTagsStatus = this.validateTaskTags();
        }
        IStatus status = this.fTaskTagsStatus;
        this.fContext.statusChanged(status);
    }

    private IStatus validateTaskTags() {
        return new StatusInfo();
    }

    protected final void updateModel(DialogField field) {
        if (field == this.fTodoTasksList) {
            StringBuffer tags = new StringBuffer();
            StringBuffer prios = new StringBuffer();
            List<TodoTask> list = this.fTodoTasksList.getElements();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    tags.append(',');
                    prios.append(',');
                }
                TodoTask elem = list.get(i);
                tags.append(elem.name);
                prios.append(elem.priority);
                ++i;
            }
            this.setValue(PREF_COMPILER_TASK_TAGS, tags.toString());
            this.setValue(PREF_COMPILER_TASK_PRIORITIES, prios.toString());
            this.validateSettings(PREF_COMPILER_TASK_TAGS, null, null);
        } else if (field == this.fCaseSensitiveCheckBox) {
            String state = this.fCaseSensitiveCheckBox.isSelected() ? ENABLED : DISABLED;
            this.setValue(PREF_COMPILER_TASK_CASE_SENSITIVE, state);
        }
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.TodoTaskConfigurationBlock_needsbuild_title;
        String message = this.fProject == null ? PreferencesMessages.TodoTaskConfigurationBlock_needsfullbuild_message : PreferencesMessages.TodoTaskConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    protected void updateControls() {
        this.unpackTodoTasks();
    }

    private void unpackTodoTasks() {
        String currTags = this.getValue(PREF_COMPILER_TASK_TAGS);
        String currPrios = this.getValue(PREF_COMPILER_TASK_PRIORITIES);
        String[] tags = this.getTokens(currTags, ",");
        String[] prios = this.getTokens(currPrios, ",");
        ArrayList<TodoTask> elements = new ArrayList<TodoTask>(tags.length);
        int i = 0;
        while (i < tags.length) {
            TodoTask task = new TodoTask();
            task.name = tags[i].trim();
            task.priority = i < prios.length ? prios[i] : PRIORITY_NORMAL;
            elements.add(task);
            ++i;
        }
        this.fTodoTasksList.setElements(elements);
        boolean isCaseSensitive = this.checkValue(PREF_COMPILER_TASK_CASE_SENSITIVE, ENABLED);
        this.fCaseSensitiveCheckBox.setSelection(isCaseSensitive);
    }

    private void doTodoButtonPressed(int index) {
        TodoTask edited = null;
        if (index != 0) {
            edited = this.fTodoTasksList.getSelectedElements().get(0);
        }
        if (index == 0 || index == 1) {
            TodoTaskInputDialog dialog = new TodoTaskInputDialog(this.getShell(), edited, this.fTodoTasksList.getElements());
            if (dialog.open() == 0) {
                if (edited != null) {
                    this.fTodoTasksList.replaceElement(edited, dialog.getResult());
                } else {
                    this.fTodoTasksList.addElement(dialog.getResult());
                }
            }
        } else if (index == 4) {
            this.setToDefaultTask(edited);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TaskTagAdapter
    implements IListAdapter<TodoTask>,
    IDialogFieldListener {
        private boolean canEdit(List<TodoTask> selectedElements) {
            return selectedElements.size() == 1;
        }

        private boolean canSetToDefault(List<TodoTask> selectedElements) {
            return selectedElements.size() == 1 && !TodoTaskConfigurationBlock.this.isDefaultTask(selectedElements.get(0));
        }

        @Override
        public void customButtonPressed(ListDialogField<TodoTask> field, int index) {
            TodoTaskConfigurationBlock.this.doTodoButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField<TodoTask> field) {
            List<TodoTask> selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
            field.enableButton(4, this.canSetToDefault(selectedElements));
        }

        @Override
        public void doubleClicked(ListDialogField<TodoTask> field) {
            if (this.canEdit(field.getSelectedElements())) {
                TodoTaskConfigurationBlock.this.doTodoButtonPressed(1);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            TodoTaskConfigurationBlock.this.updateModel(field);
        }
    }

    public static class TodoTask {
        public String name;
        public String priority;
    }

    private class TodoTaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TodoTask task = (TodoTask)element;
            if (columnIndex == 0) {
                String name = task.name;
                if (TodoTaskConfigurationBlock.this.isDefaultTask(task)) {
                    name = Messages.format(PreferencesMessages.TodoTaskConfigurationBlock_tasks_default, name);
                }
                return name;
            }
            if (TodoTaskConfigurationBlock.PRIORITY_HIGH.equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_high_priority;
            }
            if (TodoTaskConfigurationBlock.PRIORITY_NORMAL.equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_normal_priority;
            }
            if (TodoTaskConfigurationBlock.PRIORITY_LOW.equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_low_priority;
            }
            return "";
        }

        public Font getFont(Object element) {
            if (TodoTaskConfigurationBlock.this.isDefaultTask((TodoTask)element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }

    private static class TodoTaskSorter
    extends ViewerComparator {
        private TodoTaskSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(((TodoTask)e1).name, ((TodoTask)e2).name);
        }
    }
}

