/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarBuilder;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarManifestProvider;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;

public class UnpackFatJarBuilder
extends FatJarBuilder {
    public static final String BUILDER_ID = "org.eclipse.jdt.ui.fat_jar_builder";

    public String getId() {
        return BUILDER_ID;
    }

    public IManifestProvider getManifestProvider() {
        return new FatJarManifestProvider(this);
    }

    public String getManifestClasspath() {
        return ".";
    }

    public boolean isMergeManifests() {
        return true;
    }

    public boolean isRemoveSigners() {
        return true;
    }

    public void writeArchive(ZipFile jarFile, IProgressMonitor progressMonitor) {
        Enumeration<? extends ZipEntry> jarEntriesEnum = jarFile.entries();
        while (jarEntriesEnum.hasMoreElements()) {
            ZipEntry jarEntry = jarEntriesEnum.nextElement();
            if (!jarEntry.isDirectory()) {
                String entryName = jarEntry.getName();
                this.addFile(entryName, jarEntry, jarFile);
            }
            progressMonitor.worked(1);
            if (!progressMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    private void addFile(String destinationPath, ZipEntry jarEntry, ZipFile zipFile) {
        if (destinationPath.equalsIgnoreCase("META-INF/MANIFEST.MF") || this.isRemoveSigners() && destinationPath.startsWith("META-INF/") && destinationPath.endsWith(".SF")) {
            return;
        }
        try {
            this.getJarWriter().addZipEntry(jarEntry, zipFile, destinationPath);
        }
        catch (IOException ex) {
            if (ex instanceof ZipException && ex.getMessage() != null && ex.getMessage().startsWith("duplicate entry:")) {
                if (!destinationPath.startsWith("META-INF/")) {
                    this.addWarning(ex.getMessage(), ex);
                }
            }
            this.addWarning(Messages.format(FatJarPackagerMessages.FatJarBuilder_error_readingArchiveFile, new Object[]{BasicElementLabels.getResourceName(zipFile.getName()), ex.getLocalizedMessage()}), ex);
        }
    }
}

