/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.core.site.SiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.category.CategoryEditor;

public class CategoryUndoManager
extends ModelUndoManager {
    public CategoryUndoManager(CategoryEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    @Override
    protected String getPageId(Object obj) {
        if (obj instanceof ISiteFeature || obj instanceof ISiteBundle || obj instanceof ISiteCategory || obj instanceof ISiteCategoryDefinition) {
            return "ius";
        }
        return null;
    }

    @Override
    protected void execute(IModelChangedEvent event, boolean undo) {
        IModelChangeProvider model = event.getChangeProvider();
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(model, elements);
                    break;
                }
                this.executeAdd(model, elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(model, elements);
                    break;
                }
                this.executeRemove(model, elements);
                break;
            }
            case 3: {
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void executeAdd(IModelChangeProvider model, Object[] elements) {
        ISiteModel siteModel = model instanceof ISiteModel ? (ISiteModel)model : null;
        ISite site = siteModel != null ? siteModel.getSite() : null;
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof ISiteFeature) {
                    site.addFeatures(new ISiteFeature[]{(ISiteFeature)element});
                } else if (element instanceof ISiteBundle) {
                    site.addBundles(new ISiteBundle[]{(ISiteBundle)element});
                } else if (element instanceof ISiteArchive) {
                    site.addArchives(new ISiteArchive[]{(ISiteArchive)element});
                } else if (element instanceof ISiteCategoryDefinition) {
                    site.addCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)element});
                } else if (element instanceof ISiteCategory) {
                    ISiteCategory category = (ISiteCategory)element;
                    ISiteObject siteObject = category.getParent();
                    if (siteObject instanceof ISiteFeature) {
                        ((ISiteFeature)siteObject).addCategories(new ISiteCategory[]{category});
                    } else if (siteObject instanceof ISiteBundle) {
                        ((ISiteBundle)siteObject).addCategories(new ISiteCategory[]{category});
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeRemove(IModelChangeProvider model, Object[] elements) {
        ISiteModel siteModel = model instanceof ISiteModel ? (ISiteModel)model : null;
        ISite site = siteModel != null ? siteModel.getSite() : null;
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof ISiteFeature) {
                    site.removeFeatures(new ISiteFeature[]{(ISiteFeature)element});
                } else if (element instanceof ISiteBundle) {
                    site.removeBundles(new ISiteBundle[]{(ISiteBundle)element});
                } else if (element instanceof ISiteArchive) {
                    site.removeArchives(new ISiteArchive[]{(ISiteArchive)element});
                } else if (element instanceof ISiteCategoryDefinition) {
                    site.removeCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)element});
                } else if (element instanceof ISiteCategory) {
                    ISiteCategory category = (ISiteCategory)element;
                    ISiteObject siteObject = category.getParent();
                    if (siteObject instanceof ISiteFeature) {
                        ((ISiteFeature)siteObject).removeCategories(new ISiteCategory[]{category});
                    } else if (siteObject instanceof ISiteBundle) {
                        ((ISiteBundle)siteObject).removeCategories(new ISiteCategory[]{category});
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        if (element instanceof SiteObject) {
            SiteObject sobj = (SiteObject)element;
            try {
                sobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        ISiteObject obj;
        Object object;
        if (event.getChangeType() == 3 && (object = event.getChangedObjects()[0]) instanceof ISiteObject && !((obj = (ISiteObject)object) instanceof ISite) && !obj.isInTheModel()) {
            return;
        }
        super.modelChanged(event);
    }
}

