/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.util.ConcurrentTaskManager;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceCatalog
extends Catalog {
    private final Map<String, Boolean> updateAvailableByNodeId = new HashMap<String, Boolean>();
    private INews news;

    public IStatus performQuery(final IMarket market, final ICategory category, final String queryText, IProgressMonitor monitor) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.performQuery(market, category, queryText, monitor);
            }
        }, monitor);
    }

    public IStatus recent(IProgressMonitor monitor) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.recent(monitor);
            }
        }, monitor);
    }

    public IStatus popular(IProgressMonitor monitor) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.popular(monitor);
            }
        }, monitor);
    }

    public IStatus featured(IProgressMonitor monitor, final IMarket market, final ICategory category) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.featured(monitor, market, category);
            }
        }, monitor);
    }

    public IStatus installed(IProgressMonitor monitor) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.installed(monitor);
            }
        }, monitor);
    }

    public IStatus performQuery(IProgressMonitor monitor, final Set<String> nodeIds) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.performQuery(monitor, nodeIds);
            }
        }, monitor);
    }

    public IStatus performNodeQuery(IProgressMonitor monitor, final Set<? extends INode> nodes) {
        return this.performDiscovery(new DiscoveryOperation(){

            public void run(MarketplaceDiscoveryStrategy strategy, IProgressMonitor monitor) throws CoreException {
                strategy.performNodeQuery(monitor, nodes);
            }
        }, monitor);
    }

    public IStatus checkForUpdates(IProgressMonitor monitor) {
        monitor.beginTask(Messages.MarketplaceCatalog_checkingForUpdates, 10000000);
        try {
            ArrayList<MarketplaceNodeCatalogItem> updateCheckNeeded = new ArrayList<MarketplaceNodeCatalogItem>();
            for (CatalogItem catalogItem : this.getItems()) {
                MarketplaceNodeCatalogItem catalogItem2;
                if (!(catalogItem instanceof MarketplaceNodeCatalogItem) || !(catalogItem2 = (MarketplaceNodeCatalogItem)catalogItem).isInstalled()) continue;
                Boolean updateAvailable = this.updateAvailableByNodeId.get(catalogItem.getId());
                if (updateAvailable != null) {
                    catalogItem2.setUpdateAvailable(updateAvailable);
                    continue;
                }
                updateCheckNeeded.add(catalogItem2);
            }
            if (!updateCheckNeeded.isEmpty()) {
                this.checkForUpdates(updateCheckNeeded, monitor);
                for (MarketplaceNodeCatalogItem marketplaceNodeCatalogItem : updateCheckNeeded) {
                    if (marketplaceNodeCatalogItem.getUpdateAvailable() == null) continue;
                    this.updateAvailableByNodeId.put(marketplaceNodeCatalogItem.getData().getId(), marketplaceNodeCatalogItem.getUpdateAvailable());
                }
            }
            IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected IStatus checkForUpdates(List<MarketplaceNodeCatalogItem> updateCheckNeeded, IProgressMonitor monitor) {
        int remainingWork = 10000000;
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)remainingWork);
        HashMap<URI, ArrayList<MarketplaceNodeCatalogItem>> installedCatalogItemsByUpdateUri = new HashMap<URI, ArrayList<MarketplaceNodeCatalogItem>>();
        for (MarketplaceNodeCatalogItem catalogItem : updateCheckNeeded) {
            INode node = catalogItem.getData();
            try {
                String updateurl = node.getUpdateurl();
                if (updateurl == null) {
                    catalogItem.setAvailable(false);
                    continue;
                }
                URI uri = new URI(updateurl);
                ArrayList<MarketplaceNodeCatalogItem> catalogItemsThisSite = (ArrayList<MarketplaceNodeCatalogItem>)installedCatalogItemsByUpdateUri.get(uri);
                if (catalogItemsThisSite == null) {
                    catalogItemsThisSite = new ArrayList<MarketplaceNodeCatalogItem>();
                    installedCatalogItemsByUpdateUri.put(uri, catalogItemsThisSite);
                }
                catalogItemsThisSite.add(catalogItem);
            }
            catch (URISyntaxException e) {
                MarketplaceClientUi.error(e);
                catalogItem.setAvailable(false);
            }
        }
        if (installedCatalogItemsByUpdateUri.isEmpty()) {
            return Status.OK_STATUS;
        }
        Map<String, IInstallableUnit> installedIUs = MarketplaceClientUi.computeInstalledIUsById((IProgressMonitor)progress.newChild(remainingWork / 20));
        remainingWork -= remainingWork / 20;
        ConcurrentTaskManager executor = new ConcurrentTaskManager(installedCatalogItemsByUpdateUri.size(), Messages.MarketplaceCatalog_checkingForUpdates);
        try {
            NullProgressMonitor pm = new NullProgressMonitor(){

                public boolean isCanceled() {
                    return super.isCanceled() || progress.isCanceled();
                }
            };
            for (Map.Entry entry : installedCatalogItemsByUpdateUri.entrySet()) {
                final URI uri = (URI)entry.getKey();
                List catalogItemsThisSite = (List)entry.getValue();
                executor.submit(new Runnable((IProgressMonitor)pm, catalogItemsThisSite, installedIUs){
                    private final /* synthetic */ IProgressMonitor val$pm;
                    private final /* synthetic */ List val$catalogItemsThisSite;
                    private final /* synthetic */ Map val$installedIUs;
                    {
                        this.val$pm = iProgressMonitor;
                        this.val$catalogItemsThisSite = list;
                        this.val$installedIUs = map;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void run() {
                        block8: {
                            session = ProvisioningUI.getDefaultUI().getSession();
                            manager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
                            try {
                                repository = manager.loadRepository(uri, this.val$pm);
                                query = QueryUtil.createMatchQuery((String)"id ~= /*.feature.group/ && properties['org.eclipse.equinox.p2.type.group'] == true ", (Object[])new Object[0]);
                                result = repository.query(query, this.val$pm);
                                repositoryIuVersionById = new HashMap<String, Version>();
                                for (IInstallableUnit iu : result) {
                                    id = iu.getId();
                                    priorVersion = repositoryIuVersionById.put(id, version = iu.getVersion());
                                    if (priorVersion == null || priorVersion.compareTo((Object)version) <= 0) continue;
                                    repositoryIuVersionById.put(id, priorVersion);
                                }
                                block4: for (MarketplaceNodeCatalogItem item : this.val$catalogItemsThisSite) {
                                    item.setUpdateAvailable(false);
                                    installableUnits = item.getInstallableUnits();
                                    if (!repositoryIuVersionById.keySet().containsAll(installableUnits)) {
                                        item.setAvailable(false);
                                        continue;
                                    }
                                    for (String iu : installableUnits) {
                                        availableVersion = (Version)repositoryIuVersionById.get(iu);
                                        if (availableVersion == null || (installedIu = (IInstallableUnit)this.val$installedIUs.get(iu)) == null || installedIu.getVersion().compareTo((Object)availableVersion) >= 0) continue;
                                        item.setUpdateAvailable(true);
                                        continue block4;
                                    }
                                }
                                break block8;
                            }
                            catch (ProvisionException e) {
                                MarketplaceClientUi.error(e);
                                ** for (item : this.val$catalogItemsThisSite)
                            }
lbl-1000:
                            // 1 sources

                            {
                                item.setAvailable(false);
                                continue;
lbl33:
                                // 1 sources

                                break block8;
                            }
                            catch (OperationCanceledException v0) {}
                        }
                    }
                });
            }
            try {
                executor.waitUntilFinished((IProgressMonitor)progress.newChild(remainingWork));
            }
            catch (CoreException e) {
                MarketplaceClientUi.error(e);
                IStatus iStatus = e.getStatus();
                executor.shutdownNow();
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            executor.shutdownNow();
        }
    }

    public IStatus performDiscovery(IProgressMonitor monitor) {
        IStatus updateStatus;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)200000);
        IStatus status = super.performDiscovery((IProgressMonitor)progress.newChild(100000));
        if (status.getSeverity() < 4 && !(updateStatus = this.checkForUpdates((IProgressMonitor)progress.newChild(100000))).isOK()) {
            if (status.isOK()) {
                status = updateStatus;
            } else {
                MultiStatus multiStatus = new MultiStatus("org.eclipse.epp.mpc.ui", 0, Messages.MarketplaceCatalog_Discovery_Error, null);
                multiStatus.add(status);
                multiStatus.add(updateStatus);
                status = multiStatus;
            }
        }
        return this.computeStatus(status);
    }

    private IStatus computeStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            Throwable exception;
            IStatus newStatus;
            MultiStatus multiStatus;
            if (status.isMultiStatus() && (multiStatus = (MultiStatus)status).getChildren().length == 1) {
                status = multiStatus.getChildren()[0];
            }
            if (!status.isMultiStatus() && (newStatus = MarketplaceClientUi.computeWellknownProblemStatus(exception = status.getException())) != null) {
                return newStatus;
            }
        }
        return status;
    }

    protected IStatus performDiscovery(DiscoveryOperation operation, IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.epp.mpc.ui", 0, Messages.MarketplaceCatalog_queryFailed, null);
        if (this.getDiscoveryStrategies().isEmpty()) {
            throw new IllegalStateException();
        }
        ArrayList items = new ArrayList();
        ArrayList categories = new ArrayList(this.getCategories());
        ArrayList certifications = new ArrayList(this.getCertifications());
        ArrayList tags = new ArrayList(this.getTags());
        for (CatalogCategory catalogCategory : categories) {
            catalogCategory.getItems().clear();
        }
        monitor.beginTask(Messages.MarketplaceCatalog_queryingMarketplace, 100000);
        try {
            int strategyTicks = 90000 / this.getDiscoveryStrategies().size();
            for (AbstractDiscoveryStrategy discoveryStrategy : this.getDiscoveryStrategies()) {
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    break;
                }
                if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
                discoveryStrategy.setCategories(categories);
                discoveryStrategy.setItems(items);
                discoveryStrategy.setCertifications(certifications);
                discoveryStrategy.setTags(tags);
                try {
                    MarketplaceDiscoveryStrategy marketplaceStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
                    operation.run(marketplaceStrategy, (IProgressMonitor)new SubProgressMonitor(monitor, strategyTicks));
                }
                catch (CoreException e) {
                    IStatus error = MarketplaceClientUi.computeWellknownProblemStatus(e);
                    if (error == null) {
                        error = new Status(e.getStatus().getSeverity(), "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.MarketplaceCatalog_failedWithError, (Object)discoveryStrategy.getClass().getSimpleName()), (Throwable)e);
                    }
                    status.add(error);
                }
            }
            this.update(categories, items, certifications, tags);
        }
        finally {
            monitor.done();
        }
        return this.computeStatus((IStatus)status);
    }

    public IStatus performNewsDiscovery(IProgressMonitor monitor) {
        if (this.getDiscoveryStrategies().isEmpty()) {
            throw new IllegalStateException();
        }
        INews news = null;
        MultiStatus status = new MultiStatus("org.eclipse.epp.mpc.ui", 0, Messages.MarketplaceCatalog_queryFailed, null);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceCatalog_Checking_News, (int)100000);
        try {
            int strategyTicks = 100000 / this.getDiscoveryStrategies().size();
            for (AbstractDiscoveryStrategy discoveryStrategy : this.getDiscoveryStrategies()) {
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    break;
                }
                if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
                try {
                    MarketplaceDiscoveryStrategy marketplaceStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
                    news = marketplaceStrategy.performNewsDiscovery((IProgressMonitor)progress.newChild(strategyTicks));
                    if (news == null) continue;
                    break;
                }
                catch (CoreException e) {
                    status.add((IStatus)new Status(e.getStatus().getSeverity(), "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.MarketplaceCatalog_failedWithError, (Object)discoveryStrategy.getClass().getSimpleName()), (Throwable)e));
                }
            }
        }
        finally {
            monitor.done();
        }
        if (status.isOK()) {
            this.setNews(news);
        }
        return status;
    }

    public void installErrorReport(IProgressMonitor monitor, IStatus result, Set<CatalogItem> items, IInstallableUnit[] operationIUs, String resolutionDetails) {
        for (AbstractDiscoveryStrategy discoveryStrategy : this.getDiscoveryStrategies()) {
            if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
            try {
                ((MarketplaceDiscoveryStrategy)discoveryStrategy).installErrorReport(monitor, result, items, operationIUs, resolutionDetails);
            }
            catch (CoreException e) {
                MarketplaceClientUi.error(e);
            }
        }
    }

    public INews getNews() {
        return this.news;
    }

    public void setNews(INews news) {
        this.news = news;
    }

    private static interface DiscoveryOperation {
        public void run(MarketplaceDiscoveryStrategy var1, IProgressMonitor var2) throws CoreException;
    }
}

