/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.List;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractTagFilter;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckboxTagFilter
extends AbstractTagFilter {
    private Composite buttonContainer;

    @Override
    public void createControl(Composite parent) {
        if (this.getChoices() == null) {
            throw new IllegalStateException();
        }
        this.buttonContainer = new Composite(parent, 0);
        this.rebuildChoicesUi();
    }

    protected void rebuildChoicesUi() {
        if (this.buttonContainer != null) {
            Control[] controlArray = this.buttonContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            for (final Tag choice : this.getChoices()) {
                final Button checkbox = new Button(this.buttonContainer, 32);
                checkbox.setData((Object)choice);
                checkbox.setSelection(this.getSelected().contains(choice));
                checkbox.setText(choice.getLabel());
                checkbox.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        boolean selection = checkbox.getSelection();
                        if (selection) {
                            CheckboxTagFilter.this.getSelected().add(choice);
                        } else {
                            CheckboxTagFilter.this.getSelected().remove(choice);
                        }
                        CheckboxTagFilter.this.selectionUpdated();
                    }
                });
            }
            GridLayoutFactory.fillDefaults().numColumns(this.buttonContainer.getChildren().length).applyTo(this.buttonContainer);
        }
    }

    @Override
    protected void choicesChanged(List<Tag> choices, List<Tag> previousChoices) {
        this.rebuildChoicesUi();
        super.choicesChanged(choices, previousChoices);
    }

    @Override
    protected void updateUi() {
        Control[] controlArray = this.buttonContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            Object data = control.getData();
            if (data instanceof Tag && control instanceof Button) {
                Button checkbox = (Button)control;
                checkbox.setSelection(this.getSelected().contains(data));
            }
            ++n2;
        }
        super.updateUi();
    }
}

