/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty.internal;

import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;

public class EquinoxStdErrLog
implements Logger {
    private static int DEBUG = 0;
    private static int INFO = 1;
    private static int WARN = 2;
    private static int ERROR = 3;
    private static int OFF = 4;
    private static volatile int threshold = WARN;
    private static EquinoxStdErrLog root;
    private final Logger realLogger;
    private final String localName;

    public static synchronized EquinoxStdErrLog getRootLogger() {
        if (root != null) {
            return root;
        }
        root = new EquinoxStdErrLog(null, null);
        return root;
    }

    public static void setThresholdLogger(String property) {
        threshold = EquinoxStdErrLog.parseThresholdProperty(property);
        Logger rootLogger = Log.getRootLogger();
        if (rootLogger == null || rootLogger instanceof StdErrLog) {
            Log.setLog((Logger)EquinoxStdErrLog.getRootLogger());
        }
    }

    private static int parseThresholdProperty(String property) {
        if (property == null) {
            return WARN;
        }
        if (property.equals("debug")) {
            return DEBUG;
        }
        if (property.equals("info")) {
            return INFO;
        }
        if (property.equals("warn")) {
            return WARN;
        }
        if (property.equals("error")) {
            return ERROR;
        }
        if (property.equals("none")) {
            return OFF;
        }
        return WARN;
    }

    public EquinoxStdErrLog(String name, Logger realLogger) {
        this.localName = name;
        Object object = this.realLogger = realLogger == null ? new StdErrLog(name) : realLogger;
        if (threshold == DEBUG) {
            this.realLogger.setDebugEnabled(true);
        }
    }

    public Logger getLogger(String name) {
        if (name == null && this.localName == null || name != null && name.equals(this.localName)) {
            return this;
        }
        return new EquinoxStdErrLog(name, this.realLogger.getLogger(name));
    }

    public void debug(String msg, Object ... arg0) {
        if (threshold > DEBUG) {
            return;
        }
        this.realLogger.debug(msg, arg0);
    }

    public void debug(String msg, Throwable th) {
        if (threshold > DEBUG) {
            return;
        }
        this.realLogger.debug(msg, th);
    }

    public void info(String msg, Object ... arg0) {
        if (threshold > INFO) {
            return;
        }
        this.realLogger.info(msg, arg0);
    }

    public void warn(String msg, Object ... arg0) {
        if (threshold > WARN) {
            return;
        }
        this.realLogger.warn(msg, arg0);
    }

    public void warn(String msg, Throwable th) {
        if (threshold > WARN) {
            return;
        }
        if (th instanceof RuntimeException || th instanceof Error) {
            this.realLogger.warn("ERROR:  " + msg, th);
        } else if (threshold != ERROR) {
            this.realLogger.warn(msg, th);
        }
    }

    public void error(String msg, Throwable th) {
        if (threshold > ERROR) {
            return;
        }
        this.realLogger.warn("ERROR:  " + msg, th);
    }

    public String getName() {
        return this.realLogger.getName();
    }

    public void warn(Throwable thrown) {
        if (threshold > WARN) {
            return;
        }
        this.realLogger.warn(thrown);
    }

    public void info(Throwable thrown) {
        if (threshold > INFO) {
            return;
        }
        this.realLogger.info(thrown);
    }

    public void info(String msg, Throwable thrown) {
        if (threshold > INFO) {
            return;
        }
        this.realLogger.info(msg, thrown);
    }

    public boolean isDebugEnabled() {
        return threshold == DEBUG;
    }

    public void setDebugEnabled(boolean enabled) {
        threshold = DEBUG;
    }

    public void debug(Throwable thrown) {
        if (threshold > DEBUG) {
            return;
        }
        this.realLogger.debug(thrown);
    }

    public void ignore(Throwable ignored) {
        this.debug(ignored);
    }
}

