/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class FilledArgumentNamesMethodProposal
extends JavaMethodCompletionProposal {
    private IRegion fSelectedRegion;
    private int[] fArgumentOffsets;
    private int[] fArgumentLengths;

    public FilledArgumentNamesMethodProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        int baseOffset = this.getReplacementOffset();
        String replacement = this.getReplacementString();
        if (this.fArgumentOffsets != null && this.getTextViewer() != null) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != this.fArgumentOffsets.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + this.fArgumentOffsets[i], this.fArgumentLengths[i], -1));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(')', document));
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
                this.openErrorDialog(e);
            }
        } else {
            this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
        }
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    protected String computeReplacementString() {
        if (!this.hasParameters() || !this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        StringBuffer buffer = new StringBuffer();
        this.appendMethodNameReplacement(buffer);
        char[][] parameterNames = this.fProposal.findParameterNames(null);
        int count = parameterNames.length;
        this.fArgumentOffsets = new int[count];
        this.fArgumentLengths = new int[count];
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        this.setCursorPosition(buffer.length());
        if (prefs.afterOpeningParen) {
            buffer.append(" ");
        }
        int i = 0;
        while (i != count) {
            if (i != 0) {
                if (prefs.beforeComma) {
                    buffer.append(" ");
                }
                buffer.append(",");
                if (prefs.afterComma) {
                    buffer.append(" ");
                }
            }
            this.fArgumentOffsets[i] = buffer.length();
            buffer.append(parameterNames[i]);
            this.fArgumentLengths[i] = parameterNames[i].length;
            ++i;
        }
        if (prefs.beforeClosingParen) {
            buffer.append(" ");
        }
        buffer.append(")");
        if (this.canAutomaticallyAppendSemicolon()) {
            buffer.append(";");
        }
        return buffer.toString();
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.FilledArgumentNamesMethodProposal_error_msg, (String)e.getMessage());
    }
}

